/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.jearchaeology.jei;

import cy.jdkdigital.jearchaeology.jei.JeiPlugin;
import cy.jdkdigital.jearchaeology.recipe.BrushingRecipe;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class BrushRecipeCategory
implements IRecipeCategory<RecipeHolder<BrushingRecipe>> {
    private final IDrawable background;
    private final IDrawable icon;

    public BrushRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(144, 93);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.BRUSH));
    }

    @NotNull
    public RecipeType<RecipeHolder<BrushingRecipe>> getRecipeType() {
        return JeiPlugin.BRUSH_RECIPE_TYPE.get();
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"jearchaeology.recipe.brush");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<BrushingRecipe> recipe, @NotNull IFocusGroup iFocusGroup) {
        AtomicInteger i = new AtomicInteger();
        Arrays.stream(((BrushingRecipe)recipe.value()).item.getItems()).forEach(itemStack -> {
            int row = (int)Math.floor((float)i.get() / 8.0f);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, (i.get() - row * 8) * 18, row * 18).addItemStack(itemStack)).setSlotName("thing" + String.valueOf(i));
            i.set(i.get() + 1);
        });
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0, 74).addIngredients(((BrushingRecipe)recipe.value()).brushableBlock)).setSlotName("sussy_block");
    }

    public void draw(RecipeHolder<BrushingRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        String name = recipe.id().getPath().replace("archeology/", "").replace("archaeology/", "").replaceAll("_[0-9]", "");
        guiGraphics.drawString(minecraft.font, (Component)Component.translatable((String)("jearchaeology.brush.structure." + name)), 22, 78, -16777216, false);
    }
}

