/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.common.event;

import com.github.jarva.allthearcanistgear.common.items.book.AddonSpellBook;
import com.github.jarva.allthearcanistgear.datagen.EntityTypeTagDatagen;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(modid="allthearcanistgear", bus=EventBusSubscriber.Bus.GAME)
public class SpellBookEvents {
    @SubscribeEvent
    public static void onSpellDamage(SpellDamageEvent.Pre event) {
        ItemStack casterTool = event.context.getCasterTool();
        if (!event.target.getType().is(EntityTypeTagDatagen.BONUS_DAMAGE)) {
            return;
        }
        Item item = casterTool.getItem();
        if (item instanceof AddonSpellBook) {
            AddonSpellBook addonSpellBook = (AddonSpellBook)item;
            event.damage = (float)((double)event.damage * (Double)addonSpellBook.getConfig().bonusDamageMultiplier().get());
        }
    }

    @SubscribeEvent
    public static void onSpellCost(SpellCostCalcEvent event) {
        SpellBook spellBook;
        ItemStack casterTool = event.context.getCasterTool();
        Item item = casterTool.getItem();
        if (item instanceof SpellBook && (spellBook = (SpellBook)item).getTier() == SpellTier.CREATIVE) {
            event.currentCost = 0;
        }
    }
}

