/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthetweaks.proxy;

import com.mojang.blaze3d.platform.MacosUtil;
import com.mojang.blaze3d.platform.NativeImage;
import com.thevortex.allthetweaks.AllTheTweaks;
import com.thevortex.allthetweaks.config.Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class MyCons {
    private static String getPrefix() {
        return switch ((Integer)Configuration.COMMON.mainmode.get()) {
            case 5 -> "icons_grav";
            case 3 -> "icons_magic";
            case 2 -> "icons_sky";
            case 1 -> "icons_slop";
            default -> "icons";
        };
    }

    private static List<IoSupplier<InputStream>> getStandardIcons() {
        short[] sizes;
        ArrayList<IoSupplier<InputStream>> list = new ArrayList<IoSupplier<InputStream>>();
        String prefix = MyCons.getPrefix();
        for (short size : sizes = new short[]{16, 32, 48, 128, 256}) {
            String location = String.format("textures/%s/icon_%sx%s.png", prefix, size, size);
            Optional resource = Minecraft.getInstance().getResourceManager().getResource(ResourceLocation.fromNamespaceAndPath((String)"allthetweaks", (String)location));
            resource.ifPresent(value -> list.add(() -> ((Resource)value).open()));
        }
        return list;
    }

    @Nullable
    private static IoSupplier<InputStream> getMacIcon() {
        String prefix = MyCons.getPrefix();
        String location = String.format("textures/%s/mac_icon.icns", prefix);
        Optional resourceOpt = Minecraft.getInstance().getResourceManager().getResource(ResourceLocation.fromNamespaceAndPath((String)"allthetweaks", (String)location));
        if (resourceOpt.isPresent()) {
            return () -> ((Resource)resourceOpt.get()).open();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWindowIcon() throws IOException {
        int i = GLFW.glfwGetPlatform();
        switch (i) {
            case 393217: 
            case 393220: {
                List<IoSupplier<InputStream>> list = MyCons.getStandardIcons();
                ArrayList<ByteBuffer> list1 = new ArrayList<ByteBuffer>(list.size());
                try (MemoryStack memorystack = MemoryStack.stackPush();){
                    GLFWImage.Buffer buffer = GLFWImage.malloc((int)list.size(), (MemoryStack)memorystack);
                    for (int j = 0; j < list.size(); ++j) {
                        try (NativeImage nativeimage = NativeImage.read((InputStream)((InputStream)list.get(j).get()));){
                            ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)(nativeimage.getWidth() * nativeimage.getHeight() * 4));
                            list1.add(bytebuffer);
                            bytebuffer.asIntBuffer().put(nativeimage.getPixelsRGBA());
                            buffer.position(j);
                            buffer.width(nativeimage.getWidth());
                            buffer.height(nativeimage.getHeight());
                            buffer.pixels(bytebuffer);
                            continue;
                        }
                    }
                    GLFW.glfwSetWindowIcon((long)Minecraft.getInstance().getWindow().getWindow(), (GLFWImage.Buffer)((GLFWImage.Buffer)buffer.position(0)));
                    break;
                }
                finally {
                    list1.forEach(MemoryUtil::memFree);
                }
            }
            case 393218: {
                IoSupplier<InputStream> icon = MyCons.getMacIcon();
                if (icon == null) break;
                MacosUtil.loadIcon(icon);
                break;
            }
            case 393219: 
            case 393221: {
                break;
            }
            default: {
                AllTheTweaks.LOGGER.error("Couldn't set icon for platform {}", (Object)i);
            }
        }
    }
}

