/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthetweaks.datagen.server;

import com.thevortex.allthetweaks.blocks.TweakBlocks;
import com.thevortex.allthetweaks.config.Reference;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class CraftingRecipes
extends RecipeProvider {
    public CraftingRecipes(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, provider);
    }

    private ShapedRecipeBuilder shaped(ItemLike provider) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)provider).group("allthetweaks");
    }

    private ResourceLocation recipeDir(String typeIn, String typeOut) {
        return ResourceLocation.fromNamespaceAndPath((String)"allthetweaks", (String)(typeIn + "_from_" + typeOut));
    }

    protected void buildRecipes(RecipeOutput consumer) {
        this.shapelessCrafting(consumer);
        this.shaped((ItemLike)TweakBlocks.ENDERPEARL_BLOCK.get()).pattern("ppp").pattern("ppp").pattern("ppp").define(Character.valueOf('p'), Tags.Items.ENDER_PEARLS).unlockedBy("has_ender_pearl", CraftingRecipes.has((TagKey)Tags.Items.ENDER_PEARLS)).save(consumer);
        this.shaped((ItemLike)TweakBlocks.NETHERSTAR_BLOCK.get()).pattern("sss").pattern("sss").pattern("sss").define(Character.valueOf('s'), Tags.Items.NETHER_STARS).unlockedBy("has_nether_star", CraftingRecipes.has((TagKey)Tags.Items.NETHER_STARS)).save(consumer);
        this.shaped((ItemLike)TweakBlocks.ATMSTAR_BLOCK.get()).pattern("aaa").pattern("aaa").pattern("aaa").define(Character.valueOf('a'), Reference.ATMSTAR).unlockedBy("has_atm_star", CraftingRecipes.has(Reference.ATMSTAR)).save(consumer);
        this.shaped((ItemLike)TweakBlocks.GREGSTAR_BLOCK.get()).pattern("aaa").pattern("aaa").pattern("aaa").define(Character.valueOf('a'), Reference.GREGSTAR).unlockedBy(CraftingRecipes.getHasName((ItemLike)((ItemLike)TweakBlocks.GREGSTAR_BLOCK.get())), CraftingRecipes.has(Reference.GREGSTAR)).save(consumer);
    }

    protected void shapelessCrafting(RecipeOutput consumer) {
        String hasCondition = "has_item";
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TweakBlocks.ATMSTAR.get()), (int)9).requires(Reference.ATMSTAR_BLOCK_ITEM).unlockedBy(CraftingRecipes.getHasName((ItemLike)((ItemLike)TweakBlocks.ATMSTAR_BLOCK_ITEM.get())), CraftingRecipes.has(Reference.ATMSTAR_BLOCK_ITEM)).save(consumer, this.recipeDir("atm_star", "atmstar_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TweakBlocks.GREGSTAR.get()), (int)9).requires(Reference.GREGSTAR_BLOCK_ITEM).unlockedBy(CraftingRecipes.getHasName((ItemLike)((ItemLike)TweakBlocks.GREGSTAR_BLOCK_ITEM.get())), CraftingRecipes.has(Reference.GREGSTAR_BLOCK_ITEM)).save(consumer, this.recipeDir("greg_star", "gregstar_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.ENDER_PEARL, (int)9).requires(Reference.ENDERPEARL_BLOCK_ITEM).unlockedBy(CraftingRecipes.getHasName((ItemLike)((ItemLike)TweakBlocks.ENDERPEARL_BLOCK_ITEM.get())), CraftingRecipes.has(Reference.ENDERPEARL_BLOCK_ITEM)).save(consumer, this.recipeDir("ender_pearl", "ender_pearl_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.NETHER_STAR, (int)9).requires(Reference.NETHERSTAR_BLOCK_ITEM).unlockedBy(CraftingRecipes.getHasName((ItemLike)((ItemLike)TweakBlocks.NETHERSTAR_BLOCK_ITEM.get())), CraftingRecipes.has(Reference.NETHERSTAR_BLOCK_ITEM)).save(consumer, this.recipeDir("nether_star", "nether_star_block"));
    }
}

