/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.table.infusion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.table.EnchantingStatRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class InfusionRecipe
implements Recipe<RecipeInput> {
    public static final EnchantingStatRegistry.Stats NO_MAX = new EnchantingStatRegistry.Stats(-1.0f, -1.0f, -1.0f, -1.0f, -1);
    public static final Serializer SERIALIZER = new Serializer();
    protected final ItemStack output;
    protected final Ingredient input;
    protected final EnchantingStatRegistry.Stats requirements;
    protected final EnchantingStatRegistry.Stats maxRequirements;

    public InfusionRecipe(ItemStack output, Ingredient input, EnchantingStatRegistry.Stats requirements, EnchantingStatRegistry.Stats maxRequirements) {
        this.output = output;
        this.input = input;
        this.requirements = requirements;
        this.maxRequirements = maxRequirements;
        if (maxRequirements.eterna() != -1.0f && requirements.eterna() > maxRequirements.eterna()) {
            throw new UnsupportedOperationException("Invalid min/max eterna bounds (min > max).");
        }
        if (maxRequirements.quanta() != -1.0f && requirements.quanta() > maxRequirements.quanta()) {
            throw new UnsupportedOperationException("Invalid min/max quanta bounds (min > max).");
        }
        if (maxRequirements.arcana() != -1.0f && requirements.arcana() > maxRequirements.arcana()) {
            throw new UnsupportedOperationException("Invalid min/max arcana bounds (min > max).");
        }
    }

    public boolean matches(ItemStack input, float eterna, float quanta, float arcana) {
        if (this.maxRequirements.eterna() > -1.0f && eterna > this.maxRequirements.eterna() || this.maxRequirements.quanta() > -1.0f && quanta > this.maxRequirements.quanta() || this.maxRequirements.arcana() > -1.0f && arcana > this.maxRequirements.arcana()) {
            return false;
        }
        return this.input.test(input) && eterna >= this.requirements.eterna() && quanta >= this.requirements.quanta() && arcana >= this.requirements.arcana();
    }

    public EnchantingStatRegistry.Stats getRequirements() {
        return this.requirements;
    }

    public EnchantingStatRegistry.Stats getMaxRequirements() {
        return this.maxRequirements;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack assemble(ItemStack input, float eterna, float quanta, float arcana) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public RecipeType<?> getType() {
        return Ench.RecipeTypes.INFUSION;
    }

    @Nullable
    public static InfusionRecipe findMatch(Level level, ItemStack input, float eterna, float quanta, float arcana) {
        return level.getRecipeManager().getAllRecipesFor(Ench.RecipeTypes.INFUSION).stream().map(RecipeHolder::value).sorted((r1, r2) -> -Float.compare(r1.requirements.eterna(), r2.requirements.eterna())).filter(r -> r.matches(input, eterna, quanta, arcana)).findFirst().orElse(null);
    }

    @Nullable
    public static InfusionRecipe findItemMatch(Level level, ItemStack toEnchant) {
        return level.getRecipeManager().getAllRecipesFor(Ench.RecipeTypes.INFUSION).stream().map(RecipeHolder::value).filter(r -> r.getInput().test(toEnchant)).findFirst().orElse(null);
    }

    @Deprecated
    public boolean matches(RecipeInput pContainer, Level pLevel) {
        return false;
    }

    @Deprecated
    public ItemStack assemble(RecipeInput pContainer, HolderLookup.Provider regs) {
        return ItemStack.EMPTY;
    }

    @Deprecated
    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    @Deprecated
    public ItemStack getResultItem(HolderLookup.Provider regs) {
        return this.output;
    }

    public static class Serializer
    implements RecipeSerializer<InfusionRecipe> {
        public static final MapCodec<InfusionRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ItemStack.CODEC.fieldOf("result").forGetter(InfusionRecipe::getOutput), (App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(InfusionRecipe::getInput), (App)EnchantingStatRegistry.Stats.CODEC.fieldOf("requirements").forGetter(InfusionRecipe::getRequirements), (App)EnchantingStatRegistry.Stats.CODEC.optionalFieldOf("max_requirements", (Object)NO_MAX).forGetter(InfusionRecipe::getMaxRequirements)).apply((Applicative)inst, InfusionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InfusionRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, InfusionRecipe::getOutput, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, InfusionRecipe::getInput, EnchantingStatRegistry.Stats.STREAM_CODEC, InfusionRecipe::getRequirements, EnchantingStatRegistry.Stats.STREAM_CODEC, InfusionRecipe::getMaxRequirements, InfusionRecipe::new);

        public MapCodec<InfusionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, InfusionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

