/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.data;

import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.enchantments.components.BerserkingComponent;
import dev.shadowsoffire.apothic_enchanting.enchantments.components.BoonComponent;
import dev.shadowsoffire.apothic_enchanting.enchantments.components.ReflectiveComponent;
import dev.shadowsoffire.apothic_enchanting.enchantments.entity_effects.ReboundingEffect;
import dev.shadowsoffire.apothic_enchanting.enchantments.values.ExponentialLevelBasedValue;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.AddValue;
import net.minecraft.world.item.enchantment.effects.ApplyMobEffect;
import net.minecraft.world.item.enchantment.effects.DamageItem;
import net.minecraft.world.item.enchantment.effects.SetValue;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.EnchantmentLevelProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.holdersets.OrHolderSet;

public class ApothEnchantmentProvider {
    public static void bootstrap(BootstrapContext<Enchantment> context) {
        HolderGetter enchantments = context.lookup(Registries.ENCHANTMENT);
        HolderGetter items = context.lookup(Registries.ITEM);
        HolderGetter blocks = context.lookup(Registries.BLOCK);
        ApothEnchantmentProvider.register(context, Ench.Enchantments.BERSERKERS_FURY, ApothEnchantmentProvider.enchantment(Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.CHEST_ARMOR_ENCHANTABLE), (int)1, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)50, (int)40), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)10, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.CHEST})).withCustomName(c -> c.withStyle(ChatFormatting.DARK_RED)).withSpecialEffect(Ench.EnchantEffects.BERSERKING, (Object)new BerserkingComponent(List.of(ApothEnchantmentProvider.noCondition(new AddValue((LevelBasedValue)new ExponentialLevelBasedValue(2.5f)))), List.of(ApothEnchantmentProvider.noCondition(ApothEnchantmentProvider.simpleMobEffect((Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE, 500)), ApothEnchantmentProvider.noCondition(ApothEnchantmentProvider.simpleMobEffect((Holder<MobEffect>)MobEffects.DAMAGE_BOOST, 500)), ApothEnchantmentProvider.noCondition(ApothEnchantmentProvider.simpleMobEffect((Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 500))), List.of(ApothEnchantmentProvider.noCondition(new AddValue((LevelBasedValue)LevelBasedValue.constant((float)900.0f)))))));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.CHAINSAW, ApothEnchantmentProvider.enchantment(Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.AXES), (int)1, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)55), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)10, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withCustomName(c -> c.withStyle(ChatFormatting.DARK_GREEN)).withEffect(Ench.EnchantEffects.CHAINSAW));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.CHROMATIC, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(Tags.Items.TOOLS_SHEAR), (int)5, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)25), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})).withEffect(Ench.EnchantEffects.CHROMATIC));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.WORKER_EXPLOITATION, ApothEnchantmentProvider.enchantment(Enchantment.definition((HolderSet)items.getOrThrow(Tags.Items.TOOLS_SHEAR), (int)2, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)30), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)5, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})).withCustomName(c -> c.withStyle(ChatFormatting.DARK_PURPLE)).withEffect(Ench.EnchantEffects.EXPLOITATION));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.GROWTH_SERUM, ApothEnchantmentProvider.enchantment(Enchantment.definition((HolderSet)items.getOrThrow(Tags.Items.TOOLS_SHEAR), (int)1, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)40), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)10, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})).withCustomName(c -> c.withStyle(ChatFormatting.DARK_GREEN)).withSpecialEffect(Ench.EnchantEffects.GROWTH_SERUM, (Object)Float.valueOf(0.5f)));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.TEMPTING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.HOES), (int)5, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)0), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})).withEffect(Ench.EnchantEffects.TEMPTING));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.STABLE_FOOTING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.FOOT_ARMOR_ENCHANTABLE), (int)2, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)40), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.FEET})).withEffect(Ench.EnchantEffects.STABLE_FOOTING));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.SHIELD_BASH, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(Tags.Items.TOOLS_SHIELD), (int)2, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)17), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).exclusiveWith((HolderSet)enchantments.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)3.5f))).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.ATTACKER, (Object)new DamageItem((LevelBasedValue)new LevelBasedValue.Clamped((LevelBasedValue)LevelBasedValue.perLevel((float)20.0f, (float)-2.0f), 1.0f, 1024.0f))));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.BOON_OF_THE_EARTH, ApothEnchantmentProvider.enchantment(Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.PICKAXES), (int)1, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)55, (int)25), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)10, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withCustomName(c -> c.withStyle(ChatFormatting.DARK_GREEN)).withSpecialEffect(Ench.EnchantEffects.EARTHS_BOON, (Object)new BoonComponent(List.of(new BoonComponent.BoonData((HolderSet<Block>)blocks.getOrThrow(BlockTags.DEEPSLATE_ORE_REPLACEABLES), Ench.LootTables.BOON_DEEPSLATE_DROPS, List.of(ApothEnchantmentProvider.noCondition(new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)0.015f))))), new BoonComponent.BoonData((HolderSet<Block>)blocks.getOrThrow(BlockTags.STONE_ORE_REPLACEABLES), Ench.LootTables.BOON_STONE_DROPS, List.of(ApothEnchantmentProvider.noCondition(new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)0.01f))))), new BoonComponent.BoonData((HolderSet<Block>)blocks.getOrThrow(BlockTags.BASE_STONE_NETHER), Ench.LootTables.BOON_NETHER_DROPS, List.of(ApothEnchantmentProvider.noCondition(new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)0.01f)))))))));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.CRESCENDO_OF_BOLTS, ApothEnchantmentProvider.enchantment(Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.CROSSBOW_ENCHANTABLE), (int)1, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)55, (int)30), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)10, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})).withCustomName(c -> c.withStyle(ChatFormatting.DARK_GREEN)).withEffect(Ench.EnchantEffects.CRESCENDO, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)1.0f))));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.ENDLESS_QUIVER, ApothEnchantmentProvider.enchantment(Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.BOW_ENCHANTABLE), (int)1, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)60), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)10, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})).withCustomName(c -> c.withStyle(ChatFormatting.DARK_GREEN)).exclusiveWith((HolderSet)HolderSet.direct((Holder[])new Holder[]{enchantments.getOrThrow(Enchantments.INFINITY)})).withEffect(EnchantmentEffectComponents.AMMO_USE, (Object)new SetValue((LevelBasedValue)LevelBasedValue.constant((float)0.0f))));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.LIFE_MENDING, ApothEnchantmentProvider.enchantment(Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.DURABILITY_ENCHANTABLE), (int)1, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)65, (int)35), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)10, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})).withCustomName(c -> c.withStyle(ChatFormatting.DARK_RED)).exclusiveWith((HolderSet)HolderSet.direct((Holder[])new Holder[]{enchantments.getOrThrow(Enchantments.MENDING)})).withEffect(Ench.EnchantEffects.REPAIR_WITH_HP, (Object)new AddValue((LevelBasedValue)new ExponentialLevelBasedValue(2.0f, (LevelBasedValue)LevelBasedValue.perLevel((float)0.0f, (float)1.0f)))));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.MINERS_FERVOR, ApothEnchantmentProvider.enchantment(Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.MINING_ENCHANTABLE), (int)2, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)45, (int)30), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)10, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withCustomName(c -> c.withStyle(ChatFormatting.DARK_PURPLE)).exclusiveWith((HolderSet)HolderSet.direct((Holder[])new Holder[]{enchantments.getOrThrow(Enchantments.EFFICIENCY)})).withSpecialEffect(Ench.EnchantEffects.MINERS_FERVOR, (Object)LevelBasedValue.perLevel((float)12.0f, (float)4.5f)));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.KNOWLEDGE_OF_THE_AGES, ApothEnchantmentProvider.enchantment(Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.SHARP_WEAPON_ENCHANTABLE), (HolderSet)items.getOrThrow(ItemTags.SWORD_ENCHANTABLE), (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)55, (int)45), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)10, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withCustomName(c -> c.withStyle(ChatFormatting.DARK_GREEN)).withEffect(Ench.EnchantEffects.DROPS_TO_XP, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)25.0f))));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.SCAVENGER, ApothEnchantmentProvider.enchantment(Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.SHARP_WEAPON_ENCHANTABLE), (HolderSet)items.getOrThrow(ItemTags.SWORD_ENCHANTABLE), (int)1, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)55, (int)50), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)10, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withCustomName(c -> c.withStyle(ChatFormatting.DARK_GREEN)).withEffect(Ench.EnchantEffects.EXTRA_LOOT_ROLL, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)0.025f))));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.REFLECTIVE_DEFENSES, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(Tags.Items.TOOLS_SHIELD), (int)2, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)0, (int)18), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)5, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})).withSpecialEffect(Ench.EnchantEffects.REFLECTIVE, (Object)new ReflectiveComponent((LevelBasedValue)LevelBasedValue.perLevel((float)0.15f, (float)0.1f), (LevelBasedValue)LevelBasedValue.perLevel((float)0.15f))));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.ICY_THORNS, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.CHEST_ARMOR_ENCHANTABLE), (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)35, (int)20), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)5, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.CHEST})).exclusiveWith((HolderSet)HolderSet.direct((Holder[])new Holder[]{enchantments.getOrThrow(Enchantments.THORNS)})).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.VICTIM, EnchantmentTarget.ATTACKER, (Object)new ApplyMobEffect((HolderSet)HolderSet.direct((Holder[])new Holder[]{MobEffects.MOVEMENT_SLOWDOWN}), (LevelBasedValue)LevelBasedValue.constant((float)10.0f), (LevelBasedValue)LevelBasedValue.constant((float)20.0f), (LevelBasedValue)LevelBasedValue.constant((float)0.0f), (LevelBasedValue)new LevelBasedValue.Clamped((LevelBasedValue)LevelBasedValue.perLevel((float)2.0f), 1.0f, 4.0f)), LootItemRandomChanceCondition.randomChance((NumberProvider)EnchantmentLevelProvider.forEnchantmentLevel((LevelBasedValue)LevelBasedValue.perLevel((float)0.5f)))));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.INFUSION, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)HolderSet.empty(), (int)1, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)0), (Enchantment.Cost)Enchantment.constantCost((int)0), (int)0, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.REBOUNDING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)new OrHolderSet(List.of(items.getOrThrow(ItemTags.CHEST_ARMOR_ENCHANTABLE), items.getOrThrow(ItemTags.LEG_ARMOR_ENCHANTABLE))), (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)22, (int)18), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)5, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ARMOR})).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.VICTIM, EnchantmentTarget.ATTACKER, (Object)new ReboundingEffect((LevelBasedValue)LevelBasedValue.constant((float)4.0f), (LevelBasedValue)LevelBasedValue.perLevel((float)2.0f), (LevelBasedValue)LevelBasedValue.perLevel((float)3.0f))));
        ApothEnchantmentProvider.register(context, Ench.Enchantments.NATURES_BLESSING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.HOES), (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)15, (int)10), (Enchantment.Cost)Enchantment.constantCost((int)200), (int)3, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})).withSpecialEffect(Ench.EnchantEffects.BONEMEAL_CROPS, (Object)LevelBasedValue.perLevel((float)5.0f, (float)-1.0f)));
        ApothEnchantmentProvider.register(context, (ResourceKey<Enchantment>)Enchantments.SHARPNESS, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.SHARP_WEAPON_ENCHANTABLE), (HolderSet)items.getOrThrow(ItemTags.SWORD_ENCHANTABLE), (int)10, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)11), (Enchantment.Cost)Enchantment.dynamicCost((int)21, (int)11), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(EnchantmentEffectComponents.DAMAGE, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)1.0f, (float)0.5f))));
        ApothEnchantmentProvider.register(context, (ResourceKey<Enchantment>)Enchantments.PROTECTION, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(ItemTags.ARMOR_ENCHANTABLE), (int)10, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)11), (Enchantment.Cost)Enchantment.dynamicCost((int)12, (int)11), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ARMOR})).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)1.0f)), DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.isNot((TagKey)DamageTypeTags.BYPASSES_INVULNERABILITY)))));
    }

    private static void register(BootstrapContext<Enchantment> context, ResourceKey<Enchantment> key, Enchantment.Builder builder) {
        context.register(key, (Object)builder.build(key.location()));
    }

    private static <T> ConditionalEffect<T> noCondition(T obj) {
        return new ConditionalEffect(obj, Optional.empty());
    }

    private static BerserkingComponent.VariableMobEffect simpleMobEffect(Holder<MobEffect> effect, int duration) {
        return new BerserkingComponent.VariableMobEffect(effect, List.of(new AddValue((LevelBasedValue)LevelBasedValue.constant((float)duration))), List.of(new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)0.0f, (float)1.0f))), false, true, Optional.empty());
    }

    private static NamedBuilder enchantment(Enchantment.EnchantmentDefinition definition) {
        return new NamedBuilder(definition);
    }

    private static class NamedBuilder
    extends Enchantment.Builder {
        private UnaryOperator<MutableComponent> op = UnaryOperator.identity();

        public NamedBuilder(Enchantment.EnchantmentDefinition definition) {
            super(definition);
        }

        public Enchantment.Builder withCustomName(UnaryOperator<MutableComponent> op) {
            this.op = op;
            return this;
        }

        public Enchantment build(ResourceLocation location) {
            return new Enchantment((Component)this.op.apply(Component.translatable((String)Util.makeDescriptionId((String)"enchantment", (ResourceLocation)location))), this.definition, this.exclusiveSet, this.effectMapBuilder.build());
        }
    }
}

