/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thevortex.allthemodium.registry.ModRegistry;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class BottomBranchDecorator
extends TreeDecorator {
    public static final MapCodec<BottomBranchDecorator> CODEC = RecordCodecBuilder.mapCodec(decoratorInstance -> decoratorInstance.group((App)BlockColumnConfiguration.Layer.CODEC.listOf().fieldOf("layers").forGetter(BottomBranchDecorator::getLayers), (App)Codec.FLOAT.fieldOf("probability").orElse((Object)Float.valueOf(0.5f)).forGetter(BottomBranchDecorator::getProbability), (App)Codec.INT.fieldOf("max_blocks").orElse((Object)100).forGetter(BottomBranchDecorator::getMaxBlocks)).apply((Applicative)decoratorInstance, BottomBranchDecorator::new));
    private final float probability;
    private final int maxBlocks;
    private final List<BlockColumnConfiguration.Layer> layers;

    public BottomBranchDecorator(List<BlockColumnConfiguration.Layer> layers, float probability, int maxBlocks) {
        this.layers = layers;
        this.probability = probability;
        this.maxBlocks = maxBlocks;
    }

    private float getProbability() {
        return this.probability;
    }

    private int getMaxBlocks() {
        return this.maxBlocks;
    }

    private List<BlockColumnConfiguration.Layer> getLayers() {
        return this.layers;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)ModRegistry.BOTTOM_BRANCH_DECORATOR.get();
    }

    public void place(TreeDecorator.Context context) {
        if (context.leaves().isEmpty()) {
            return;
        }
        AtomicInteger count = new AtomicInteger();
        RandomSource rand = context.random();
        context.logs().forEach(blockPos -> {
            if (count.get() < this.maxBlocks && context.isAir(blockPos.below()) && rand.nextFloat() < this.probability) {
                for (BlockColumnConfiguration.Layer layer : this.layers) {
                    context.setBlock(blockPos.below(), layer.state().getState(rand, blockPos.below()));
                    count.getAndIncrement();
                }
            }
        });
    }
}

