/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.fluid;

import com.thevortex.allthemodium.registry.FluidRegistry;
import com.thevortex.allthemodium.registry.FluidTypeRegistry;
import com.thevortex.allthemodium.registry.ModRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidType;

public class FluidATM
extends FlowingFluid {
    public Fluid getFlowing() {
        return (Fluid)FluidRegistry.FLOWING_ALLTHEMODIUM.get();
    }

    public Fluid getSource() {
        return (Fluid)FluidRegistry.ALLTHEMODIUM.get();
    }

    public Item getBucket() {
        return (Item)ModRegistry.MOLTEN_ATM_BUCKET.get();
    }

    protected void animateTick(Level level, BlockPos blockPos, FluidState state, RandomSource randomSource) {
        super.animateTick(level, blockPos, state, randomSource);
        if (!state.isSource() && !((Boolean)state.getValue((Property)FALLING)).booleanValue()) {
            if (randomSource.nextInt(64) == 0) {
                level.playLocalSound((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, randomSource.nextFloat() * 0.25f + 0.75f, randomSource.nextFloat() + 0.5f, false);
            }
        } else if (randomSource.nextInt(10) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.UNDERWATER, (double)blockPos.getX() + randomSource.nextDouble(), (double)blockPos.getY() + randomSource.nextDouble(), (double)blockPos.getZ() + randomSource.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    protected ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_HONEY;
    }

    protected boolean canConvertToSource(Level level) {
        return false;
    }

    protected void beforeDestroyingBlock(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.hasBlockEntity() ? worldIn.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    protected int getSlopeFindDistance(LevelReader p_76074_) {
        return 4;
    }

    protected BlockState createLegacyBlock(FluidState p_76136_) {
        return (BlockState)((Block)ModRegistry.MOLTEN_ATM_BLOCK.get()).defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(FluidATM.getLegacyLevel((FluidState)p_76136_)));
    }

    public boolean isSource(FluidState p_76140_) {
        return false;
    }

    public int getAmount(FluidState p_164509_) {
        return 4;
    }

    public boolean isSame(Fluid fluidIn) {
        return fluidIn == FluidRegistry.ALLTHEMODIUM.get() || fluidIn == FluidRegistry.FLOWING_ALLTHEMODIUM.get();
    }

    protected int getDropOff(LevelReader p_76087_) {
        return 1;
    }

    public int getTickDelay(LevelReader p_76120_) {
        return 8;
    }

    protected boolean canBeReplacedWith(FluidState p_76127_, BlockGetter p_76128_, BlockPos p_76129_, Fluid p_76130_, Direction p_76131_) {
        return p_76131_ == Direction.DOWN && p_76127_.getFluidType() != FluidTypeRegistry.ATM.get();
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    public FluidType getFluidType() {
        return (FluidType)FluidTypeRegistry.ATM.get();
    }

    public static class Source
    extends FluidATM {
        @Override
        public int getAmount(FluidState p_164509_) {
            return 8;
        }

        @Override
        public boolean isSource(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends FluidATM {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> p_76046_) {
            super.createFluidStateDefinition(p_76046_);
            p_76046_.add(new Property[]{LEVEL});
        }

        @Override
        public int getAmount(FluidState p_164509_) {
            return (Integer)p_164509_.getValue((Property)LEVEL);
        }

        @Override
        public boolean isSource(FluidState state) {
            return false;
        }
    }
}

