/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.datagen.server;

import com.thevortex.allthemodium.blocks.ATMBrushableBlock;
import com.thevortex.allthemodium.blocks.Allthemodium_Ore;
import com.thevortex.allthemodium.blocks.AncientLeavesBottom;
import com.thevortex.allthemodium.blocks.DemonicLeavesBottom;
import com.thevortex.allthemodium.blocks.SoulLeavesBottom;
import com.thevortex.allthemodium.blocks.Unobtainium_Ore;
import com.thevortex.allthemodium.blocks.Vibranium_Ore;
import com.thevortex.allthemodium.registry.ModRegistry;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.loot.CanItemPerformAbility;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ATMLootTables
extends VanillaBlockLoot {
    private static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public ATMLootTables(HolderLookup.Provider p_344962_) {
        super(p_344962_);
    }

    public void generate() {
        this.getKnownBlocks().forEach(this::dropRaw);
        this.add((Block)ModRegistry.ANCIENT_PODZOL.get(), b -> this.createSingleItemTableWithSilkTouch((Block)b, (ItemLike)Blocks.DIRT));
        this.dropWhenSilkTouch((Block)ModRegistry.ANCIENT_FERN.get());
    }

    private void dropRaw(Block block) {
        if (block.getName().getString().contains("ancient_bookshelf")) {
            this.add((Block)ModRegistry.ANCIENT_BOOKSHELF.get(), p_124241_ -> this.createSingleItemTableWithSilkTouch((Block)p_124241_, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
        }
        String oretype = block.getName().getString();
        if (block instanceof Allthemodium_Ore) {
            this.add(block, block1 -> this.createOreDrop((Block)block1, (Item)ModRegistry.RAW_ALLTHEMODIUM.get()));
        } else if (block instanceof Vibranium_Ore) {
            this.add(block, block1 -> this.createOreDrop((Block)block1, (Item)ModRegistry.RAW_VIBRANIUM.get()));
        } else if (block instanceof Unobtainium_Ore) {
            this.add(block, block1 -> this.createOreDrop((Block)block1, (Item)ModRegistry.RAW_UNOBTAINIUM.get()));
        } else if (oretype.contains("raw_")) {
            this.dropSelf(block);
        } else if (block instanceof LeavesBlock) {
            this.add(block, this.createLeavesDrops(block, (Block)BuiltInRegistries.BLOCK.get(BuiltInRegistries.BLOCK.getKey((Object)block).withPath(p -> p.replace("_leaves", "_sapling"))), NORMAL_LEAVES_SAPLING_CHANCES));
        } else if (block instanceof DoorBlock) {
            this.add(block, this.createDoorTable(block));
        } else {
            this.dropSelf(block);
        }
    }

    protected Iterable<Block> getKnownBlocks() {
        List<Block> list = Stream.of(ModRegistry.BLOCKS.getEntries(), ModRegistry.STAIRBLOCKS.getEntries(), ModRegistry.SLABBLOCKS.getEntries(), ModRegistry.WALLBLOCKS.getEntries(), ModRegistry.PILLARBLOCKS.getEntries()).flatMap(Collection::stream).map(DeferredHolder::get).filter(block -> !(block instanceof ATMBrushableBlock)).filter(block -> !(block instanceof AncientLeavesBottom)).filter(block -> !(block instanceof DemonicLeavesBottom)).filter(block -> !(block instanceof SoulLeavesBottom)).filter(block -> !(block instanceof LiquidBlock)).collect(Collectors.toList());
        list.add((Block)ModRegistry.TELEPORT_PAD.get());
        return list;
    }

    public LootItemCondition.Builder hasShearsOrSilkTouch() {
        return CanItemPerformAbility.canItemPerformAbility((ItemAbility)ItemAbilities.SHEARS_HARVEST).or(this.hasSilkTouch());
    }
}

