/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.datagen.builder;

import com.thevortex.allthemodium.datagen.RecipeException;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ShapedBlockBuilder {
    private final String criteriaName;
    private final Criterion<InventoryChangeTrigger.TriggerInstance> criterion;
    private final EnumMap<Slot, Item> pieces = new EnumMap(Slot.class);
    private final TagKey<Item> ingot;

    public ShapedBlockBuilder(TagKey<Item> ingot) {
        this.ingot = ingot;
        this.criteriaName = String.format("has_%s_ingot", ingot);
        ItemPredicate predicate = ItemPredicate.Builder.item().of(ingot).build();
        this.criterion = InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{predicate});
    }

    public static ShapedBlockBuilder builder(TagKey<Item> ingot) {
        return new ShapedBlockBuilder(ingot);
    }

    public ShapedBlockBuilder setBlock(Item object) {
        this.pieces.put(Slot.BLOCK, object);
        return this;
    }

    public ShapedBlockBuilder setGear(DeferredHolder<Item, Item> object) {
        this.pieces.put(Slot.GEAR, (Item)object.get());
        return this;
    }

    public ShapedBlockBuilder setPlate(DeferredHolder<Item, Item> object) {
        this.pieces.put(Slot.PLATE, (Item)object.get());
        return this;
    }

    public ShapedBlockBuilder setRod(DeferredHolder<Item, Item> object) {
        this.pieces.put(Slot.ROD, (Item)object.get());
        return this;
    }

    protected void validate(ResourceLocation id) {
        if (this.pieces.isEmpty()) {
            throw new RecipeException(id.toString(), "recipe must have at least 1 output");
        }
    }

    public void build(RecipeOutput consumer) {
        Consumer<ShapedRecipeBuilder> register = builder -> builder.save(consumer);
        Optional.ofNullable(this.pieces.get((Object)Slot.BLOCK)).map(this::block).map(this::addCriterionIngot).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.GEAR)).map(this::gear).map(this::addCriterionIngot).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.ROD)).map(this::rod).map(this::addCriterionIngot).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.PLATE)).map(this::plate).map(this::addCriterionIngot).ifPresent(register);
    }

    private ShapedRecipeBuilder shaped(ItemLike provider) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)provider).group("allthemodium");
    }

    private ShapedRecipeBuilder addCriterionIngot(ShapedRecipeBuilder builder) {
        return builder.define(Character.valueOf('a'), this.ingot).unlockedBy(this.criteriaName, this.criterion);
    }

    private ShapedRecipeBuilder block(ItemLike provider) {
        return this.shaped(provider).pattern("aaa").pattern("aaa").pattern("aaa");
    }

    private ShapedRecipeBuilder ingot(ItemLike provider) {
        return this.shaped(provider).pattern("aaa").pattern("aaa").pattern("aaa");
    }

    private ShapedRecipeBuilder gear(ItemLike provider) {
        return this.shaped(provider).pattern("aaa").pattern("a a").pattern("aaa");
    }

    private ShapedRecipeBuilder rod(ItemLike provider) {
        return this.shaped(provider).pattern("a  ").pattern("a  ").pattern("a  ");
    }

    private ShapedRecipeBuilder plate(ItemLike provider) {
        return this.shaped(provider).pattern("aa ").pattern("aa ").pattern("   ");
    }

    public static enum Slot {
        BLOCK,
        GEAR,
        ROD,
        PLATE;


        public String lower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

