/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.datagen;

import com.thevortex.allthemodium.datagen.client.BlockStates;
import com.thevortex.allthemodium.datagen.client.ItemModels;
import com.thevortex.allthemodium.datagen.server.ATMBlockTags;
import com.thevortex.allthemodium.datagen.server.ATMCraftingRecipes;
import com.thevortex.allthemodium.datagen.server.ATMItemTags;
import com.thevortex.allthemodium.datagen.server.ATMLootTables;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="allthemodium")
public final class ATMDataGenerators {
    private ATMDataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) throws IOException {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            ATMBlockTags blockTags1 = new ATMBlockTags(packOutput, event.getLookupProvider(), fileHelper);
            generator.addProvider(true, (DataProvider)blockTags1);
            generator.addProvider(true, (DataProvider)new ATMItemTags(packOutput, event.getLookupProvider(), blockTags1.contentsGetter(), fileHelper));
            generator.addProvider(true, (DataProvider)new ATMCraftingRecipes(packOutput, event.getLookupProvider()));
            generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ATMLootTables::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new BlockStates(generator, fileHelper));
            generator.addProvider(true, (DataProvider)new ItemModels(generator, fileHelper));
        }
    }
}

