/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.blocks;

import com.thevortex.allthemodium.registry.ModRegistry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class SoulLava
extends LiquidBlock {
    public int tickcount = 0;
    protected FlowingFluid fluid;

    public SoulLava(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties p_i48368_1_) {
        super(supplier.get(), p_i48368_1_);
    }

    public void entityInside(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos position, @NotNull Entity entity) {
        super.entityInside(state, world, position, entity);
        entity.setRemainingFireTicks(400);
    }

    public boolean isBurning(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public boolean isFireSource(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return true;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        block6: {
            if (!level.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) break block6;
            int i = random.nextInt(10);
            if (i > 0) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i; ++j) {
                    if (!level.isEmptyBlock(blockpos = blockpos.offset(random.nextInt(10) - 1, 1, random.nextInt(10) - 1))) {
                        return;
                    }
                    BlockState blockstate = level.getBlockState(blockpos);
                    BlockState blockState = SoulFireBlock.canSurviveOnBlock((BlockState)blockstate) ? Blocks.SOUL_FIRE.defaultBlockState() : ((FireBlock)Blocks.FIRE).defaultBlockState();
                }
            } else {
                for (int k = 0; k < 10; ++k) {
                    BlockState FIRE;
                    BlockPos blockpos1 = pos.offset(random.nextInt(10) - 1, 0, random.nextInt(10) - 1);
                    BlockState blockState = FIRE = SoulFireBlock.canSurviveOnBlock((BlockState)level.getBlockState(blockpos1)) ? Blocks.SOUL_FIRE.defaultBlockState() : ((FireBlock)Blocks.FIRE).defaultBlockState();
                    if (!level.isEmptyBlock(blockpos1)) {
                        return;
                    }
                    level.setBlockAndUpdate(blockpos1.above(), EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)blockpos1.above(), (BlockPos)pos, (BlockState)FIRE));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        ++this.tickcount;
        if (stateIn.is((Block)ModRegistry.SOULLAVA_BLOCK.get()) && this.tickcount >= 40) {
            SoulLava.spawnParticles(worldIn, pos);
            this.tickcount = 0;
        }
        super.animateTick(stateIn, worldIn, pos, rand);
    }

    private static void spawnParticles(Level world, BlockPos worldIn) {
        double d0 = 0.5625;
        RandomSource random = world.random;
        if (world.getFluidState(worldIn).isSource() && random.nextBoolean()) {
            for (Direction direction : Direction.values()) {
                BlockPos blockpos = worldIn.offset(direction.getNormal());
                if (world.getBlockState(blockpos).isSolidRender((BlockGetter)world, blockpos)) continue;
                Direction.Axis direction$axis = direction.getAxis();
                double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.getStepX() : (double)random.nextFloat();
                double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.getStepY() : (double)random.nextFloat();
                double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.getStepZ() : (double)random.nextFloat();
                world.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)worldIn.getX() + d1, (double)worldIn.getY() + d2, (double)worldIn.getZ() + d3, (double)random.nextFloat(), (double)random.nextFloat(), (double)random.nextFloat());
                world.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)worldIn.getX() + d1, (double)worldIn.getY() + d2, (double)worldIn.getZ() + d3, (double)random.nextFloat(), (double)(-random.nextFloat()), (double)(-random.nextFloat()));
                world.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)worldIn.getX() + d1, (double)worldIn.getY() + d2, (double)worldIn.getZ() + d3, (double)(-random.nextFloat()), (double)random.nextFloat(), (double)(-random.nextFloat()));
                world.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)worldIn.getX() + d1, (double)worldIn.getY() + d2, (double)worldIn.getZ() + d3, (double)(-random.nextFloat()), (double)(-random.nextFloat()), (double)random.nextFloat());
            }
        }
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 1000;
    }
}

