/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.blocks;

import com.mojang.serialization.MapCodec;
import com.thevortex.allthemodium.blocks.ACaveVines;
import com.thevortex.allthemodium.registry.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AncientCaveVines
extends GrowingPlantHeadBlock
implements ACaveVines {
    private static final float CHANCE_OF_BERRIES_ON_GROWTH = 0.11f;
    public static final MapCodec<CaveVinesBlock> CODEC = AncientCaveVines.simpleCodec(CaveVinesBlock::new);

    public AncientCaveVines(BlockBehaviour.Properties p_53928_, Direction p_53929_, VoxelShape p_53930_, boolean p_53931_, double p_53932_) {
        super(p_53928_, Direction.DOWN, SHAPE, false, 0.1);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false)));
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource p_152995_) {
        return 1;
    }

    protected boolean canGrowInto(BlockState p_152998_) {
        return p_152998_.isAir();
    }

    protected BlockState updateBodyAfterConvertedFromHead(BlockState p_152987_, BlockState p_152988_) {
        return (BlockState)p_152988_.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false));
    }

    protected BlockState getGrowIntoState(BlockState p_152990_, RandomSource p_152991_) {
        return (BlockState)super.getGrowIntoState(p_152990_, p_152991_).setValue((Property)BERRIES, (Comparable)Boolean.valueOf(p_152991_.nextFloat() < 0.11f));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)ModRegistry.ANCIENT_CAVEVINES.get());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return ACaveVines.use(state, level, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BERRIES});
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)BERRIES) == false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState sate) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState sate) {
        level.setBlock(pos, (BlockState)sate.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(true)), 2);
    }

    protected GrowingPlantBodyBlock getBodyBlock() {
        return (GrowingPlantBodyBlock)ModRegistry.ANCIENT_CAVEVINES_PLANT.get();
    }

    protected MapCodec<CaveVinesBlock> codec() {
        return CODEC;
    }
}

