/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager;

import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.client.render.block.TrophyBlockEntityRenderer;
import cy.jdkdigital.trophymanager.client.render.entity.PlayerTrophyRenderer;
import cy.jdkdigital.trophymanager.common.block.TrophyBlock;
import cy.jdkdigital.trophymanager.common.blockentity.TrophyBlockEntity;
import cy.jdkdigital.trophymanager.common.datamap.DropRateMap;
import cy.jdkdigital.trophymanager.common.datamap.NbtMap;
import cy.jdkdigital.trophymanager.common.datamap.PropertiesMap;
import cy.jdkdigital.trophymanager.compat.CuriosCompat;
import cy.jdkdigital.trophymanager.init.ModBlockEntities;
import cy.jdkdigital.trophymanager.init.ModBlocks;
import cy.jdkdigital.trophymanager.init.ModEntities;
import cy.jdkdigital.trophymanager.network.PacketOpenGui;
import cy.jdkdigital.trophymanager.network.PacketUpdateTrophy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="trophymanager")
public class TrophyManager {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "trophymanager";
    public static final DataMapType<EntityType<?>, NbtMap> NBT_MAP = DataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"trophymanager", (String)"nbt_map"), (ResourceKey)Registries.ENTITY_TYPE, NbtMap.CODEC).synced(NbtMap.NBT_CODEC, false).build();
    public static final DataMapType<EntityType<?>, DropRateMap> DROP_RATE_MAP = DataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"trophymanager", (String)"drop_rate_map"), (ResourceKey)Registries.ENTITY_TYPE, DropRateMap.CODEC).synced(DropRateMap.DROP_RATE_CODEC, false).build();
    public static final DataMapType<EntityType<?>, PropertiesMap> PROPERTIES_MAP = DataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"trophymanager", (String)"properties_map"), (ResourceKey)Registries.ENTITY_TYPE, PropertiesMap.CODEC).synced(PropertiesMap.CODEC, false).build();

    public TrophyManager(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.addListener(this::onEntityDeath);
        modEventBus.addListener(this::modComms);
        modEventBus.addListener(this::doCommonStuff);
        ModBlocks.BLOCKS.register(modEventBus);
        ModBlocks.ITEMS.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)TrophyManagerConfig.SERVER_CONFIG);
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
    }

    private void modComms(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.register();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onEntityDeath(LivingDeathEvent event) {
        boolean willDropTrophy;
        LivingEntity deadEntity;
        block2: {
            int lootingLevel;
            double chance;
            block3: {
                block1: {
                    deadEntity = event.getEntity();
                    Entity source = event.getSource().getEntity();
                    if (!((Boolean)TrophyManagerConfig.GENERAL.dropFromMobs.get()).booleanValue() || deadEntity instanceof Player || !(source instanceof ServerPlayer)) break block1;
                    ServerPlayer player = (ServerPlayer)source;
                    if (source instanceof FakePlayer && !((Boolean)TrophyManagerConfig.GENERAL.allowFakePlayer.get()).booleanValue()) break block1;
                    DropRateMap dropRate = (DropRateMap)deadEntity.getType().builtInRegistryHolder().getData(DROP_RATE_MAP);
                    chance = dropRate != null ? (double)dropRate.dropRate() : (deadEntity.getType().is(Tags.EntityTypes.BOSSES) ? (Double)TrophyManagerConfig.GENERAL.dropChanceBoss.get() : (Double)TrophyManagerConfig.GENERAL.dropChanceMobs.get());
                    boolean bl = willDropTrophy = chance >= deadEntity.level().random.nextDouble();
                    if (!((Boolean)TrophyManagerConfig.GENERAL.applyLooting.get()).booleanValue()) break block2;
                    HolderLookup.RegistryLookup registryLookup = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
                    lootingLevel = EnchantmentHelper.getEnchantmentLevel((Holder)registryLookup.getOrThrow(Enchantments.LOOTING), (LivingEntity)player);
                    break block3;
                }
                if ((Boolean)TrophyManagerConfig.GENERAL.dropFromPlayers.get() == false) return;
                if (!(deadEntity instanceof Player)) return;
                Player killedPlayer = (Player)deadEntity;
                double chance2 = (Double)TrophyManagerConfig.GENERAL.dropChancePlayers.get();
                boolean willDropTrophy2 = chance2 >= deadEntity.level().random.nextDouble();
                if (!willDropTrophy2) return;
                ItemStack itemStack = TrophyBlock.createPlayerTrophy(killedPlayer);
                return;
            }
            for (int i = 0; i < 1 + lootingLevel; ++i) {
                willDropTrophy = willDropTrophy || chance >= deadEntity.level().random.nextDouble();
            }
        }
        if (!willDropTrophy) return;
        CompoundTag entityTag = new CompoundTag();
        deadEntity.saveWithoutId(entityTag);
        ItemStack trophy = TrophyBlock.createTrophy((Entity)deadEntity, entityTag);
        Block.popResource((Level)deadEntity.level(), (BlockPos)deadEntity.blockPosition(), (ItemStack)trophy);
    }

    private static String idToName(String id) {
        int start = id.indexOf(":") + 1;
        return id.substring(start, start + 1).toUpperCase() + id.substring(start + 1).replace("_", " ");
    }

    @EventBusSubscriber(modid="trophymanager")
    public static class EventHandler {
        @SubscribeEvent
        private static void levelUnload(LevelEvent.Unload event) {
            TrophyBlockEntity.cachedEntities.clear();
        }
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="trophymanager")
    public static class ModEventHandler {
        @SubscribeEvent
        public static void onEntityAttributeCreate(EntityAttributeCreationEvent event) {
            event.put((EntityType)ModEntities.PLAYER.get(), Zombie.createAttributes().build());
        }

        @SubscribeEvent
        public static void payloadHandler(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar(TrophyManager.MODID).versioned("1").optional();
            registrar.playToClient(PacketOpenGui.TYPE, PacketOpenGui.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(PacketOpenGui::clientHandle, PacketOpenGui::serverHandle));
            registrar.playToServer(PacketUpdateTrophy.TYPE, PacketUpdateTrophy.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(PacketUpdateTrophy::clientHandle, PacketUpdateTrophy::serverHandle));
        }

        @SubscribeEvent
        public static void buildContents(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey().equals(CreativeModeTabs.OP_BLOCKS)) {
                String[] entities;
                for (String entityId : entities = new String[]{"allay", "axolotl", "bat", "bee", "blaze", "camel", "cat", "cave_spider", "chicken", "cow", "creeper", "dolphin", "donkey", "drowned", "elder_guardian", "ender_dragon", "enderman", "endermite", "evoker", "fox", "frog", "ghast", "glow_squid", "goat", "guardian", "hoglin", "horse", "husk", "illusioner", "iron_golem", "llama", "magma_cube", "mule", "mooshroom", "ocelot", "panda", "parrot", "phantom", "pig", "piglin", "piglin_brute", "pillager", "polar_bear", "pufferfish", "rabbit", "ravager", "sheep", "shulker", "silverfish", "skeleton", "skeleton_horse", "slime", "snow_golem", "spider", "squid", "stray", "strider", "tadpole", "trader_llama", "tropical_fish", "turtle", "vex", "villager", "vindicator", "wandering_trader", "warden", "witch", "wither", "wither_skeleton", "wolf", "zoglin", "zombie", "zombie_horse", "zombie_villager", "zombified_piglin", "sniffer", "bogged", "breeze"}) {
                    event.accept(TrophyBlock.createTrophy((Holder)BuiltInRegistries.ENTITY_TYPE.getHolder(ResourceLocation.withDefaultNamespace((String)entityId)).get(), new CompoundTag(), TrophyManager.idToName("minecraft:" + entityId)));
                }
            }
        }

        @SubscribeEvent
        private static void registerDataMap(RegisterDataMapTypesEvent event) {
            event.register(NBT_MAP);
            event.register(DROP_RATE_MAP);
            event.register(PROPERTIES_MAP);
        }
    }

    @EventBusSubscriber(modid="trophymanager", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public class ClientSetup {
        public ClientSetup(TrophyManager this$0) {
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.TROPHY.get(), TrophyBlockEntityRenderer::new);
            event.registerEntityRenderer((EntityType)ModEntities.PLAYER.get(), PlayerTrophyRenderer::new);
        }
    }
}

