/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities.goals;

import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class TrainerCardTemptGoal
extends TemptGoal {
    private static final double DEFAULT_MOVE_SPEED = 0.45;
    private TrainerMob trainer;

    public TrainerCardTemptGoal(TrainerMob trainer) {
        super((PathfinderMob)trainer, 0.45, item -> item.is((Item)ModRegistries.Items.TRAINER_CARD.get()), false);
        this.trainer = trainer;
    }

    public boolean canUse() {
        return super.canUse() && !this.lookedAtByTarget();
    }

    private boolean lookedAtByTarget() {
        if (this.player != null) {
            Vec3 from = this.player.getEyePosition();
            Vec3 to = from.add(this.player.getForward().scale((double)this.trainer.getForceBattleMaxDistance()));
            EntityHitResult hit = ProjectileUtil.getEntityHitResult((Level)this.mob.level(), (Entity)this.player, (Vec3)from, (Vec3)to, (AABB)AABB.ofSize((Vec3)from, (double)0.15, (double)0.15, (double)0.15).expandTowards(to.subtract(from)), e -> true);
            return hit != null && hit.getEntity() == this.mob;
        }
        return false;
    }
}

