/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities;

import com.cobblemon.mod.common.api.apricorn.Apricorn;
import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.SeriesMetaData;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.service.SeriesManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerSpawner;
import com.gitlab.srcmc.rctmod.api.utils.ChatUtils;
import com.gitlab.srcmc.rctmod.world.entities.goals.RandomStrollThroughVillageGoal;
import com.gitlab.srcmc.rctmod.world.items.TrainerCard;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TrainerAssociation
extends WanderingTrader {
    public static final int SPAWN_INTERVAL_TICKS = 400;
    public static final int UPDATE_INTERVAL_TICKS = 4;
    public static final int POI_SCAN_RANGE = 48;
    public static final List<Supplier<OfferBuilder>> OFFER_CANDIDATES = List.of(() -> new OfferBuilder(Items.EMERALD, (Item)ModRegistries.Items.TRAINER_CARD.get()));
    public static final int MIN_ITEM_OFFERS = 1;
    public static final int MAX_ITEM_OFFERS = 1;
    public static final int MIN_TRADE_USES = 2;
    public static final int MAX_TRADE_USES = 4;
    public static final int MIN_EMERALD_PRIZE = 1;
    public static final int MAX_EMERALD_PRIZE = 8;
    public static final int MIN_SECONDARY_PRIZE = 1;
    public static final int MAX_SECONDARY_PRIZE = 5;
    public static final int MAX_RESTOCK_DELAY_TICKS = 24000;
    public static final int MIN_RESTOCK_DELAY_TICKS = 6000;
    public static final Supplier<List<? extends Item>> SECONDARY_OPTIONS = () -> Streams.concat((Stream[])new Stream[]{Stream.of(Apricorn.values()).map(Apricorn::item)}).toList();
    private static final EntityType<TrainerAssociation> TYPE = EntityType.Builder.of(TrainerAssociation::new, (MobCategory)MobCategory.MISC).canSpawnFarFromPlayer().sized(0.6f, 1.95f).build("trainer_association");
    private static Set<UUID> playerSpawns = new HashSet<UUID>();
    private Map.Entry<String, ItemStack> offer;
    private MerchantOffers itemOffers;
    private Player playerTarget;
    private int despawnTicks;
    private int lastRestock;

    public static EntityType<TrainerAssociation> getEntityType() {
        return TYPE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.MAX_HEALTH, 20.0);
    }

    public static void init(Level level) {
        playerSpawns = new HashSet<UUID>();
    }

    public static boolean trySpawnFor(Player player) {
        if (TrainerAssociation.canSpawnNearby(player)) {
            if (TrainerAssociation.shouldSpawnNearby(player)) {
                return TrainerAssociation.spawnFor(player, false);
            }
            if (TrainerAssociation.shouldSpawnFor(player)) {
                return TrainerAssociation.spawnFor(player, true);
            }
        }
        return false;
    }

    public static boolean spawnFor(Player player, boolean target) {
        BlockPos pos = RCTMod.getInstance().getTrainerSpawner().nextPos(player);
        if (pos != null) {
            Level level = player.level();
            TrainerAssociation ta = (TrainerAssociation)TYPE.create(level);
            if (target) {
                ta.setPlayerTarget(player);
            }
            ta.setPos(pos.getCenter());
            level.addFreshEntity((Entity)ta);
            return true;
        }
        return false;
    }

    protected static boolean canSpawnNearby(Player player) {
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        String dim = player.level().dimension().location().toString();
        return cfg.spawnTrainerAssociation() && (cfg.dimensionWhitelist().isEmpty() || cfg.dimensionWhitelist().contains(dim)) && !cfg.dimensionBlacklist().contains(dim) && player.level().getNearestEntity(TrainerAssociation.class, TargetingConditions.forCombat(), (LivingEntity)player, player.getX(), player.getY(), player.getZ(), player.getBoundingBox().inflate((double)cfg.maxHorizontalDistanceToPlayers())) == null;
    }

    protected static boolean shouldSpawnNearby(Player player) {
        PoiManager poim = ((ServerLevel)player.level()).getPoiManager();
        Optional bell = poim.findClosestWithType(poit -> poit.is(PoiTypes.MEETING), player.blockPosition(), 48, PoiManager.Occupancy.ANY);
        Stream beds = poim.findAllWithType(poit -> poit.is(PoiTypes.HOME), bp -> true, player.blockPosition(), 48, PoiManager.Occupancy.IS_OCCUPIED);
        return bell.isPresent() && beds.skip(2L).findFirst().isPresent();
    }

    protected static boolean shouldSpawnFor(Player player) {
        TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
        return !playerSpawns.contains(player.getUUID()) && TrainerCard.has(player) && (tpd.isSeriesCompleted() || tpd.isInEmptySeries());
    }

    public TrainerAssociation(EntityType<? extends WanderingTrader> entityType, Level level) {
        super(entityType, level);
    }

    public Player getPlayerTarget() {
        return this.playerTarget;
    }

    public void setPlayerTarget(Player player) {
        if (player != this.playerTarget) {
            if (this.playerTarget != null) {
                playerSpawns.remove(this.playerTarget.getUUID());
            }
            this.playerTarget = player;
            if (this.playerTarget != null) {
                playerSpawns.add(this.playerTarget.getUUID());
            }
            this.setTarget((LivingEntity)this.playerTarget);
        }
    }

    public void tick() {
        if (!this.level().isClientSide && this.tickCount % 4 == 0) {
            RCTMod.getInstance().getTrainerSpawner().register(this);
        }
        super.tick();
    }

    public void remove(Entity.RemovalReason reason) {
        RCTMod.getInstance().getTrainerSpawner().unregister(this);
        this.setPlayerTarget(null);
        super.remove(reason);
    }

    public boolean shouldBeSaved() {
        return this.isPersistenceRequired();
    }

    public boolean shouldDespawn() {
        if (++this.despawnTicks % 20 == 0) {
            if (this.level().getNearestPlayer((Entity)this, (double)Math.max(128, RCTMod.getInstance().getServerConfig().maxHorizontalDistanceToPlayers())) == null) {
                return this.despawnTicks >= 600;
            }
            this.despawnTicks = 0;
        }
        return false;
    }

    public void setPersistenceRequired() {
        if (!this.isPersistenceRequired()) {
            super.setPersistenceRequired();
            this.setPlayerTarget(null);
            TrainerSpawner ts = RCTMod.getInstance().getTrainerSpawner();
            ts.unregister(this);
            ts.register(this);
        }
    }

    public boolean removeWhenFarAway(double d) {
        return false;
    }

    public void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new RandomStrollThroughVillageGoal((PathfinderMob)this, 0.35));
    }

    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (!itemStack.is(Items.VILLAGER_SPAWN_EGG) && this.isAlive() && !this.isTrading() && !this.isBaby()) {
            if (!this.level().isClientSide) {
                if (this.itemOffers == null) {
                    this.updateTrades();
                }
                this.attemptRestock();
                this.updateOffersFor(player);
                this.offer = null;
                if (this.getOffers().isEmpty()) {
                    ChatUtils.reply((LivingEntity)this, player, "missing_beaten_champ");
                }
            }
            return super.mobInteract(player, interactionHand);
        }
        return super.mobInteract(player, interactionHand);
    }

    public void attemptRestock() {
        if (this.itemOffers != null && !this.isTrading() && this.tickCount - this.lastRestock > this.random.nextInt(6000, 24000)) {
            for (MerchantOffer offer : this.itemOffers) {
                offer.updateDemand();
                offer.resetUses();
            }
            this.lastRestock = this.tickCount;
        }
    }

    protected void updateTrades() {
        this.itemOffers = new MerchantOffers();
        this.addRandomOffers(this.itemOffers, OFFER_CANDIDATES.stream().map(Supplier::get).toList(), 1, 1);
        this.offers = new MerchantOffers();
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.itemOffers = this.offers;
        this.offers = new MerchantOffers();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        MerchantOffers offers = this.offers;
        this.offers = this.itemOffers;
        super.addAdditionalSaveData(tag);
        this.offers = offers;
    }

    protected void addRandomOffers(MerchantOffers target, Collection<OfferBuilder> candidates, int min, int max) {
        LinkedList<OfferBuilder> list = new LinkedList<OfferBuilder>(candidates);
        List<? extends Item> sec = SECONDARY_OPTIONS.get();
        block0: for (int m = this.random.nextInt(min, max + 1); m > 0 && !list.isEmpty(); --m) {
            Iterator it = list.iterator();
            float n = list.size();
            int i = 0;
            while (it.hasNext()) {
                OfferBuilder ob = (OfferBuilder)it.next();
                if (!((float)(++i) / n > this.random.nextFloat())) continue;
                target.add((Object)ob.primaryCount(this.random.nextInt(1, 9)).secondaryCount(this.random.nextInt(1, 6)).secondary(sec.isEmpty() ? null : sec.get(this.random.nextInt(sec.size()))).maxUses(this.random.nextInt(2, 5)).build());
                it.remove();
                continue block0;
            }
        }
    }

    public Map.Entry<String, ItemStack> takeOffer() {
        Map.Entry<String, ItemStack> o = this.offer;
        this.offer = null;
        return o;
    }

    public void updateOffersFor(Player player) {
        RCTMod rct = RCTMod.getInstance();
        TrainerManager tm = rct.getTrainerManager();
        SeriesManager sm = rct.getSeriesManager();
        TrainerPlayerData tpd = tm.getData(player);
        boolean freeroamRequiresCompletedSeries = rct.getServerConfig().freeroamRequiresCompletedSeries();
        this.offers = new MerchantOffers();
        if (this.itemOffers != null) {
            this.itemOffers.forEach(arg_0 -> this.offers.add(arg_0));
        }
        sm.getSeriesIds().stream().map(sid -> Map.entry(sid, sm.getGraph((String)sid).getMetaData())).filter(e -> !((String)e.getKey()).equals("empty") && !((String)e.getKey()).equals(tpd.getCurrentSeries())).filter(e -> !"freeroam".equals(e.getKey()) || !freeroamRequiresCompletedSeries || tpd.getCompletedSeries().values().stream().anyMatch(c -> c > 0)).filter(e -> "freeroam".equals(tpd.getCurrentSeries()) ? sm.getGraph(tpd.getPreviousSeries()) == sm.EMPTY_SERIES || sm.getGraph(tpd.getPreviousSeries()) == sm.UNKNOWN_SERIES || ((String)e.getKey()).equals(tpd.getPreviousSeries()) : true).sorted((e1, e2) -> ((SeriesMetaData)e1.getValue()).compareTo((SeriesMetaData)e2.getValue())).forEach(e -> {
            if (((SeriesMetaData)e.getValue()).requiredSeries() != null) {
                for (List<String> reqs : ((SeriesMetaData)e.getValue()).requiredSeries()) {
                    boolean ok = false;
                    for (String s : reqs) {
                        if (!tpd.getCompletedSeries().containsKey(s)) continue;
                        ok = true;
                        break;
                    }
                    if (ok) continue;
                    return;
                }
            }
            this.offers.add((Object)new SeriesSwitchOffer((String)e.getKey(), (SeriesMetaData)e.getValue()));
        });
        this.stopTrading();
    }

    public static class OfferBuilder {
        private Item primary;
        private Item secondary;
        private Item result;
        private int primaryCount = 1;
        private int secondaryCount = 1;
        private int resultCount = 1;
        private int maxUses = 1;
        private int xp = 2;
        private float priceMultiplier = 0.05f;

        public OfferBuilder(Item primary, Item result) {
            this.primary = primary;
            this.result = result;
        }

        public OfferBuilder secondary(Item item) {
            this.secondary = item;
            return this;
        }

        public OfferBuilder primaryCount(int value) {
            this.primaryCount = value;
            return this;
        }

        public OfferBuilder secondaryCount(int value) {
            this.secondaryCount = value;
            return this;
        }

        public OfferBuilder resultCount(int value) {
            this.resultCount = value;
            return this;
        }

        public OfferBuilder maxUses(int value) {
            this.maxUses = value;
            return this;
        }

        public OfferBuilder xp(int value) {
            this.xp = value;
            return this;
        }

        public OfferBuilder priceMultiplier(float value) {
            this.priceMultiplier = value;
            return this;
        }

        public MerchantOffer build() {
            return new MerchantOffer(new ItemCost((ItemLike)this.primary, this.primaryCount), this.secondary != null ? Optional.of(new ItemCost((ItemLike)this.secondary, this.secondaryCount)) : Optional.empty(), new ItemStack((ItemLike)this.result, this.resultCount), this.maxUses, this.xp, this.priceMultiplier);
        }
    }

    private class SeriesSwitchOffer
    extends MerchantOffer {
        private String seriesId;
        private SeriesMetaData seriesData;

        public SeriesSwitchOffer(String seriesId, SeriesMetaData seriesData) {
            super(new ItemCost((ItemLike)ModRegistries.Items.TRAINER_CARD.get()), SeriesSwitchOffer.createOfferFor(TrainerAssociation.this.getTradingPlayer(), seriesId, seriesData), Integer.MAX_VALUE, Integer.MAX_VALUE, 1.0f);
            this.seriesId = seriesId;
            this.seriesData = seriesData;
        }

        private SeriesSwitchOffer(SeriesSwitchOffer origin) {
            this(origin.seriesId, origin.seriesData);
        }

        public boolean satisfiedBy(ItemStack arg1, ItemStack arg2) {
            if (super.satisfiedBy(arg1, arg2)) {
                TrainerAssociation.this.offer = Map.entry(this.seriesId, arg1.copy());
                return true;
            }
            return false;
        }

        public SeriesSwitchOffer copy() {
            return new SeriesSwitchOffer(this);
        }

        private static String makeStars(int n, int m) {
            int i;
            n = Math.min(n, m);
            int full = n / 2;
            boolean half = n > 0 && n % 2 != 0;
            int empty = (m - n) / 2;
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < full; ++i) {
                sb.append('\u2605');
            }
            if (half) {
                sb.append('\u2bea');
            }
            for (i = 0; i < empty; ++i) {
                sb.append('\u2606');
            }
            return sb.toString();
        }

        private static ItemStack createOfferFor(Player player, String seriesId, SeriesMetaData seriesData) {
            return player == null ? new ItemStack((ItemLike)ModRegistries.Items.TRAINER_CARD.get(), 1) : ("freeroam".equals(seriesId) ? SeriesSwitchOffer.createFreeroamOffer(player, seriesId, seriesData) : ("freeroam".equals(RCTMod.getInstance().getTrainerManager().getData(player).getCurrentSeries()) ? SeriesSwitchOffer.createContinueOffer(player, seriesId, seriesData) : SeriesSwitchOffer.createSwitchOffer(player, seriesId, seriesData)));
        }

        private static ItemStack createFreeroamOffer(Player player, String seriesId, SeriesMetaData seriesData) {
            ItemStack card = new ItemStack((ItemLike)ModRegistries.Items.TRAINER_CARD.get(), 1);
            card.applyComponents(DataComponentMap.builder().set(DataComponents.CUSTOM_NAME, (Object)seriesData.title().getComponent(new Object[0])).set(DataComponents.LORE, (Object)new ItemLore(List.of(seriesData.description().getComponent(new Object[0])))).build());
            return card;
        }

        private static ItemStack createSwitchOffer(Player player, String seriesId, SeriesMetaData seriesData) {
            ItemStack card = new ItemStack((ItemLike)ModRegistries.Items.TRAINER_CARD.get(), 1);
            Integer completions = RCTMod.getInstance().getTrainerManager().getData(player).getCompletedSeries().getOrDefault(seriesId, 0);
            card.applyComponents(DataComponentMap.builder().set(DataComponents.CUSTOM_NAME, (Object)seriesData.title().getComponent(new Object[0])).set(DataComponents.LORE, (Object)new ItemLore(List.of(seriesData.description().getComponent(new Object[0]), Component.literal((String)""), Component.literal((String)String.format("%s: %s", Component.translatable((String)"gui.rctmod.trainer_association.difficulty").getString(), SeriesSwitchOffer.makeStars(seriesData.difficulty(), 10))), Component.literal((String)String.format("%s: %d", Component.translatable((String)"gui.rctmod.trainer_association.completed").getString(), completions)), Component.literal((String)""), Component.translatable((String)"gui.rctmod.trainer_association.important").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD), Component.translatable((String)"gui.rctmod.trainer_association.series_reset").withStyle(ChatFormatting.GOLD)))).build());
            return card;
        }

        private static ItemStack createContinueOffer(Player player, String seriesId, SeriesMetaData seriesData) {
            ItemStack card = new ItemStack((ItemLike)ModRegistries.Items.TRAINER_CARD.get(), 1);
            Integer completions = RCTMod.getInstance().getTrainerManager().getData(player).getCompletedSeries().getOrDefault(seriesId, 0);
            card.applyComponents(DataComponentMap.builder().set(DataComponents.CUSTOM_NAME, (Object)seriesData.title().getComponent(new Object[0])).set(DataComponents.LORE, (Object)new ItemLore(List.of(seriesData.description().getComponent(new Object[0]), Component.literal((String)""), Component.literal((String)String.format("%s: %s", Component.translatable((String)"gui.rctmod.trainer_association.difficulty").getString(), SeriesSwitchOffer.makeStars(seriesData.difficulty(), 10))), Component.literal((String)String.format("%s: %d", Component.translatable((String)"gui.rctmod.trainer_association.completed").getString(), completions)), Component.literal((String)""), Component.translatable((String)"gui.rctmod.trainer_association.series_continue").withStyle(ChatFormatting.GOLD)))).build());
            return card;
        }
    }
}

