/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.mixins;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.ai.sensors.DefendOwnerSensor;
import com.cobblemon.mod.common.util.BrainExtensionsKt;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.Enemy;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DefendOwnerSensor.class})
public abstract class DefendOwnerSensorMixin
extends Sensor<PokemonEntity> {
    @Inject(method={"setNearestAttacker(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/ai/memory/NearestVisibleLivingEntities;Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void inject$setNearestAttacker(PokemonEntity entity, NearestVisibleLivingEntities visibleMobs, LivingEntity owner, CallbackInfo ci) {
        LivingEntity nearestAttacker = visibleMobs.findClosest(livingEntity -> {
            if (livingEntity instanceof ServerPlayer) {
                return false;
            }
            if (livingEntity.getLastHurtByMob() == owner) {
                return true;
            }
            if (DefendOwnerSensorMixin.isHostile(livingEntity, owner)) {
                return true;
            }
            Optional mobAttackTarget = BrainExtensionsKt.getMemorySafely((Brain)livingEntity.getBrain(), (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
            return mobAttackTarget.isPresent() && mobAttackTarget.get() == owner;
        }).map(mob -> mob).orElse(null);
        entity.getBrain().setMemory(CobblemonMemories.NEAREST_VISIBLE_ATTACKER, (Object)nearestAttacker);
        ci.cancel();
    }

    private static boolean isHostile(LivingEntity living, LivingEntity towards) {
        Mob mob;
        return (living instanceof Enemy || towards.getLastHurtByMob() == living) && living instanceof Mob && (mob = (Mob)living).getTarget() == towards;
    }
}

