/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.commands;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerType;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.service.SeriesManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.utils.PlantUML;
import com.gitlab.srcmc.rctmod.commands.arguments.TokenArgumentType;
import com.gitlab.srcmc.rctmod.commands.utils.SuggestionUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class PlayerCommands {
    private PlayerCommands() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rctmod").requires(css -> css.hasPermission(1))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"player").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"get").then(((LiteralArgumentBuilder)Commands.literal((String)"luck").executes(PlayerCommands::player_get_luck)).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(PlayerCommands::player_get_luck_target)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"series").executes(PlayerCommands::player_get_current_series)).then(Commands.literal((String)"completed").executes(PlayerCommands::player_get_completed_series))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(PlayerCommands::player_get_current_series_target)).then(Commands.literal((String)"completed").executes(PlayerCommands::player_get_completed_series_target))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"progress").executes(PlayerCommands::player_get_progress)).then(((LiteralArgumentBuilder)Commands.literal((String)"graph").executes(PlayerCommands::player_get_progress_graph)).then(Commands.argument((String)"graph_flags", (ArgumentType)StringArgumentType.greedyString()).suggests(SuggestionUtils::get_graph_flag_suggestions).executes(PlayerCommands::player_get_progress_graph)))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(PlayerCommands::player_get_progress_target)).then(((LiteralArgumentBuilder)Commands.literal((String)"graph").executes(PlayerCommands::player_get_progress_graph)).then(Commands.argument((String)"graph_flags", (ArgumentType)StringArgumentType.greedyString()).suggests(SuggestionUtils::get_graph_flag_suggestions).executes(PlayerCommands::player_get_progress_graph_target)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"level_cap").executes(PlayerCommands::player_get_level_cap)).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(PlayerCommands::player_get_level_cap_target)))).then(Commands.literal((String)"defeats").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).executes(PlayerCommands::player_get_defeats)).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(PlayerCommands::player_get_defeats_target))))).then(Commands.literal((String)"type_defeats").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"type", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_type_suggestions).executes(PlayerCommands::player_get_type_defeats)).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(PlayerCommands::player_get_type_defeats_target)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(css -> css.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"progress").then(Commands.literal((String)"before").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_add_progress_before)))).then(Commands.literal((String)"after").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_add_progress_after)))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"before").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_add_progress_targets_before)))).then(Commands.literal((String)"after").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_add_progress_targets_after))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").requires(css -> css.hasPermission(2))).then(Commands.literal((String)"series").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"seriesId", (ArgumentType)TokenArgumentType.token()).suggests(SuggestionUtils::get_series_suggestions).executes(PlayerCommands::player_set_current_series)).then(Commands.literal((String)"completed").then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(PlayerCommands::player_set_completed_series)))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(PlayerCommands::player_set_current_series_targets)).then(Commands.literal((String)"completed").then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(PlayerCommands::player_set_completed_series_targets))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"progress").then(Commands.literal((String)"before").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_set_progress_before)))).then(Commands.literal((String)"after").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_set_progress_after)))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"before").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_set_progress_targets_before)))).then(Commands.literal((String)"after").then(RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_progress_trainer_suggestions).executes(PlayerCommands::player_set_progress_targets_after)))))).then(Commands.literal((String)"defeats").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)TokenArgumentType.token()).suggests(SuggestionUtils::get_trainer_suggestions_bulk).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(PlayerCommands::player_set_defeats_value))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(PlayerCommands::player_set_defeats_targets_value))))))));
    }

    private static int player_get_luck(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String bsw = PlayerCommands.getluck(player);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)bsw), false);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int player_get_luck_target(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"target");
        String bsw = PlayerCommands.getluck((Player)player);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)bsw), false);
        return 0;
    }

    private static String getluck(Player player) {
        TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
        SeriesManager sm = RCTMod.getInstance().getSeriesManager();
        return String.format("%d/%.4f", tpd.getCompletedSeries().entrySet().stream().map(e -> sm.getGraph((String)e.getKey()).getMetaData().difficulty() * (Integer)e.getValue()).reduce(0, (a, b) -> a + b), Float.valueOf(tpd.getBonusLuck((int)(player.getLuck() * 10.0f))));
    }

    private static int player_get_current_series_target(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"target");
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)RCTMod.getInstance().getTrainerManager().getData((Player)player).getCurrentSeries()), false);
        return 0;
    }

    public static int player_get_current_series(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)RCTMod.getInstance().getTrainerManager().getData(player).getCurrentSeries()), false);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int player_get_completed_series(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Map.Entry<String, Integer> e;
            Player player = (Player)entity;
            Iterator<Map.Entry<String, Integer>> it = RCTMod.getInstance().getTrainerManager().getData(player).getCompletedSeries().entrySet().iterator();
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            if (it.hasNext()) {
                e = it.next();
                sb.append(e.getKey()).append(':').append(e.getValue());
            }
            while (it.hasNext()) {
                e = it.next();
                sb.append(", ").append(e.getKey()).append(':').append(e.getValue());
            }
            sb.append(']');
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(sb.toString())), false);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int player_get_completed_series_target(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Map.Entry<String, Integer> e;
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"target");
        Iterator<Map.Entry<String, Integer>> it = RCTMod.getInstance().getTrainerManager().getData((Player)player).getCompletedSeries().entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (it.hasNext()) {
            e = it.next();
            sb.append(e.getKey()).append(':').append(e.getValue());
        }
        while (it.hasNext()) {
            e = it.next();
            sb.append(", ").append(e.getKey()).append(':').append(e.getValue());
        }
        sb.append(']');
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(sb.toString())), false);
        return 0;
    }

    private static int player_get_progress(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Iterator it = RCTMod.getInstance().getTrainerManager().getData(player).getDefeatedTrainerIds().stream().iterator();
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            if (it.hasNext()) {
                sb.append((String)it.next());
            }
            while (it.hasNext()) {
                sb.append(", ").append((String)it.next());
            }
            sb.append(']');
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(sb.toString())), false);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int player_get_progress_target(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"target");
        Iterator it = RCTMod.getInstance().getTrainerManager().getData((Player)player).getDefeatedTrainerIds().stream().iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (it.hasNext()) {
            sb.append((String)it.next());
        }
        while (it.hasNext()) {
            sb.append(", ").append((String)it.next());
        }
        sb.append(']');
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(sb.toString())), false);
        return 0;
    }

    private static int player_get_progress_graph(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            PlayerCommands.get_progress_graph(context, player);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int player_get_progress_graph_target(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerCommands.get_progress_graph(context, (Player)EntityArgument.getPlayer(context, (String)"target"));
        return 0;
    }

    private static void get_progress_graph(CommandContext<CommandSourceStack> context, Player player) {
        TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
        String flagStr = "";
        int flags = 0;
        try {
            flagStr = StringArgumentType.getString(context, (String)"graph_flags");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (!flagStr.isEmpty()) {
            flags = SuggestionUtils.getGraphFlags(flagStr);
        }
        boolean includeDefeated = (flags & SuggestionUtils.GF_INCLUDE_DEFEATED) != 0;
        boolean includeOptionals = (flags & SuggestionUtils.GF_INCLUDE_OPTIONALS) != 0;
        boolean includeSingles = (flags & SuggestionUtils.GF_INCLUDE_SINGLES) != 0;
        SeriesManager.SeriesGraph graph = RCTMod.getInstance().getSeriesManager().getGraph(tpd.getCurrentSeries());
        String url = "https://www.plantuml.com/plantuml/svg/" + PlantUML.encode(player, tpd.getCurrentSeries(), includeDefeated ? graph.getRemaining(includeOptionals, includeSingles) : graph.getRemaining(tpd.getDefeatedTrainerIds(), includeOptionals, includeSingles), tpd.getDefeatedTrainerIds());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.rctmod.feedback.series_graph", (Object[])new Object[]{player.getDisplayName().getString(), graph.getMetaData().title().getComponent(new Object[0]).getString()}).append((Component)Component.literal((String)" ")).append((Component)Component.literal((String)url).setStyle(Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GREEN}).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"commands.rctmod.feedback.click_link"))).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url)))), false);
    }

    private static int player_get_level_cap(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int level_cap = RCTMod.getInstance().getTrainerManager().getData(player).getLevelCap();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(level_cap)), false);
            return level_cap;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int player_get_level_cap_target(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"target");
        int level_cap = RCTMod.getInstance().getTrainerManager().getData((Player)player).getLevelCap();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(level_cap)), false);
        return level_cap;
    }

    private static int player_get_defeats(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            try {
                String trainerId = (String)context.getArgument("trainerId", String.class);
                int count = RCTMod.getInstance().getTrainerManager().getBattleMemory((ServerLevel)player.level(), trainerId).getDefeatByCount(trainerId, player);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(count)), false);
                return count;
            }
            catch (IllegalArgumentException e) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)e.getMessage()));
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        }
        return -1;
    }

    private static int player_get_defeats_target(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            String trainerId = (String)context.getArgument("trainerId", String.class);
            ServerPlayer player = EntityArgument.getPlayer(context, (String)"target");
            int count = RCTMod.getInstance().getTrainerManager().getBattleMemory((ServerLevel)player.level(), trainerId).getDefeatByCount(trainerId, (Player)player);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(count)), false);
            return count;
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)e.getMessage()));
            return -1;
        }
    }

    private static int player_get_type_defeats(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            try {
                ServerLevel level = (ServerLevel)player.level();
                TrainerType type = TrainerType.valueOf((String)context.getArgument("type", String.class));
                TrainerManager tm = RCTMod.getInstance().getTrainerManager();
                Integer count = tm.getAllData(new String[0]).filter(e -> ((TrainerMobData)e.getValue()).getType().equals(type)).map(e -> tm.getBattleMemory(level, (String)e.getKey()).getDefeatByCount((String)e.getKey(), player)).reduce(0, (a, b) -> a + b);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(count)), false);
                return count;
            }
            catch (IllegalArgumentException e2) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)e2.getMessage()));
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        }
        return -1;
    }

    private static int player_get_type_defeats_target(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            TrainerType type = TrainerType.valueOf((String)context.getArgument("type", String.class));
            ServerPlayer player = EntityArgument.getPlayer(context, (String)"target");
            ServerLevel level = (ServerLevel)player.level();
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            Integer count = tm.getAllData(new String[0]).filter(e -> ((TrainerMobData)e.getValue()).getType().equals(type)).map(e -> tm.getBattleMemory(level, (String)e.getKey()).getDefeatByCount((String)e.getKey(), (Player)player)).reduce(0, (a, b) -> a + b);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(count)), false);
            return count;
        }
        catch (IllegalArgumentException e2) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)e2.getMessage()));
            return -1;
        }
    }

    private static int player_set_completed_series(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String seriesid = StringArgumentType.getString(context, (String)"seriesId");
            if (seriesid.equals("empty")) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.empty_series"));
                return -1;
            }
            int count = IntegerArgumentType.getInteger(context, (String)"count");
            TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
            Integer current = tpd.getCompletedSeries().getOrDefault(seriesid, 0);
            tpd.addSeriesCompletion(seriesid, count - current);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int player_set_completed_series_targets(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String seriesid = StringArgumentType.getString(context, (String)"seriesId");
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        if (seriesid.equals("empty")) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.empty_series"));
            return -1;
        }
        for (ServerPlayer player : EntityArgument.getPlayers(context, (String)"targets")) {
            TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData((Player)player);
            Integer current = tpd.getCompletedSeries().getOrDefault(seriesid, 0);
            tpd.addSeriesCompletion(seriesid, count - current);
        }
        return 0;
    }

    private static int player_set_current_series(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String seriesid = StringArgumentType.getString(context, (String)"seriesId");
            seriesid = seriesid.equals("empty") ? "" : seriesid;
            RCTMod.getInstance().getTrainerManager().getData(player).setCurrentSeries(seriesid);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int player_set_current_series_targets(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String seriesid = StringArgumentType.getString(context, (String)"seriesId");
        seriesid = seriesid.equals("empty") ? "" : seriesid;
        for (ServerPlayer player : EntityArgument.getPlayers(context, (String)"targets")) {
            RCTMod.getInstance().getTrainerManager().getData((Player)player).setCurrentSeries(seriesid);
        }
        return 0;
    }

    private static int player_set_progress_before(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String trainerId = StringArgumentType.getString(context, (String)"trainerId");
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd != null) {
                TrainerPlayerData tpd = tm.getData(player);
                tpd.removeProgressDefeats();
                HashSet visited = new HashSet();
                tmd.getMissingRequirements(Set.of()).filter(tid -> tm.getData((String)tid).isOfSeries(tpd.getCurrentSeries())).forEach(tid -> PlayerCommands.add_progress(tpd, tid, visited));
            }
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int player_add_progress_before(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String trainerId = StringArgumentType.getString(context, (String)"trainerId");
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd != null) {
                TrainerPlayerData tpd = tm.getData(player);
                HashSet visited = new HashSet();
                tmd.getMissingRequirements(Set.of()).filter(tid -> tm.getData((String)tid).isOfSeries(tpd.getCurrentSeries())).forEach(tid -> PlayerCommands.add_progress(tpd, tid, visited));
            }
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int player_set_progress_after(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String trainerId = StringArgumentType.getString(context, (String)"trainerId");
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd != null) {
                TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
                tpd.removeProgressDefeats();
                PlayerCommands.add_progress(tpd, trainerId, new HashSet<String>());
            }
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int player_add_progress_after(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String trainerId = StringArgumentType.getString(context, (String)"trainerId");
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd != null) {
                TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
                PlayerCommands.add_progress(tpd, trainerId, new HashSet<String>());
            }
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int player_set_progress_targets_before(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(context, (String)"targets");
        String trainerId = StringArgumentType.getString(context, (String)"trainerId");
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        for (ServerPlayer player : targets) {
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd == null) continue;
            TrainerPlayerData tpd = tm.getData((Player)player);
            tpd.removeProgressDefeats();
            HashSet visited = new HashSet();
            tmd.getMissingRequirements(Set.of()).filter(tid -> tm.getData((String)tid).isOfSeries(tpd.getCurrentSeries())).forEach(tid -> PlayerCommands.add_progress(tpd, tid, visited));
        }
        return 0;
    }

    private static int player_add_progress_targets_before(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(context, (String)"targets");
        String trainerId = StringArgumentType.getString(context, (String)"trainerId");
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        for (ServerPlayer player : targets) {
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd == null) continue;
            TrainerPlayerData tpd = tm.getData((Player)player);
            HashSet visited = new HashSet();
            tmd.getMissingRequirements(Set.of()).filter(tid -> tm.getData((String)tid).isOfSeries(tpd.getCurrentSeries())).forEach(tid -> PlayerCommands.add_progress(tpd, tid, visited));
        }
        return 0;
    }

    private static int player_set_progress_targets_after(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(context, (String)"targets");
        String trainerId = StringArgumentType.getString(context, (String)"trainerId");
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        for (ServerPlayer player : targets) {
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd == null) continue;
            TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData((Player)player);
            tpd.removeProgressDefeats();
            PlayerCommands.add_progress(tpd, trainerId, new HashSet<String>());
        }
        return 0;
    }

    private static int player_add_progress_targets_after(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(context, (String)"targets");
        String trainerId = StringArgumentType.getString(context, (String)"trainerId");
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        for (ServerPlayer player : targets) {
            TrainerMobData tmd = tm.getData(trainerId);
            if (tmd == null) continue;
            TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData((Player)player);
            PlayerCommands.add_progress(tpd, trainerId, new HashSet<String>());
        }
        return 0;
    }

    private static int player_set_defeats_value(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            try {
                String trainerId = (String)context.getArgument("trainerId", String.class);
                int count = IntegerArgumentType.getInteger(context, (String)"value");
                TrainerManager tm = RCTMod.getInstance().getTrainerManager();
                ServerLevel level = (ServerLevel)player.level();
                if (!SuggestionUtils.executeBulk(trainerId, data -> data.map(e -> (String)e.getKey()).forEach(tid -> tm.getBattleMemory(level, (String)tid).setDefeatedBy((String)tid, player, count)))) {
                    tm.getBattleMemory(level, trainerId).setDefeatedBy(trainerId, player, count);
                }
                return count;
            }
            catch (IllegalArgumentException e) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)e.getMessage()));
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        }
        return -1;
    }

    private static int player_set_defeats_targets_value(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            String trainerId = (String)context.getArgument("trainerId", String.class);
            Collection targets = EntityArgument.getPlayers(context, (String)"targets");
            int count = IntegerArgumentType.getInteger(context, (String)"value");
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            boolean bulk = SuggestionUtils.executeBulk(trainerId, data -> {
                for (ServerPlayer player : targets) {
                    ServerLevel level = (ServerLevel)player.level();
                    data.map(e -> (String)e.getKey()).forEach(tid -> tm.getBattleMemory(level, (String)tid).setDefeatedBy((String)tid, (Player)player, count));
                }
            });
            if (!bulk) {
                for (ServerPlayer player : targets) {
                    ServerLevel level = (ServerLevel)player.level();
                    tm.getBattleMemory(level, trainerId).setDefeatedBy(trainerId, (Player)player, count);
                }
            }
            return count;
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)e.getMessage()));
            return -1;
        }
    }

    private static void add_progress(TrainerPlayerData tpd, String trainerId, Set<String> visited) {
        if (!visited.contains(trainerId)) {
            visited.add(trainerId);
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            TrainerMobData tmd = tm.getData(trainerId);
            tmd.getMissingRequirements(Set.of()).filter(tid -> tm.getData((String)tid).isOfSeries(tpd.getCurrentSeries())).forEach(tid -> PlayerCommands.add_progress(tpd, tid, visited));
            tpd.addProgressDefeat(trainerId);
        }
    }
}

