/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.screens.widgets;

import com.gitlab.srcmc.rctmod.client.screens.widgets.IPaginated;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractScrollWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public abstract class TrainerDataWidget
extends AbstractScrollWidget
implements IPaginated {
    public static final float INNER_SCALE = 0.65f;
    protected Font font;

    public TrainerDataWidget(int x, int y, int w, int h, Font font) {
        super(x, y, w, h, (Component)Component.empty());
        this.font = font;
    }

    public int getInnerPadding() {
        return this.innerPadding();
    }

    public double getScrollAmount() {
        return this.scrollAmount();
    }

    protected int getInnerHeight() {
        return this.getHeight() - this.totalInnerPadding();
    }

    protected void renderContents(GuiGraphics guiGraphics, int x, int y, float f) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.getX() + this.innerPadding()), (float)(this.getY() + this.innerPadding()), 0.0f);
        guiGraphics.pose().scale(0.65f, 0.65f, 1.0f);
        this.renderPage(guiGraphics, x, y, f);
        guiGraphics.pose().popPose();
    }

    protected void renderBackground(GuiGraphics guiGraphics) {
        if (this.visible) {
            if (this.scrollbarVisible()) {
                super.renderBackground(guiGraphics);
            } else {
                this.renderBorder(guiGraphics, this.getX(), this.getY(), this.getWidth(), this.getHeight());
                this.renderFullScrollBar(guiGraphics);
            }
        }
    }

    private int getContentHeight() {
        return this.getInnerHeight() + 4;
    }

    private int getScrollBarHeight() {
        return Mth.clamp((int)((int)((float)(this.height * this.height) / (float)this.getContentHeight())), (int)32, (int)this.height);
    }

    private void renderFullScrollBar(GuiGraphics guiGraphics) {
        int i = this.getScrollBarHeight();
        int j = this.getX() + this.width;
        int k = this.getX() + this.width + 8;
        int l = this.getY() + this.height - i;
        int m = l + i;
        guiGraphics.fill(j, l, k, m, -8355712);
        guiGraphics.fill(j, l, k - 1, m - 1, -4144960);
    }

    protected double scrollRate() {
        return 9.0;
    }

    protected void updateWidgetNarration(NarrationElementOutput arg0) {
    }

    public double localX(double absX) {
        return (absX - (double)this.getX()) / (double)0.65f - (double)this.innerPadding();
    }

    public double localY(double absY) {
        return (absY - (double)this.getY() + this.scrollAmount()) / (double)0.65f - (double)this.innerPadding();
    }

    protected static <T> MutableComponent toComponent(T value) {
        MutableComponent c;
        return (value instanceof MutableComponent ? (c = (MutableComponent)value) : Component.literal((String)String.valueOf(value))).withStyle(ChatFormatting.GREEN);
    }

    protected abstract void renderPage(GuiGraphics var1, int var2, int var3, float var4);

    public static class HoverElement<T extends Renderable & GuiEventListener>
    implements Renderable {
        public final T element;
        private final Consumer<T> onHoverStart;
        private final Consumer<T> onHoverEnd;
        final /* synthetic */ TrainerDataWidget this$0;

        public HoverElement(T element, Consumer<T> onHoverStart, Consumer<T> onHoverEnd) {
            this.this$0 = this$0;
            this.element = element;
            this.onHoverStart = onHoverStart;
            this.onHoverEnd = onHoverEnd;
        }

        public void render(GuiGraphics guiGraphics, int x, int y, float f) {
            if (((GuiEventListener)this.element).isMouseOver(this.this$0.localX(x), this.this$0.localY(y))) {
                this.onHoverStart.accept(this.element);
            } else {
                this.onHoverEnd.accept(this.element);
            }
            this.element.render(guiGraphics, x, y, f);
        }
    }
}

