/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.screens;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IClientConfig;
import com.gitlab.srcmc.rctmod.client.screens.widgets.PlayerInfoWidget;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class TrainerCardScreen
extends Screen {
    private static final int CARD_W = 224;
    private static final int CARD_H = 128;
    private PlayerInfoWidget playerInfo;

    public TrainerCardScreen() {
        super((Component)Component.translatable((String)"gui.rctmod.trainer_card.title"));
        Minecraft mc = Minecraft.getInstance();
        this.font = mc.font;
    }

    protected void init() {
        super.init();
        Window window = Minecraft.getInstance().getWindow();
        this.width = window.getGuiScaledWidth();
        this.height = window.getGuiScaledHeight();
        IClientConfig cfg = RCTMod.getInstance().getClientConfig();
        int pad = cfg.trainerCardPadding();
        int card_x = pad + (int)((float)(this.width - (224 + 2 * pad)) * cfg.trainerCardAlignmentX());
        int card_y = pad + (int)((float)(this.height - (128 + 2 * pad)) * cfg.trainerCardAlignmentY());
        this.playerInfo = new PlayerInfoWidget(card_x, card_y, 224, 128, this.font);
        this.addRenderableOnly((Renderable)this.playerInfo);
        for (AbstractWidget r : this.playerInfo.getRenderableOnlies()) {
            this.addRenderableOnly((Renderable)r);
        }
        for (AbstractWidget w : this.playerInfo.getRenderableWidgets()) {
            this.addRenderableWidget((GuiEventListener)w);
        }
    }

    public boolean keyPressed(int key, int scancode, int mods) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.keyInventory.matches(key, scancode)) {
            mc.setScreen(null);
            return true;
        }
        return super.keyPressed(key, scancode, mods);
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (i == 1) {
            Minecraft mc = Minecraft.getInstance();
            mc.setScreen(null);
            return true;
        }
        return super.mouseClicked(d, e, i);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void tick() {
        super.tick();
        this.playerInfo.tick();
    }
}

