/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.utils;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.Optional;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.SeriesManager;
import java.util.Collection;
import net.minecraft.world.entity.player.Player;

public class LevelUtils {
    public static int initialLevelCap(String seriesId) {
        Optional<Integer> ilc = RCTMod.getInstance().getSeriesManager().getGraph(seriesId).getMetaData().initialLevelCap();
        return ilc.has() ? ilc.get().intValue() : RCTMod.getInstance().getServerConfig().initialLevelCap();
    }

    public static int relativeLevelCap(String seriesId, String trainerId) {
        Optional<Integer> rlc;
        if (trainerId != null && (rlc = RCTMod.getInstance().getTrainerManager().getData(trainerId).getRelativeLevelCap()).has()) {
            return rlc.get();
        }
        rlc = RCTMod.getInstance().getSeriesManager().getGraph(seriesId).getMetaData().relativeLevelCap();
        return rlc.has() ? rlc.get().intValue() : RCTMod.getInstance().getServerConfig().relativeLevelCap();
    }

    public static int levelCap(Player player) {
        SeriesManager sm = RCTMod.getInstance().getSeriesManager();
        PlayerState ps = PlayerState.get(player);
        String sid = ps.getCurrentSeries();
        SeriesManager.SeriesGraph sg = sm.getGraph(sid).getNext(ps.getDefeatedTrainerIds());
        Integer lc = sg.stream().map(tn -> LevelUtils.trainerLevel(sid, tn.id())).min(Integer::compare).orElse("empty".equals(sid) ? 1 : LevelUtils.maxLevel());
        return Math.max(LevelUtils.initialLevelCap(sid), lc);
    }

    public static int levelCap(String seriesId, String trainerId) {
        return Math.max(LevelUtils.initialLevelCap(seriesId), LevelUtils.trainerLevel(seriesId, trainerId));
    }

    public static int trainerLevel(String seriesId, String trainerId) {
        return LevelUtils.trainerLevel(seriesId, trainerId, RCTMod.getInstance().getTrainerManager().getData(trainerId));
    }

    public static int trainerLevel(TrainerMobData tmd) {
        return tmd.getTrainerTeam().getTeam().stream().map(p -> p.getLevel()).max(Integer::compare).orElse(0);
    }

    private static int trainerLevel(String seriesId, String trainerId, TrainerMobData tmd) {
        return Math.max(Math.min(LevelUtils.maxLevel(), Math.max(0, LevelUtils.trainerLevel(tmd) + LevelUtils.relativeLevelCap(seriesId, trainerId))), tmd.getRequiredDefeats(seriesId).stream().flatMap(Collection::stream).map(tid -> LevelUtils.trainerLevel(seriesId, tid)).max(Integer::compare).orElse(0));
    }

    public static int maxLevel() {
        return 100;
    }
}

