/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.sync;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerType;
import com.gitlab.srcmc.rctmod.api.service.SeriesManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.utils.LevelUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.include.com.google.common.base.Objects;

public class PlayerState
implements Serializable {
    public static final int SYNC_INTERVAL_TICKS = 5;
    public static final int MIN_BATCH_SIZE = 64;
    public static final int MAX_BATCH_SIZE = 2048;
    private static final long serialVersionUID = 0L;
    private static final Map<UUID, PlayerState> remoteStates = new HashMap<UUID, PlayerState>();
    private static PlayerState localState;
    private Map<String, Integer> trainerDefeatCounts = new HashMap<String, Integer>();
    private Map<TrainerType, Integer> typeDefeatCounts = new HashMap<TrainerType, Integer>();
    private Set<String> defeatedTrainerIds = new HashSet<String>();
    private Set<String> removedDefeatedTrainerIds = new HashSet<String>();
    private String currentSeries = "";
    private transient Player player;
    private transient PlayerState updated;
    private transient boolean hasChanges = true;
    private transient Map<TrainerType, Integer> distinctTypeDefeatCounts = new HashMap<TrainerType, Integer>();
    private transient Map<String, Boolean> keyTrainerMap = new HashMap<String, Boolean>();
    private transient SeriesManager.SeriesGraph nextGraph;
    private transient boolean isLoading;

    public static void initFor(Player player) {
        if (player.level().isClientSide) {
            if (!player.isLocalPlayer()) {
                throw new IllegalArgumentException("Cannot initialize player state of other players on this client");
            }
            localState = new PlayerState(player);
        } else {
            remoteStates.put(player.getUUID(), new PlayerState(player));
            RCTMod.getInstance().getTrainerManager().getData(player).sync();
        }
    }

    public static PlayerState get(Player player) {
        if (player.level().isClientSide) {
            if (!player.isLocalPlayer()) {
                throw new IllegalArgumentException("Cannot retrieve player state of other players on this client");
            }
            return localState;
        }
        return remoteStates.get(player.getUUID());
    }

    public void setLoading() {
        this.setLoading(true);
    }

    protected void setLoading(boolean value) {
        this.isLoading = value;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public byte[] serializeUpdate() {
        byte[] byArray;
        if (!this.hasChanges) {
            return new byte[0];
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(buf);
        try {
            oos.writeObject(this.updated);
            this.updated = new PlayerState(this);
            this.hasChanges = false;
            byArray = buf.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    oos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        oos.close();
        return byArray;
    }

    public void deserializeUpdate(byte[] bytes) {
        ByteArrayInputStream buf = new ByteArrayInputStream(bytes);
        try (ObjectInputStream ois = new ObjectInputStream(buf);){
            this.update((PlayerState)ois.readObject());
            this.hasChanges = false;
            this.setLoading(false);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public int getLevelCap() {
        return LevelUtils.levelCap(this.player);
    }

    public void setCurrentSeries(String seriesId) {
        if (!Objects.equal((Object)this.currentSeries, (Object)seriesId)) {
            this.currentSeries = seriesId;
            this.updated.currentSeries = seriesId;
            this.keyTrainerMap.clear();
            this.updateDefeatCounts();
            this.nextGraph = null;
            this.hasChanges = true;
        }
    }

    public String getCurrentSeries() {
        return this.currentSeries;
    }

    public void addProgressDefeat(String trainerId) {
        if (this.defeatedTrainerIds.add(trainerId)) {
            this.updated.defeatedTrainerIds.add(trainerId);
            this.updated.removedDefeatedTrainerIds.remove(trainerId);
            this.keyTrainerMap.clear();
            this.nextGraph = null;
            this.hasChanges = true;
        }
    }

    public void removeProgressDefeat(String trainerId) {
        if (this.defeatedTrainerIds.remove(trainerId)) {
            this.updated.removedDefeatedTrainerIds.add(trainerId);
            this.updated.defeatedTrainerIds.remove(trainerId);
            this.keyTrainerMap.clear();
            this.nextGraph = null;
            this.hasChanges = true;
        }
    }

    public void removeProgressDefeats() {
        if (this.defeatedTrainerIds.size() > 0) {
            this.updated.removedDefeatedTrainerIds.addAll(this.defeatedTrainerIds);
            this.updated.defeatedTrainerIds.clear();
            this.defeatedTrainerIds.clear();
            this.keyTrainerMap.clear();
            this.nextGraph = null;
            this.hasChanges = true;
        }
    }

    public void addDefeat(String trainerId) {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        TrainerType tt = tm.getData(trainerId).getType();
        if (!this.trainerDefeatCounts.containsKey(trainerId)) {
            this.trainerDefeatCounts.put(trainerId, 1);
            this.updated.trainerDefeatCounts.put(trainerId, 1);
            this.distinctTypeDefeatCounts.compute(tt, (k, v) -> v == null ? 1 : v + 1);
        } else {
            this.updated.trainerDefeatCounts.put(trainerId, this.trainerDefeatCounts.compute(trainerId, (k, v) -> v == Integer.MAX_VALUE ? v : v + 1));
        }
        this.updated.typeDefeatCounts.put(tt, this.typeDefeatCounts.compute(tt, (k, v) -> v == null ? 1 : (v == Integer.MAX_VALUE ? v : v + 1)));
        this.keyTrainerMap.clear();
        this.nextGraph = null;
        this.hasChanges = true;
    }

    public void setDefeats(String trainerId, int defeats) {
        Integer currentDefeats = this.trainerDefeatCounts.getOrDefault(trainerId, 0);
        if (defeats != currentDefeats) {
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            TrainerType tt = tm.getData(trainerId).getType();
            Integer typeDefeats = this.typeDefeatCounts.getOrDefault(tt, 0);
            int newTypeDefeats = typeDefeats + (defeats - currentDefeats);
            if (newTypeDefeats == 0) {
                this.typeDefeatCounts.remove(tt);
            } else {
                this.typeDefeatCounts.put(tt, newTypeDefeats);
            }
            if (defeats == 0) {
                this.trainerDefeatCounts.remove(trainerId);
                this.distinctTypeDefeatCounts.compute(tt, (k, v) -> v != null ? Integer.valueOf(v - 1) : null);
            } else {
                this.trainerDefeatCounts.put(trainerId, defeats);
                if (currentDefeats == 0) {
                    this.distinctTypeDefeatCounts.compute(tt, (k, v) -> v == null ? 1 : v + 1);
                }
            }
            this.updated.trainerDefeatCounts.put(trainerId, defeats);
            this.updated.typeDefeatCounts.put(tt, newTypeDefeats);
            this.keyTrainerMap.clear();
            this.nextGraph = null;
            this.hasChanges = true;
        }
    }

    public Set<String> getDefeatedTrainerIds() {
        return Collections.unmodifiableSet(this.defeatedTrainerIds);
    }

    public long getTypeDefeatCount(TrainerType type) {
        return this.getTypeDefeatCount(type, false);
    }

    public long getTypeDefeatCount(TrainerType type, boolean distinct) {
        Integer count = distinct ? this.distinctTypeDefeatCounts.get(type) : this.typeDefeatCounts.get(type);
        return count == null ? 0L : (long)count.intValue();
    }

    public int getTrainerDefeatCount(String trainerId) {
        Integer count = this.trainerDefeatCounts.get(trainerId);
        return count == null ? 0 : count;
    }

    public long getTrainerDefeatCount() {
        return this.getTrainerDefeatCount(false);
    }

    public long getTrainerDefeatCount(boolean distinct) {
        if (distinct) {
            return this.trainerDefeatCounts.size();
        }
        return this.typeDefeatCounts.values().stream().mapToLong(i -> i.intValue()).reduce(0L, (i, j) -> i + j);
    }

    public boolean isKeyTrainer(String trainerId) {
        if (this.nextGraph == null) {
            this.nextGraph = RCTMod.getInstance().getSeriesManager().getGraph(this.currentSeries).getNext(this.defeatedTrainerIds);
        }
        return this.keyTrainerMap.computeIfAbsent(trainerId, k -> this.nextGraph.contains(trainerId));
    }

    public boolean canBattle(String trainerId) {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        TrainerMobData tmd = tm.getData(trainerId);
        return tmd.getMissingRequirements(this.defeatedTrainerIds).filter(tid -> tm.getData((String)tid).isOfSeries(this.getCurrentSeries())).findFirst().isEmpty();
    }

    protected Map<String, Integer> getTrainerDefeatCounts() {
        return Collections.unmodifiableMap(this.trainerDefeatCounts);
    }

    protected Map<TrainerType, Integer> getTypeDefeatCounts() {
        return Collections.unmodifiableMap(this.typeDefeatCounts);
    }

    private PlayerState(Player player) {
        this.player = player;
        this.updated = this;
        if (!player.level().isClientSide) {
            this.updateDefeatCounts();
        }
    }

    private PlayerState(PlayerState template) {
        this.currentSeries = template.currentSeries;
    }

    private void update(PlayerState updated) {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        updated.trainerDefeatCounts.forEach((trainerId, count) -> {
            TrainerType tt = tm.getData((String)trainerId).getType();
            if (count == 0) {
                if (this.trainerDefeatCounts.remove(trainerId) != null) {
                    this.distinctTypeDefeatCounts.compute(tt, (k, v) -> v != null && v > 1 ? Integer.valueOf(v - 1) : null);
                }
            } else if (this.trainerDefeatCounts.put((String)trainerId, (Integer)count) == null) {
                this.distinctTypeDefeatCounts.compute(tt, (k, v) -> v == null ? 1 : v + 1);
            }
        });
        updated.typeDefeatCounts.forEach((type, count) -> {
            if (count == 0) {
                this.typeDefeatCounts.remove(type);
            } else {
                this.typeDefeatCounts.put((TrainerType)type, (Integer)count);
            }
        });
        updated.defeatedTrainerIds.forEach(this.defeatedTrainerIds::add);
        updated.removedDefeatedTrainerIds.forEach(this.defeatedTrainerIds::remove);
        this.currentSeries = updated.currentSeries;
        this.keyTrainerMap.clear();
        this.nextGraph = null;
    }

    private void updateDefeatCounts() {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        ServerLevel overworld = this.player.getServer().overworld();
        List.copyOf(this.trainerDefeatCounts.keySet()).forEach(tid -> this.setDefeats((String)tid, 0));
        tm.getAllData(this.getCurrentSeries()).map(entry -> (String)entry.getKey()).forEach(tid -> this.setDefeats((String)tid, tm.getBattleMemory(overworld, (String)tid).getDefeatByCount((String)tid, this.player)));
    }
}

