/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.save;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerBattleMemoryLegacy;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelResource;

public class TrainerBattleMemory
extends SavedData {
    private static final int GROUPS = 42;
    private Map<String, Map<UUID, Integer>> defeatedBy = new HashMap<String, Map<UUID, Integer>>();
    private static final List<File> LEGACY_FILES = new ArrayList<File>();

    public static TrainerBattleMemory of(CompoundTag tag, HolderLookup.Provider provider) {
        TrainerBattleMemory tbm = new TrainerBattleMemory();
        CompoundTag defeats = tag.getCompound("defeats");
        defeats.getAllKeys().forEach(tid -> {
            HashMap defeatedBy = new HashMap();
            CompoundTag defeatsTag = defeats.getCompound(tid);
            defeatsTag.getAllKeys().forEach(pid -> defeatedBy.put(UUID.fromString(pid), defeatsTag.getInt(pid)));
            tbm.defeatedBy.put((String)tid, defeatedBy);
        });
        return tbm;
    }

    public static String filePath(String trainerId, Version ver) {
        return TrainerBattleMemory.filePath(trainerId, ver.groups);
    }

    protected static String filePath(String trainerId, int groups) {
        return String.format("%s.trainers.%d.mem", "rctmod", TrainerBattleMemory.groupdId(trainerId, groups));
    }

    protected static int groupdId(String trainerId, int groups) {
        return groups > 0 ? (trainerId.hashCode() & 0xFFFFFF) % groups : 0;
    }

    public void addDefeatedBy(String trainerId, Player player) {
        Integer count = (Integer)this.defeatedBy.getOrDefault(trainerId, Map.of()).get(player.getUUID());
        if (count == null) {
            count = 0;
        }
        if (count < Integer.MAX_VALUE) {
            RCTMod rct = RCTMod.getInstance();
            if (rct.getSeriesManager().getGraph(rct.getTrainerManager().getData(player).getCurrentSeries()).contains(trainerId)) {
                PlayerState.get(player).addDefeat(trainerId);
            }
            this.defeatedBy.computeIfAbsent(trainerId, key -> new HashMap()).put(player.getUUID(), count + 1);
            this.setDirty();
        }
    }

    public void setDefeatedBy(String trainerId, Player player, int count) {
        Integer prevCount = this.defeatedBy.computeIfAbsent(trainerId, key -> new HashMap()).put(player.getUUID(), count);
        if (prevCount == null || prevCount != count) {
            RCTMod rct = RCTMod.getInstance();
            if (rct.getSeriesManager().getGraph(rct.getTrainerManager().getData(player).getCurrentSeries()).contains(trainerId)) {
                PlayerState.get(player).setDefeats(trainerId, count);
            }
            this.setDirty();
        }
    }

    public int getDefeatByCount(String trainerId, Player player) {
        Integer count = (Integer)this.defeatedBy.getOrDefault(trainerId, Map.of()).get(player.getUUID());
        return count == null ? 0 : count;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag defeatsTag = new CompoundTag();
        this.defeatedBy.forEach((tid, defeatedBy) -> {
            CompoundTag tag = new CompoundTag();
            defeatedBy.forEach((pid, count) -> tag.putInt(pid.toString(), count.intValue()));
            defeatsTag.put(tid, (Tag)tag);
        });
        compoundTag.put("defeats", (Tag)defeatsTag);
        return compoundTag;
    }

    public static Version getVersion(DimensionDataStorage dds) {
        return (Version)dds.computeIfAbsent(new SavedData.Factory(Version::new, Version::of, DataFixTypes.LEVEL), Version.filePath());
    }

    public static void clearLegacyFiles() {
        LEGACY_FILES.forEach(f -> f.delete());
        LEGACY_FILES.clear();
    }

    public static void migrate(MinecraftServer server, TrainerManager tm) {
        DimensionDataStorage dds = server.overworld().getDataStorage();
        Version ver = TrainerBattleMemory.getVersion(dds);
        if (ver.isOutdated()) {
            HashMap<String, TrainerBattleMemory> cache = new HashMap<String, TrainerBattleMemory>();
            HashSet oldPaths = new HashSet();
            tm.getAllData(new String[0]).map(e -> (String)e.getKey()).forEach(tid -> {
                TrainerBattleMemoryLegacy legTbm;
                String path;
                TrainerBattleMemory oldTbm;
                if (ver.groups > 0 && (oldTbm = (TrainerBattleMemory)dds.get(new SavedData.Factory(() -> {
                    throw new IllegalStateException("nope");
                }, TrainerBattleMemory::of, DataFixTypes.LEVEL), path = TrainerBattleMemory.filePath(tid, ver))) != null) {
                    oldTbm.defeatedBy.forEach((tid2, defeatedBy) -> {
                        ModCommon.LOG.info(String.format("migrating trainer data: v%02d -> v%02d, %s", ver.groups, 42, tid2));
                        TrainerBattleMemory newTbm = cache.computeIfAbsent(TrainerBattleMemory.filePath(tid2, 42), t -> new TrainerBattleMemory());
                        newTbm.defeatedBy.put((String)tid2, (Map<UUID, Integer>)defeatedBy);
                        newTbm.setDirty();
                    });
                    oldPaths.add(path);
                    dds.set(path, null);
                }
                if ((legTbm = (TrainerBattleMemoryLegacy)dds.get(new SavedData.Factory(() -> {
                    throw new IllegalStateException("nope");
                }, TrainerBattleMemoryLegacy::of, DataFixTypes.LEVEL), path = TrainerBattleMemoryLegacy.filePath(tid))) != null) {
                    ModCommon.LOG.info(String.format("migrating trainer data: legacy -> v%02d, %s", 42, tid));
                    TrainerBattleMemory newTbm = cache.computeIfAbsent(TrainerBattleMemory.filePath(tid, 42), t -> new TrainerBattleMemory());
                    newTbm.defeatedBy.put((String)tid, legTbm.defeatedBy);
                    newTbm.setDirty();
                    oldPaths.add(path);
                    dds.set(path, null);
                }
            });
            cache.forEach((path, tbm) -> dds.set(path, (SavedData)tbm));
            oldPaths.removeAll(cache.keySet());
            oldPaths.forEach(path -> LEGACY_FILES.add(Paths.get(server.getWorldPath(LevelResource.ROOT).toString(), "data", path + ".dat").toFile()));
            ver.update();
        }
    }

    public static class Version
    extends SavedData {
        private int groups;

        private static String filePath() {
            return String.format("%s.trainers.ver", "rctmod");
        }

        private static Version of(CompoundTag tag, HolderLookup.Provider provider) {
            Version ver = new Version();
            ver.groups = tag.getInt("groups");
            return ver;
        }

        public boolean isOutdated() {
            return this.groups != 42;
        }

        public void update() {
            this.groups = 42;
            this.setDirty();
        }

        public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
            tag.putInt("groups", this.groups);
            return tag;
        }

        public int hashCode() {
            return this.groups;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof Version)) return false;
            Version other = (Version)((Object)obj);
            if (other.groups != this.groups) return false;
            return true;
        }
    }
}

