/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.pack;

import com.gitlab.srcmc.rctapi.api.models.PokemonModel;
import com.gitlab.srcmc.rctapi.api.util.Text;
import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.data.pack.IDataPackObject;
import com.gitlab.srcmc.rctmod.api.data.pack.SeriesMetaData;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerTeam;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerType;
import com.gitlab.srcmc.rctmod.api.utils.ChatUtils;
import com.gitlab.srcmc.rctmod.api.utils.JsonUtils;
import com.gitlab.srcmc.rctmod.api.utils.LangKeys;
import com.gitlab.srcmc.rctmod.api.utils.PathUtils;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class DataPackManager
extends SimpleJsonResourceReloadListener
implements AutoCloseable {
    public static final String PATH_GROUPS = "trainers/groups";
    public static final String PATH_SINGLE = "trainers/single";
    public static final String PATH_DEFAULT = "trainers/default";
    public static final String PATH_TRAINERS = "trainers";
    public static final String PATH_TRAINER_TYPES = "trainer_types";
    public static final String PATH_SERIES = "series";
    private final Map<String, DataLocator> contextMap = Map.ofEntries(Map.entry("mobs", new DataLocator(PackType.SERVER_DATA, ".json")), Map.entry("dialogs", new DataLocator(PackType.SERVER_DATA, ".json")), Map.entry("loot_table", new DataLocator(PackType.SERVER_DATA, ".json")), Map.entry("textures", new DataLocator(PackType.CLIENT_RESOURCES, ".png")));
    private Map<ResourceLocation, PackResources> trainerTeams = new HashMap<ResourceLocation, PackResources>();
    private Map<ResourceLocation, PackResources> trainerTypes = new HashMap<ResourceLocation, PackResources>();
    private Map<ResourceLocation, PackResources> series = new HashMap<ResourceLocation, PackResources>();
    private PackType packType;

    public DataPackManager(PackType packType) {
        super(JsonUtils.GSON, "rctmod");
        this.packType = packType;
    }

    public void init(ResourceManager resourceManager) {
        this.clear();
        resourceManager.listPacks().filter(dp -> !dp.packId().startsWith("mod/generated_")).filter(dp -> dp.getNamespaces(this.packType).contains("rctmod")).forEach(this::gather);
    }

    public void listTrainerTeams(PackResources.ResourceOutput out) {
        this.trainerTeams.forEach((k, v) -> out.accept(k, (Object)v.getResource(this.packType, k)));
    }

    public void listTrainerTypes(PackResources.ResourceOutput out) {
        this.trainerTypes.forEach((k, v) -> out.accept(k, (Object)v.getResource(this.packType, k)));
    }

    public void listSeries(PackResources.ResourceOutput out) {
        this.series.forEach((k, v) -> out.accept(k, (Object)v.getResource(this.packType, k)));
    }

    @Override
    public void close() {
        for (DataLocator dl : this.contextMap.values()) {
            for (PackResources dp : dl.groupData.values()) {
                dp.close();
            }
            for (PackResources dp : dl.singleData.values()) {
                dp.close();
            }
            if (dl.defaultData == null) continue;
            dl.defaultData.getValue().close();
        }
        for (PackResources dp : this.trainerTeams.values()) {
            dp.close();
        }
        for (PackResources dp : this.trainerTypes.values()) {
            dp.close();
        }
        for (PackResources dp : this.series.values()) {
            dp.close();
        }
    }

    protected void clear() {
        for (DataLocator dl : this.contextMap.values()) {
            dl.groupData.clear();
            dl.singleData.clear();
            dl.defaultData = null;
        }
        this.trainerTeams.clear();
        this.trainerTypes.clear();
        this.series.clear();
    }

    public Optional<ResourceLocation> findResource(String trainerId, String context) {
        DataLocator dl = this.contextMap.get(context);
        if (dl == null) {
            return Optional.empty();
        }
        ResourceLocation singlePath = ResourceLocation.fromNamespaceAndPath((String)"rctmod", (String)(context + "/trainers/single/" + trainerId + dl.fileSuffix));
        if (dl.singleData.containsKey(singlePath)) {
            return Optional.of(singlePath);
        }
        ResourceLocation groupsPath = this.findGroupsKey(trainerId, dl.groupData);
        if (groupsPath != null) {
            return Optional.of(groupsPath);
        }
        if (dl.defaultData != null) {
            return Optional.of(dl.defaultData.getKey());
        }
        return Optional.empty();
    }

    public Optional<TrainerTeam> loadTrainerTeam(String trainerId) {
        ResourceLocation teamResource = ResourceLocation.fromNamespaceAndPath((String)"rctmod", (String)("trainers/" + trainerId + ".json"));
        if (this.trainerTeams.containsKey(teamResource)) {
            TrainerTeam tt = JsonUtils.loadFromOrThrow((IoSupplier<InputStream>)this.trainerTeams.get(teamResource).getResource(this.packType, teamResource), TrainerTeam.class);
            if (tt.getName().getTranslatable() == null) {
                tt.getName().setTranslatable(LangKeys.TRAINER_NAME(trainerId));
            }
            int i = 0;
            for (PokemonModel pk : tt.getTeam()) {
                if (pk.getNickname().getTranslatable() == null) {
                    pk.getNickname().setTranslatable(LangKeys.POKEMON_NICKNAME(trainerId, i));
                }
                ++i;
            }
            return Optional.of(tt);
        }
        return Optional.empty();
    }

    public Optional<TrainerType> loadTrainerType(String typeId) {
        ResourceLocation typeResource = ResourceLocation.fromNamespaceAndPath((String)"rctmod", (String)("trainer_types/" + typeId + ".json"));
        if (this.trainerTypes.containsKey(typeResource)) {
            TrainerType tt = JsonUtils.loadFromOrThrow((IoSupplier<InputStream>)this.trainerTypes.get(typeResource).getResource(this.packType, typeResource), TrainerType.class);
            if (tt.name().getTranslatable() == null) {
                tt.name().setTranslatable(LangKeys.TRAINER_TYPE_TITLE(typeId));
            }
            return Optional.of(tt);
        }
        return Optional.empty();
    }

    public Optional<SeriesMetaData> loadSeries(String seriesId) {
        ResourceLocation seriesResource = ResourceLocation.fromNamespaceAndPath((String)"rctmod", (String)("series/" + seriesId + ".json"));
        if (this.series.containsKey(seriesResource)) {
            SeriesMetaData smd = JsonUtils.loadFromOrThrow((IoSupplier<InputStream>)this.series.get(seriesResource).getResource(this.packType, seriesResource), SeriesMetaData.class);
            if (smd.title().getTranslatable() == null) {
                smd.title().setTranslatable(LangKeys.SERIES_TITLE(seriesId));
            }
            if (smd.description().getTranslatable() == null) {
                smd.description().setTranslatable(LangKeys.SERIES_DESCRIPTION(seriesId));
            }
            return Optional.of(smd);
        }
        return Optional.empty();
    }

    public <T> void loadResource(String trainerId, String context, Consumer<T> consumer, Class<T> type) {
        this.loadResource(trainerId, context, consumer, TypeToken.get(type));
    }

    public <T> void loadResource(String trainerId, String context, Consumer<T> consumer, TypeToken<T> type) {
        ResourceLocation groupsPath;
        DataLocator dl = this.contextMap.get(context);
        ResourceLocation singlePath = ResourceLocation.fromNamespaceAndPath((String)"rctmod", (String)(context + "/trainers/single/" + trainerId + dl.fileSuffix));
        T obj = dl.singleData.containsKey(singlePath) ? JsonUtils.loadFromOrThrow((IoSupplier<InputStream>)dl.singleData.get(singlePath).getResource(dl.packType, singlePath), type) : ((groupsPath = this.findGroupsKey(trainerId, dl.groupData)) != null ? JsonUtils.loadFromOrThrow((IoSupplier<InputStream>)dl.groupData.get(groupsPath).getResource(dl.packType, groupsPath), type) : JsonUtils.loadFromOrThrow((IoSupplier<InputStream>)dl.defaultData.getValue().getResource(dl.packType, dl.defaultData.getKey()), type));
        if (obj instanceof IDataPackObject) {
            IDataPackObject dpo = (IDataPackObject)obj;
            dpo.onLoad(this, trainerId, context);
        }
        consumer.accept(obj);
    }

    private void gather(PackResources dataPack) {
        this.gatherTrainers(dataPack);
        this.gatherTrainerTypes(dataPack);
        this.gatherSeries(dataPack);
        this.gatherResources(dataPack);
        ModCommon.LOG.info("Data pack initialized: " + dataPack.packId());
    }

    private void gatherTrainers(PackResources dataPack) {
        dataPack.listResources(this.packType, "rctmod", PATH_TRAINERS, (rl, io) -> this.trainerTeams.put((ResourceLocation)rl, dataPack));
    }

    private void gatherTrainerTypes(PackResources dataPack) {
        dataPack.listResources(this.packType, "rctmod", PATH_TRAINER_TYPES, (rl, io) -> this.trainerTypes.put((ResourceLocation)rl, dataPack));
    }

    private void gatherSeries(PackResources dataPack) {
        dataPack.listResources(this.packType, "rctmod", PATH_SERIES, (rl, io) -> this.series.put((ResourceLocation)rl, dataPack));
    }

    private void gatherResources(PackResources dataPack) {
        for (Map.Entry<String, DataLocator> entry : this.contextMap.entrySet()) {
            this.scanDataPack(dataPack, entry.getKey(), entry.getValue());
        }
    }

    private void scanDataPack(PackResources dataPack, String context, DataLocator dl) {
        dataPack.listResources(dl.packType, "rctmod", context + "/trainers/groups", (rl, io) -> dl.groupData.put((ResourceLocation)rl, dataPack));
        dataPack.listResources(dl.packType, "rctmod", context + "/trainers/single", (rl, io) -> dl.singleData.put((ResourceLocation)rl, dataPack));
        ResourceLocation defaultRl = ResourceLocation.fromNamespaceAndPath((String)"rctmod", (String)(context + "/trainers/default" + dl.fileSuffix));
        IoSupplier defaultData = dataPack.getResource(dl.packType, defaultRl);
        if (defaultData != null) {
            dl.defaultData = Map.entry(defaultRl, dataPack);
        }
    }

    private ResourceLocation findGroupsKey(String trainerId, Map<ResourceLocation, PackResources> groups) {
        ResourceLocation key = null;
        String longestGroupId = "";
        for (Map.Entry<ResourceLocation, PackResources> groupsEntry : groups.entrySet()) {
            String groupsId = PathUtils.filename(groupsEntry.getKey().getPath());
            if (groupsId.length() <= longestGroupId.length() || !trainerId.equals(groupsId) && !trainerId.startsWith(groupsId + "_")) continue;
            key = groupsEntry.getKey();
            longestGroupId = groupsId;
        }
        return key;
    }

    protected void reload(ResourceManager resourceManager) {
        this.init(resourceManager);
        if (this.packType.equals((Object)PackType.SERVER_DATA)) {
            TrainerType.clear();
            this.listTrainerTypes((rl, io) -> {
                String id = PathUtils.filename(rl.getPath());
                TrainerType.register(id, this.loadTrainerType(id).get());
            });
            this.loadResource("", "dialogs", ChatUtils::initDefault, new TypeToken<Map<String, Text[]>>(this){});
        }
        this.close();
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.reload(resourceManager);
    }

    private static class DataLocator {
        public final Map<ResourceLocation, PackResources> groupData = new HashMap<ResourceLocation, PackResources>();
        public final Map<ResourceLocation, PackResources> singleData = new HashMap<ResourceLocation, PackResources>();
        public Map.Entry<ResourceLocation, PackResources> defaultData;
        public final PackType packType;
        public final String fileSuffix;

        public DataLocator(PackType packType, String fileSuffix) {
            this.packType = packType;
            this.fileSuffix = fileSuffix;
        }
    }
}

