/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.network.handler;

import com.direwolf20.buildinggadgets2.common.events.ServerTickHandler;
import com.direwolf20.buildinggadgets2.common.network.data.RequestCopyDataPayload;
import com.direwolf20.buildinggadgets2.common.network.data.SendCopyDataPayload;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PacketRequestCopyData {
    public static final PacketRequestCopyData INSTANCE = new PacketRequestCopyData();

    public static PacketRequestCopyData get() {
        return INSTANCE;
    }

    public void handle(RequestCopyDataPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (ServerTickHandler.gadgetWorking(payload.gadgetUUID())) {
                return;
            }
            ServerPlayer player = (ServerPlayer)context.player();
            BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(player.level().getServer()).overworld());
            CompoundTag tag = bg2Data.getCopyPasteListAsNBTMap(payload.gadgetUUID(), false);
            player.connection.send((CustomPacketPayload)new SendCopyDataPayload(payload.gadgetUUID(), payload.copyUUID(), tag));
        });
    }
}

