/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.items;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.SoundTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.IScreenModuleUpdater;
import mcjty.rftoolsbase.api.screens.ITooltipInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerModule;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record StorageControlScreenModule(GlobalPos pos, boolean starred, int dirty, List<ItemStack> stacks) implements IScreenModule<StorageControlScreenModule, ModuleDataStacks>,
ITooltipInfo,
IScreenModuleUpdater
{
    public static final StorageControlScreenModule DEFAULT = new StorageControlScreenModule(GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPosTools.INVALID), false, -1, Collections.nCopies(9, ItemStack.EMPTY));
    public static final Codec<StorageControlScreenModule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.CODEC.fieldOf("pos").forGetter(StorageControlScreenModule::pos), (App)Codec.BOOL.fieldOf("starred").forGetter(StorageControlScreenModule::starred), (App)Codec.INT.fieldOf("dirty").forGetter(StorageControlScreenModule::dirty), (App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("stacks").forGetter(StorageControlScreenModule::stacks)).apply((Applicative)instance, StorageControlScreenModule::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, StorageControlScreenModule> STREAM_CODEC = StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, StorageControlScreenModule::pos, (StreamCodec)ByteBufCodecs.BOOL, StorageControlScreenModule::starred, (StreamCodec)ByteBufCodecs.INT, StorageControlScreenModule::dirty, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()), StorageControlScreenModule::stacks, StorageControlScreenModule::new);

    public ModuleDataStacks getData(IScreenDataHelper helper, Level worldObj, long millis) {
        IStorageScanner scannerTileEntity = StorageControlScreenModule.getStorageScanner(worldObj, (ResourceKey<Level>)this.pos.dimension(), this.pos.pos());
        if (scannerTileEntity == null) {
            return null;
        }
        int[] amounts = new int[this.stacks.size()];
        for (int i = 0; i < this.stacks.size(); ++i) {
            amounts[i] = scannerTileEntity.countItems(this.stacks.get(i), this.starred);
        }
        return new ModuleDataStacks(amounts);
    }

    public static IStorageScanner getStorageScanner(Level worldObj, ResourceKey<Level> dim, BlockPos coordinate) {
        ServerLevel world = LevelTools.getLevel((Level)worldObj, dim);
        if (world == null) {
            return null;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)coordinate)) {
            return null;
        }
        BlockEntity te = world.getBlockEntity(coordinate);
        if (te == null) {
            return null;
        }
        if (!(te instanceof IStorageScanner)) {
            return null;
        }
        return (IStorageScanner)te;
    }

    public StorageControlScreenModule validate(Level world, BlockPos pos, boolean isPlus) {
        return this;
    }

    private int getHighlightedStack(int hitx, int hity) {
        int i = 0;
        for (int yy = 0; yy < 3; ++yy) {
            int y = 7 + yy * 35;
            for (int xx = 0; xx < 3; ++xx) {
                boolean hilighted;
                int x = xx * 40;
                boolean bl = hilighted = hitx >= x + 8 && hitx <= x + 38 && hity >= y - 7 && hity <= y + 22;
                if (hilighted) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public List<String> getInfo(Level world, int x, int y) {
        int i;
        IStorageScanner te = StorageControlScreenModule.getStorageScanner(world, (ResourceKey<Level>)this.pos.dimension(), this.pos.pos());
        if (te != null && (i = this.getHighlightedStack(x, y)) != -1 && !this.stacks.get(i).isEmpty()) {
            return Collections.singletonList(String.valueOf(ChatFormatting.GREEN) + "Item: " + String.valueOf(ChatFormatting.WHITE) + String.valueOf(this.stacks.get(i).getHoverName()));
        }
        return Collections.emptyList();
    }

    public int getRfPerTick() {
        return (Integer)StorageScannerConfiguration.STORAGE_CONTROL_RFPERTICK.get();
    }

    public StorageControlScreenModule withPos(GlobalPos pos) {
        return new StorageControlScreenModule(pos, this.starred, this.dirty, this.stacks);
    }

    public StorageControlScreenModule withStack(int index, ItemStack stack) {
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>(this.stacks);
        newStacks.set(index, stack);
        return new StorageControlScreenModule(this.pos, this.starred, this.dirty, newStacks);
    }

    public StorageControlScreenModule withStarred(boolean starred) {
        return new StorageControlScreenModule(this.pos, starred, this.dirty, this.stacks);
    }

    private boolean isShown(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (ItemStack s : this.stacks) {
            if (!StorageControlScreenModule.isItemEqual(stack, s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemEqual(ItemStack thisItem, ItemStack other) {
        if (other.isEmpty()) {
            return false;
        }
        return ItemStack.isSameItem((ItemStack)thisItem, (ItemStack)other);
    }

    public ItemStack update(ItemStack module, Level world, Player player) {
        if (this.dirty >= 0) {
            ItemStack copy = module.copy();
            StorageControlScreenModule data = ((StorageControlScreenModule)copy.get(StorageScannerModule.MODULE_CONTROL_DATA)).withStack(this.dirty, this.stacks.get(this.dirty)).withDirty(-1);
            copy.set(StorageScannerModule.MODULE_CONTROL_DATA, (Object)data);
            if (player != null) {
                SoundTools.playSound((Level)player.getCommandSenderWorld(), (SoundEvent)SoundEvents.EXPERIENCE_ORB_PICKUP, (double)player.blockPosition().getX(), (double)player.blockPosition().getY(), (double)player.blockPosition().getZ(), (double)1.0, (double)1.0);
            }
            return copy;
        }
        return ItemStack.EMPTY;
    }

    private StorageControlScreenModule withDirty(int dirty) {
        return new StorageControlScreenModule(this.pos, this.starred, dirty, this.stacks);
    }

    public ItemStack mouseClick(ItemStack moduleStack, Level world, int hitx, int hity, boolean clicked, Player player) {
        if (!clicked || player == null) {
            return ItemStack.EMPTY;
        }
        if (BlockPosTools.INVALID.equals((Object)this.pos.pos())) {
            player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "Module is not linked to storage scanner!")), false);
            return ItemStack.EMPTY;
        }
        IStorageScanner scannerTileEntity = StorageControlScreenModule.getStorageScanner(player.level(), (ResourceKey<Level>)this.pos.dimension(), this.pos.pos());
        if (scannerTileEntity == null) {
            return ItemStack.EMPTY;
        }
        if (hitx >= 0) {
            boolean insertAllActive;
            boolean insertStackActive;
            boolean bl = insertStackActive = hitx >= 0 && hitx < 60 && hity > 98;
            if (insertStackActive) {
                if (this.isShown(player.getItemInHand(InteractionHand.MAIN_HAND))) {
                    ItemStack stack = scannerTileEntity.injectStackFromScreen(player.getItemInHand(InteractionHand.MAIN_HAND), player);
                    player.setItemInHand(InteractionHand.MAIN_HAND, stack);
                }
                player.containerMenu.broadcastChanges();
                return ItemStack.EMPTY;
            }
            boolean bl2 = insertAllActive = hitx >= 60 && hity > 98;
            if (insertAllActive) {
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    if (!this.isShown(player.getInventory().getItem(i))) continue;
                    ItemStack stack = scannerTileEntity.injectStackFromScreen(player.getInventory().getItem(i), player);
                    player.getInventory().setItem(i, stack);
                }
                player.containerMenu.broadcastChanges();
                return ItemStack.EMPTY;
            }
            int i = this.getHighlightedStack(hitx, hity);
            if (i != -1) {
                if (this.stacks.get(i).isEmpty()) {
                    ItemStack heldItem = player.getMainHandItem();
                    if (!heldItem.isEmpty()) {
                        StorageControlScreenModule data = this.withStack(i, heldItem.copy()).withDirty(i);
                        moduleStack.set(StorageScannerModule.MODULE_CONTROL_DATA, (Object)data);
                        return moduleStack;
                    }
                } else {
                    scannerTileEntity.giveToPlayerFromScreen(this.stacks.get(i), player.isShiftKeyDown(), player);
                }
            }
        }
        return ItemStack.EMPTY;
    }

    public static class ModuleDataStacks
    implements IModuleData {
        public static final String ID = "rftoolsstorage:storage";
        private int[] amounts = null;

        public String getId() {
            return ID;
        }

        public ModuleDataStacks(int ... amountsIn) {
            this.amounts = amountsIn;
        }

        public ModuleDataStacks(ByteBuf buf) {
            int s = buf.readInt();
            this.amounts = new int[s];
            for (int i = 0; i < s; ++i) {
                this.amounts[i] = buf.readInt();
            }
        }

        public int getAmount(int idx) {
            return this.amounts[idx];
        }

        public void writeToBuf(RegistryFriendlyByteBuf buf) {
            buf.writeInt(this.amounts.length);
            for (int i : this.amounts) {
                buf.writeInt(i);
            }
        }
    }
}

