/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public record TargetComponentIngredient(Ingredient ingredient) implements ICustomIngredient
{
    public static final MapCodec<TargetComponentIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("base").forGetter(TargetComponentIngredient::ingredient)).apply((Applicative)builder, TargetComponentIngredient::new));

    @Nonnull
    public Stream<ItemStack> getItems() {
        return Stream.of(this.ingredient.getItems());
    }

    public boolean test(@Nonnull ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public boolean isSimple() {
        return this.ingredient.isSimple();
    }

    @Nonnull
    public IngredientType<?> getType() {
        return ActuallyRecipes.Ingredients.TARGET_NBT.get();
    }

    public static Ingredient of(ItemLike itemProvider) {
        return new TargetComponentIngredient(Ingredient.of((ItemLike[])new ItemLike[]{itemProvider})).toVanilla();
    }

    public static Ingredient of(ItemStack itemStack) {
        return new TargetComponentIngredient(Ingredient.of((ItemStack[])new ItemStack[]{itemStack})).toVanilla();
    }

    public static Ingredient of(@Nonnull TagKey<Item> tag) {
        return new TargetComponentIngredient(Ingredient.of(tag)).toVanilla();
    }
}

