/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.server.storage;

import com.github.jarva.arsadditions.server.sync.SourceJarSync;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class EnderSourceData
extends SavedData {
    public HashMap<UUID, Integer> source = new HashMap();

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        for (Map.Entry<UUID, Integer> entry : this.source.entrySet()) {
            UUID uuid = entry.getKey();
            Integer source = entry.getValue();
            if (uuid == null) continue;
            tag.putInt(uuid.toString(), source.intValue());
        }
        return tag;
    }

    public void update(UUID uuid, int source) {
        this.source.put(uuid, source);
        this.setDirty();
    }

    public static EnderSourceData create() {
        return new EnderSourceData();
    }

    public static EnderSourceData load(CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        EnderSourceData data = EnderSourceData.create();
        List<UUID> uuids = tag.getAllKeys().stream().map(UUID::fromString).toList();
        for (UUID uuid : uuids) {
            if (uuid == null) continue;
            data.source.put(uuid, tag.getInt(uuid.toString()));
        }
        return data;
    }

    public static EnderSourceData getData(MinecraftServer server) {
        return (EnderSourceData)server.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(EnderSourceData::create, EnderSourceData::load), "ender_source_data");
    }

    public static int getSource(MinecraftServer server, UUID uuid) {
        return EnderSourceData.getData((MinecraftServer)server).source.computeIfAbsent(uuid, k -> 0);
    }

    public static void setSource(MinecraftServer server, UUID uuid, int source) {
        if (source != EnderSourceData.getSource(server, uuid)) {
            EnderSourceData data = EnderSourceData.getData(server);
            data.update(uuid, source);
            SourceJarSync.updateSourceLevel(server, uuid);
        }
    }
}

