/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen;

import com.github.jarva.arsadditions.common.block.EnchantingWixieCauldron;
import com.github.jarva.arsadditions.common.block.WarpNexus;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.names.AddonBlockNames;
import com.hollingsworth.arsnouveau.setup.registry.BlockEntityTypeRegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistryWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyCustomDataFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class DefaultLootDatagen
extends LootTableProvider {
    public DefaultLootDatagen(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, new HashSet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTableProvider::new, LootContextParamSets.BLOCK)), registries);
    }

    public static class BlockLootTableProvider
    extends BlockLootSubProvider {
        private final List<Block> list = new ArrayList<Block>();

        protected BlockLootTableProvider(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), new HashMap(), provider);
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
            this.generate();
            HashSet<ResourceKey> set = new HashSet<ResourceKey>();
            for (Block block : this.list) {
                LootTable.Builder loottable$builder;
                ResourceKey resourcelocation;
                if (!block.isEnabled(this.enabledFeatures) || (resourcelocation = block.getLootTable()) == BuiltInLootTables.EMPTY || !set.add(resourcelocation) || (loottable$builder = (LootTable.Builder)this.map.remove(resourcelocation)) == null) continue;
                output.accept((ResourceKey<LootTable>)resourcelocation, loottable$builder);
            }
        }

        protected void generate() {
            String[][] nameList;
            this.registerManaMachine(AddonBlockRegistry.ENDER_SOURCE_JAR, AddonBlockRegistry.ENDER_SOURCE_JAR_TILE);
            for (String[] names : nameList = new String[][]{AddonBlockNames.CHAINS, AddonBlockNames.MAGELIGHT_LANTERNS, AddonBlockNames.LANTERNS, AddonBlockNames.BUTTONS, AddonBlockNames.DECORATIVE_SOURCESTONES, AddonBlockNames.WALLS, AddonBlockNames.TRAPDOORS, AddonBlockNames.CARPETS}) {
                for (Block block : AddonBlockRegistry.getBlocks(names)) {
                    this.registerDropSelf(block);
                }
            }
            String[] doors = AddonBlockNames.DOORS;
            for (Block door : AddonBlockRegistry.getBlocks(doors)) {
                this.list.add(door);
                this.add(door, this.createDoorTable(door));
            }
            this.registerDropSelf((Block)AddonBlockRegistry.SOURCE_SPAWNER.get());
            WarpNexus warpNexus = (WarpNexus)((Object)AddonBlockRegistry.WARP_NEXUS.get());
            LootPool.Builder nexusBuilder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)warpNexus).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyCustomDataFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("Inventory", "BlockEntityTag.Inventory", CopyCustomDataFunction.MergeStrategy.REPLACE).copy("color", "BlockEntityTag.color", CopyCustomDataFunction.MergeStrategy.REPLACE)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)warpNexus).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(WarpNexus.HALF, (Comparable)DoubleBlockHalf.LOWER))));
            this.list.add(warpNexus);
            this.add(warpNexus, LootTable.lootTable().withPool(nexusBuilder));
            EnchantingWixieCauldron enchantingWixieCauldron = (EnchantingWixieCauldron)((Object)AddonBlockRegistry.WIXIE_ENCHANTING.get());
            this.list.add((Block)enchantingWixieCauldron);
            this.dropOther((Block)enchantingWixieCauldron, (ItemLike)BlockRegistry.ENCHANTING_APP_BLOCK);
        }

        private void registerDropSelf(Block block) {
            this.list.add(block);
            this.dropSelf(block);
        }

        private <B extends Block, T extends BlockEntity> void registerManaMachine(BlockRegistryWrapper<B> block, BlockEntityTypeRegistryWrapper<T> tile) {
            this.list.add((Block)block.get());
            this.add((Block)block.get(), this.createManaMachineTable((Block)block.get(), (BlockEntityType)tile.get()));
        }

        public LootTable.Builder createManaMachineTable(Block block, BlockEntityType<?> tile) {
            LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyCustomDataFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("source", "BlockEntityTag.source", CopyCustomDataFunction.MergeStrategy.REPLACE).copy("max_source", "BlockEntityTag.max_source", CopyCustomDataFunction.MergeStrategy.REPLACE)));
            return LootTable.lootTable().withPool(builder);
        }
    }
}

