/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.util;

import com.github.jarva.arsadditions.common.block.tile.EnderSourceJarTile;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.tile.CreativeSourceJarTile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class AddonSourceUtil {
    public static boolean takeSource(BlockPos pos, Level level, int range, int requiredSource) {
        ISourceTile tile;
        List availablePositions = SourceUtil.canTakeSource((BlockPos)pos, (Level)level, (int)range);
        HashMap<ISpecialSourceProvider, Integer> toTakeFrom = new HashMap<ISpecialSourceProvider, Integer>();
        boolean usingEnderJar = false;
        int neededSource = requiredSource;
        while (neededSource > 0) {
            int remainingSource = Math.min(neededSource, 10000);
            int foundJars = toTakeFrom.size();
            for (int i = 0; i < availablePositions.size(); ++i) {
                boolean hasEnough;
                ISpecialSourceProvider provider = (ISpecialSourceProvider)availablePositions.get(i);
                tile = provider.getSource();
                if (tile instanceof CreativeSourceJarTile) {
                    neededSource = 0;
                    toTakeFrom.clear();
                }
                if (tile instanceof EnderSourceJarTile) {
                    if (usingEnderJar) continue;
                    usingEnderJar = true;
                }
                boolean bl = hasEnough = tile.getSource() >= remainingSource;
                if (!hasEnough) continue;
                neededSource -= remainingSource;
                toTakeFrom.put(provider, remainingSource);
                availablePositions.remove(i);
                break;
            }
            if (foundJars != toTakeFrom.size()) continue;
            return false;
        }
        for (Map.Entry entry : toTakeFrom.entrySet()) {
            ISpecialSourceProvider provider = (ISpecialSourceProvider)entry.getKey();
            Integer source = (Integer)entry.getValue();
            tile = provider.getSource();
            if (tile.getSource() >= source) {
                tile.removeSource(source.intValue());
                continue;
            }
            return false;
        }
        return true;
    }
}

