/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item.data.mark;

import com.github.jarva.arsadditions.common.item.UnstableReliquary;
import com.github.jarva.arsadditions.common.item.data.mark.MarkData;
import com.github.jarva.arsadditions.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public record LocationMarkData(GlobalPos pos) implements MarkData
{
    public static final MapCodec<LocationMarkData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)GlobalPos.CODEC.fieldOf("global").forGetter(LocationMarkData::pos)).apply((Applicative)inst, LocationMarkData::new));

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        MutableComponent loc = Component.translatable((String)"tooltip.ars_additions.reliquary.marked.location", (Object[])new Object[]{this.pos.pos().getX(), this.pos.pos().getY(), this.pos.pos().getZ()});
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.ars_additions.reliquary.marked", (Object[])new Object[]{loc}));
    }

    @Override
    public CastResolveType cast(SpellContext context, ItemStack reliquary, ServerLevel level, LivingEntity caster, SpellResolver resolver) {
        if (!this.pos.dimension().equals(level.dimension())) {
            return CastResolveType.FAILURE;
        }
        Direction direction = caster.getDirection();
        IWrappedCaster iWrappedCaster = context.getCaster();
        if (iWrappedCaster instanceof TileCaster) {
            TileCaster tileCaster = (TileCaster)iWrappedCaster;
            direction = tileCaster.getFacingDirection();
        }
        BlockHitResult bhr = new BlockHitResult(this.pos.pos().getCenter(), direction, this.pos.pos(), false);
        resolver.onResolveEffect(caster.level(), (HitResult)bhr);
        UnstableReliquary.damage(this, reliquary, caster);
        return CastResolveType.SUCCESS;
    }

    @Override
    public int damageAmount(ItemStack stack, LivingEntity entity, @Nullable Entity target) {
        return (Integer)ServerConfig.SERVER.reliquary_cost_location.get();
    }

    @Override
    public MapCodec<? extends MarkData> codec() {
        return CODEC;
    }
}

