/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item;

import com.github.jarva.arsadditions.common.item.data.AdvancedDominionData;
import com.github.jarva.arsadditions.common.util.LangUtil;
import com.github.jarva.arsadditions.setup.registry.AddonDataComponentRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Triple;

public class AdvancedDominionWand
extends Item {
    public AdvancedDominionWand() {
        super(AddonItemRegistry.defaultItemProperties().stacksTo(1));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return super.interactLivingEntity(stack, player, interactionTarget, usedHand);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (player.isShiftKeyDown()) {
            AdvancedDominionData data = AdvancedDominionData.fromItemStack(stack);
            if (data.pos().isEmpty() && data.entityId().isEmpty()) {
                stack.set(AddonDataComponentRegistry.ADVANCED_DOMINION_DATA, (Object)AdvancedDominionData.fromEntity((ResourceKey<Level>)serverLevel.dimension(), (Entity)interactionTarget));
                PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"ars_nouveau.dominion_wand.stored_entity"));
                return InteractionResult.SUCCESS;
            }
            if (data.level().isPresent()) {
                IWandable wand;
                IWandable wandable = interactionTarget instanceof IWandable ? (wand = (IWandable)interactionTarget) : null;
                return this.attemptConnection(serverLevel.getServer(), data, player, (Triple<IWandable, LivingEntity, BlockPos>)Triple.of((Object)wandable, (Object)interactionTarget, null));
            }
        }
        return super.interactLivingEntity(stack, player, interactionTarget, usedHand);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        if (!pPlayer.isShiftKeyDown()) {
            AdvancedDominionData data = AdvancedDominionData.fromItemStack(stack).toggleMode();
            data.write(stack);
            PortUtil.sendMessageNoSpam((Entity)pPlayer, (Component)Component.translatable((String)"chat.ars_additions.advanced_dominion_wand.mode", (Object[])new Object[]{data.mode().getTranslatable()}));
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public InteractionResult useOn(UseOnContext context) {
        ServerLevel serverLevel;
        block7: {
            block6: {
                Level level = context.getLevel();
                if (!(level instanceof ServerLevel)) break block6;
                serverLevel = (ServerLevel)level;
                if (context.getPlayer() != null) break block7;
            }
            return super.useOn(context);
        }
        Player player = context.getPlayer();
        if (player.isShiftKeyDown()) {
            BlockPos pos = context.getClickedPos();
            ItemStack stack = context.getItemInHand();
            BlockEntity be = serverLevel.getBlockEntity(pos);
            AdvancedDominionData data = AdvancedDominionData.fromItemStack(stack);
            if (data.pos().isEmpty() && data.entityId().isEmpty()) {
                stack.set(AddonDataComponentRegistry.ADVANCED_DOMINION_DATA, (Object)AdvancedDominionData.fromPos(pos, (ResourceKey<Level>)serverLevel.dimension()));
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.dominion_wand.position_set"));
                return InteractionResult.SUCCESS;
            }
            if (data.level().isPresent()) {
                IWandable wand;
                IWandable wandable = be instanceof IWandable ? (wand = (IWandable)be) : null;
                return this.attemptConnection(serverLevel.getServer(), data, player, (Triple<IWandable, LivingEntity, BlockPos>)Triple.of((Object)wandable, null, (Object)pos));
            }
        }
        return super.useOn(context);
    }

    private InteractionResult attemptConnection(MinecraftServer server, AdvancedDominionData data, Player player, Triple<IWandable, LivingEntity, BlockPos> target) {
        ServerLevel origin = server.getLevel(data.level().get());
        IWandable targetWandable = (IWandable)target.getLeft();
        LivingEntity targetLivingEntity = (LivingEntity)target.getMiddle();
        BlockPos targetBlock = (BlockPos)target.getRight();
        Triple<IWandable, LivingEntity, BlockPos> stored = this.getWandable(origin, data.pos(), data.entityId());
        IWandable storedWandable = (IWandable)stored.getLeft();
        LivingEntity storedLivingEntity = (LivingEntity)stored.getMiddle();
        BlockPos storedBlock = (BlockPos)stored.getRight();
        switch (data.mode()) {
            case LOCK_FIRST: {
                if (storedWandable != null) {
                    targetWandable.onFinishedConnectionLast(storedBlock, null, storedLivingEntity, player);
                }
                if (targetWandable == null) break;
                storedWandable.onFinishedConnectionFirst(targetBlock, null, targetLivingEntity, player);
                break;
            }
            case LOCK_SECOND: {
                if (storedWandable != null) {
                    targetWandable.onFinishedConnectionFirst(storedBlock, null, storedLivingEntity, player);
                }
                if (targetWandable == null) break;
                storedWandable.onFinishedConnectionLast(targetBlock, null, targetLivingEntity, player);
                break;
            }
            default: {
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.FAIL;
    }

    private Triple<IWandable, LivingEntity, BlockPos> getWandable(ServerLevel level, Optional<BlockPos> pos, Optional<Integer> entityId) {
        Entity wandable2;
        if (pos.isPresent()) {
            BlockEntity be = level.getBlockEntity(pos.get());
            if (be instanceof IWandable) {
                IWandable wandable2 = (IWandable)be;
                return Triple.of((Object)wandable2, null, (Object)pos.get());
            }
            return Triple.of(null, null, (Object)pos.get());
        }
        if (entityId.isPresent() && (wandable2 = level.getEntity(entityId.get().intValue())) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)wandable2;
            if (living instanceof IWandable) {
                wandable2 = (IWandable)living;
                return Triple.of((Object)wandable2, (Object)living, null);
            }
            return Triple.of(null, (Object)living, null);
        }
        return Triple.of(null, null, null);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (!stack.has(AddonDataComponentRegistry.ADVANCED_DOMINION_DATA)) {
            return;
        }
        AdvancedDominionData data = (AdvancedDominionData)stack.get(AddonDataComponentRegistry.ADVANCED_DOMINION_DATA);
        tooltip.add((Component)Component.translatable((String)"tooltip.ars_additions.advanced_dominion_wand.mode", (Object[])new Object[]{data.mode().getTranslatable()}));
        if (data.pos().isPresent() && data.level().isPresent()) {
            BlockPos pos = data.pos().get();
            tooltip.add((Component)Component.translatable((String)"tooltip.ars_additions.warp_index.bound", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ(), data.level().get().location().toString()}));
        } else {
            tooltip.add((Component)Component.translatable((String)"chat.ars_additions.warp_index.unbound", (Object[])new Object[]{Component.keybind((String)"key.sneak"), Component.keybind((String)"key.use"), LangUtil.container()}));
        }
    }
}

