/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.block.tile;

import com.github.jarva.arsadditions.common.util.SourceSpawner;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SourceSpawnerTile
extends BlockEntity
implements ITickable,
ITooltipProvider {
    public final SourceSpawner spawner = new SourceSpawner(this);

    public SourceSpawnerTile(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)AddonBlockRegistry.SOURCE_SPAWNER_TILE.get(), pos, blockState);
    }

    public void getTooltip(List<Component> tooltip) {
        if (this.spawner.disabled) {
            tooltip.add((Component)Component.translatable((String)"tooltip.ars_additions.source_spawner.disabled").withStyle(ChatFormatting.GOLD));
        }
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.spawner.load(this.level, this.worldPosition, tag);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.spawner.save(tag);
    }

    public int getDelaySignal() {
        double percentage = (double)this.spawner.spawnDelay / (double)this.spawner.maxSpawnDelay;
        return (int)Math.ceil(percentage * 15.0);
    }

    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundtag = this.saveWithoutMetadata(provider);
        compoundtag.remove("SpawnPotentials");
        return compoundtag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        this.handleUpdateTag(pkt.getTag() == null ? new CompoundTag() : pkt.getTag(), provider);
    }

    public void tick(Level level, BlockState state, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawner.serverTick(serverLevel, pos);
        } else {
            this.spawner.clientTick(level, pos);
        }
    }

    public BaseSpawner getSpawner() {
        return this.spawner;
    }
}

