/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.block.tile;

import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.SconceTile;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MagelightLanternTile
extends SconceTile {
    public MagelightLanternTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)AddonBlockRegistry.MAGELIGHT_LANTERN_TILE.get(), pos, state);
    }

    public void tick() {
        if (!this.level.isClientSide || !this.lit) {
            return;
        }
        BlockPos pos = this.getBlockPos();
        BlockState state = this.getLevel().getBlockState(pos);
        if (!state.hasProperty((Property)LanternBlock.HANGING)) {
            return;
        }
        boolean hanging = (Boolean)state.getValue((Property)LanternBlock.HANGING);
        double centerX = (double)pos.getX() + 0.5;
        double centerZ = (double)pos.getZ() + 0.5;
        double yOffset = hanging ? 0.2 : 0.1;
        ParticleColor nextColor = this.color.transition((int)(this.level.getGameTime() * 10L));
        for (int i = 0; i < 10; ++i) {
            this.level.addParticle(GlowParticleData.createData((ParticleColor)nextColor), centerX, (double)pos.getY() + yOffset + ParticleUtil.inRange((double)-0.0, (double)0.1), centerZ, 0.0, ParticleUtil.inRange((double)0.0, (double)0.01f), 0.0);
        }
    }
}

