/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class WeightedCollection<T extends Number>
implements Collection<T> {
    private ArrayList<Weighted<T>> list;
    private int minWeight;
    private int maxWeight;
    private int totalWeight;

    private void reset() {
        this.minWeight = Integer.MAX_VALUE;
        this.maxWeight = Integer.MIN_VALUE;
        this.totalWeight = 0;
    }

    public WeightedCollection() {
        this.list = new ArrayList();
        this.reset();
    }

    public WeightedCollection(int capacity) {
        this.list = new ArrayList(capacity);
        this.reset();
    }

    public WeightedCollection(Collection<T> c) {
        this(c.size());
        this.addAll(c);
    }

    public int getMinWeight() {
        return this.minWeight;
    }

    public int getMaxWeight() {
        return this.maxWeight;
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public double getWeightedSum() {
        return this.list.stream().map(w -> ((Number)w.value).doubleValue() * (double)w.weight).reduce(0.0, (w1, w2) -> w1 + w2);
    }

    public boolean add(T value, int weight) {
        this.totalWeight += weight;
        if (weight > this.maxWeight) {
            this.maxWeight = weight;
        }
        if (weight < this.minWeight) {
            this.minWeight = weight;
        }
        return this.list.add(new Weighted<T>(value, weight));
    }

    @Override
    public boolean add(T value) {
        return this.add(value, 1);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean added = false;
        for (Number e : c) {
            added = this.add((T)e) || added;
        }
        return added;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.reset();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.stream().map(Weighted::value).iterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("This collection does not support removal ('remove')");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("This collection does not support removal ('removeAll')");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("This collection does not support removal ('retainAll')");
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <V> V[] toArray(V[] arg0) {
        return this.list.toArray(arg0);
    }

    record Weighted<V extends Number>(V value, int weight) {
    }
}

