/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.utils;

import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.api.types.tera.TeraType;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.gitlab.srcmc.rctapi.ModCommon;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleEffects;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import org.apache.commons.lang3.function.TriFunction;

public final class TypeChart {
    private static final Map<ElementalType, Map<ElementalType, Double>> CHART = new HashMap<ElementalType, Map<ElementalType, Double>>();
    private static final Map<ElementalType, Double> EMPTY_MAP = Map.of();
    private static final Map<String, Move> MOVE_MAP = new HashMap<String, Move>();
    private static final double SUPER_EFFECTIVE = 2.0;
    private static final double NOT_VERY_EFFECTIVE = 0.5;
    private static final double IMMUNE = 0.0;
    private static final String STELLAR_TYPE_ID = "stellar";
    private static final ElementalType[] HIDDENPOWER_TYPES = new ElementalType[]{ElementalTypes.FIGHTING, ElementalTypes.FLYING, ElementalTypes.POISON, ElementalTypes.GROUND, ElementalTypes.ROCK, ElementalTypes.BUG, ElementalTypes.GHOST, ElementalTypes.STEEL, ElementalTypes.FIRE, ElementalTypes.WATER, ElementalTypes.GRASS, ElementalTypes.ELECTRIC, ElementalTypes.PSYCHIC, ElementalTypes.ICE, ElementalTypes.DRAGON, ElementalTypes.DARK};
    public static final int NORMAL = 2;
    public static final int FIGHTING = 4;
    public static final int FLYING = 8;
    public static final int POISON = 16;
    public static final int GROUND = 32;
    public static final int ROCK = 64;
    public static final int BUG = 128;
    public static final int GHOST = 256;
    public static final int STEEL = 512;
    public static final int FIRE = 1024;
    public static final int WATER = 2048;
    public static final int GRASS = 4096;
    public static final int ELECTRIC = 8192;
    public static final int PSYCHIC = 16384;
    public static final int ICE = 32768;
    public static final int DRAGON = 65536;
    public static final int DARK = 131072;
    public static final int FAIRY = 262144;
    private static final Map<ElementalType, Integer> TYPE_MASKS = Map.ofEntries(Map.entry(ElementalTypes.NORMAL, 2), Map.entry(ElementalTypes.FIGHTING, 4), Map.entry(ElementalTypes.FLYING, 8), Map.entry(ElementalTypes.POISON, 16), Map.entry(ElementalTypes.GROUND, 32), Map.entry(ElementalTypes.ROCK, 64), Map.entry(ElementalTypes.BUG, 128), Map.entry(ElementalTypes.GHOST, 256), Map.entry(ElementalTypes.STEEL, 512), Map.entry(ElementalTypes.FIRE, 1024), Map.entry(ElementalTypes.WATER, 2048), Map.entry(ElementalTypes.GRASS, 4096), Map.entry(ElementalTypes.ELECTRIC, 8192), Map.entry(ElementalTypes.PSYCHIC, 16384), Map.entry(ElementalTypes.ICE, 32768), Map.entry(ElementalTypes.DRAGON, 65536), Map.entry(ElementalTypes.DARK, 131072), Map.entry(ElementalTypes.FAIRY, 262144));

    @Deprecated(since="0.13.5")
    public static double getEffectiveness(InBattleMove move, BattlePokemon defender) {
        return TypeChart.getEffectiveness(TypeChart.getMove(move).getType(), defender);
    }

    public static double getEffectiveness(BattlePokemon attacker, BattlePokemon defender) {
        return TypeChart.getEffectiveness(attacker, defender, 1.0, (e1, e2) -> e1 * e2);
    }

    private static double getEffectiveness(BattlePokemon attacker, BattlePokemon defender, double identity, BinaryOperator<Double> acc) {
        return TypeChart.getEffectiveness(attacker, defender, identity, acc, (TriFunction<Integer, Integer, Double, Double>)((TriFunction)(n1, n2, e) -> e));
    }

    private static double getEffectiveness(BattlePokemon attacker, BattlePokemon defender, double identity, BinaryOperator<Double> acc, TriFunction<Integer, Integer, Double, Double> fin) {
        List<ElementalType> attackerTypes = TypeChart.getEffectiveTypes(attacker, true);
        List<ElementalType> defenderTypes = TypeChart.getEffectiveTypes(defender, false);
        double[] result = new double[]{identity};
        for (ElementalType at : attackerTypes) {
            for (ElementalType dt : defenderTypes) {
                result[0] = (Double)acc.apply(result[0], TypeChart.getEffectiveness(at, dt, defender));
            }
        }
        return (Double)fin.apply((Object)attackerTypes.size(), (Object)defenderTypes.size(), (Object)result[0]);
    }

    public static double getEffectiveness(ElementalType attackerType, BattlePokemon defender) {
        String defenderAbilityId = BattleStates.getTransformationOrEffected(defender).getAbility().getName();
        List<ElementalType> defenderTypes = TypeChart.getEffectiveTypes(defender, false);
        double e = 1.0;
        for (ElementalType dt : defenderTypes) {
            e *= TypeChart.getEffectiveness(attackerType, dt, defender);
        }
        if (e < 2.0 && defenderAbilityId.equals("wonderguard")) {
            e = 0.0;
        }
        return e;
    }

    public static double getAverageEffectiveness(BattlePokemon attacker, BattlePokemon defender) {
        return TypeChart.getEffectiveness(attacker, defender, 0.0, (e1, e2) -> e1 + e2, (TriFunction<Integer, Integer, Double, Double>)((TriFunction)(n1, n2, e) -> n1 > 0 && n2 > 0 ? e / (double)(n1 * n2) : 0.0));
    }

    @Deprecated(since="0.11.1")
    public static double getEffectiveness(ElementalType attackerType, ElementalType defenderPrimaryType, ElementalType defenderSecondaryType, Ability defenderAbility) {
        return 1.0;
    }

    private static double getEffectiveness(ElementalType attackerType, ElementalType defenderType, BattlePokemon defender) {
        String defenderAbilityId = BattleStates.getTransformationOrEffected(defender).getAbility().getName();
        if (attackerType.equals(ElementalTypes.WATER)) {
            if (defenderAbilityId.equals("stormdrain") || defenderAbilityId.equals("waterabsorb") || defenderAbilityId.equals("dryskin")) {
                return 0.0;
            }
        } else if (attackerType.equals(ElementalTypes.ELECTRIC)) {
            if (defenderAbilityId.equals("voltabsorb") || defenderAbilityId.equals("lightningrod") || defenderAbilityId.equals("motordrive")) {
                return 0.0;
            }
        } else if (attackerType.equals(ElementalTypes.GROUND)) {
            if (defenderAbilityId.equals("eartheater")) {
                return 0.0;
            }
            if (BattleEffects.Pokemon.State.raised(defender)) {
                return 0.0;
            }
            if (defenderType.equals(ElementalTypes.FLYING)) {
                return 1.0;
            }
        } else if (attackerType.equals(ElementalTypes.FIRE) ? defenderAbilityId.equals("wellbakedbody") || defenderAbilityId.equals("flashfire") : attackerType.equals(ElementalTypes.GRASS) && defenderAbilityId.equals("sapsipper")) {
            return 0.0;
        }
        return CHART.getOrDefault(defenderType, EMPTY_MAP).getOrDefault(attackerType, 1.0);
    }

    private static List<ElementalType> getEffectiveTypes(BattlePokemon p, boolean offensive) {
        Pokemon ep = BattleStates.getTransformationOrEffected(p);
        if (!offensive && BattleStates.get(p.actor.battle).getPokemonState(p).has(BattleEffects.Custom.TERA)) {
            TeraType teraType = ep.getTeraType();
            if (teraType == null) {
                ModCommon.LOG.warn(String.format("Missing tera type for %s", ep.getDisplayName(false).getString()));
            } else {
                String teraId = teraType.showdownId();
                if (!STELLAR_TYPE_ID.equals(teraId)) {
                    ElementalType eleType = ElementalTypes.get((String)teraId);
                    if (eleType == null) {
                        ModCommon.LOG.warn(String.format("Unknown tera type for %s: %s", ep.getDisplayName(false).getString(), teraId));
                    } else {
                        return List.of(eleType);
                    }
                }
            }
        }
        if (ep.getSecondaryType() != null) {
            return List.of(ep.getPrimaryType(), ep.getSecondaryType());
        }
        return List.of(ep.getPrimaryType());
    }

    public static Move getMove(InBattleMove move) {
        return MOVE_MAP.computeIfAbsent(move.id, key -> {
            MoveTemplate m = Moves.getByName((String)key);
            if (m == null) {
                if (!key.equals("recharge")) {
                    ModCommon.LOG.warn("Failed to create move template for '" + key + "'");
                }
                m = Moves.getExceptional();
            }
            return m.create();
        });
    }

    public static ElementalType getHiddenPowerType(BattlePokemon pkmn) {
        IVs ivs = pkmn.getEffectedPokemon().getIvs();
        return HIDDENPOWER_TYPES[((ivs.get((Stat)Stats.HP) & 1) + (ivs.get((Stat)Stats.ATTACK) & 1) * 2 + (ivs.get((Stat)Stats.DEFENCE) & 1) * 4 + (ivs.get((Stat)Stats.SPEED) & 1) * 8 + (ivs.get((Stat)Stats.SPECIAL_ATTACK) & 1) * 16 + (ivs.get((Stat)Stats.SPECIAL_DEFENCE) & 1) * 32) * 15 / 63];
    }

    public static boolean is(BattlePokemon pkmn, int type) {
        Pokemon ep = BattleStates.getTransformationOrEffected(pkmn);
        int p = ep.getPrimaryType() != null ? TYPE_MASKS.getOrDefault(ep.getPrimaryType(), 0) : 0;
        int s = ep.getSecondaryType() != null ? TYPE_MASKS.getOrDefault(ep.getSecondaryType(), 0) : p;
        return (type & (p | s)) != 0;
    }

    static {
        ElementalType NORMAL = ElementalTypes.NORMAL;
        ElementalType FIGHTING = ElementalTypes.FIGHTING;
        ElementalType FLYING = ElementalTypes.FLYING;
        ElementalType POISON = ElementalTypes.POISON;
        ElementalType GROUND = ElementalTypes.GROUND;
        ElementalType ROCK = ElementalTypes.ROCK;
        ElementalType BUG = ElementalTypes.BUG;
        ElementalType GHOST = ElementalTypes.GHOST;
        ElementalType STEEL = ElementalTypes.STEEL;
        ElementalType FIRE = ElementalTypes.FIRE;
        ElementalType WATER = ElementalTypes.WATER;
        ElementalType GRASS = ElementalTypes.GRASS;
        ElementalType ELECTRIC = ElementalTypes.ELECTRIC;
        ElementalType PSYCHIC = ElementalTypes.PSYCHIC;
        ElementalType ICE = ElementalTypes.ICE;
        ElementalType DRAGON = ElementalTypes.DRAGON;
        ElementalType DARK = ElementalTypes.DARK;
        ElementalType FAIRY = ElementalTypes.FAIRY;
        CHART.put(NORMAL, Map.of(FIGHTING, 2.0, GHOST, 0.0));
        CHART.put(FIGHTING, Map.of(FLYING, 2.0, ROCK, 0.5, BUG, 0.5, PSYCHIC, 2.0, DARK, 0.5, FAIRY, 2.0));
        CHART.put(FLYING, Map.of(FIGHTING, 0.5, GROUND, 0.0, ROCK, 2.0, BUG, 0.5, GRASS, 0.5, ELECTRIC, 2.0, ICE, 2.0));
        CHART.put(POISON, Map.of(FIGHTING, 0.5, POISON, 0.5, GROUND, 2.0, BUG, 0.5, GRASS, 0.5, PSYCHIC, 2.0, FAIRY, 0.5));
        CHART.put(GROUND, Map.of(POISON, 0.5, ROCK, 0.5, WATER, 2.0, GRASS, 2.0, ELECTRIC, 0.0, ICE, 2.0));
        CHART.put(ROCK, Map.of(NORMAL, 0.5, FIGHTING, 2.0, FLYING, 0.5, POISON, 0.5, GROUND, 2.0, STEEL, 2.0, FIRE, 0.5, WATER, 2.0, GRASS, 2.0));
        CHART.put(BUG, Map.of(FIGHTING, 0.5, FLYING, 2.0, GROUND, 0.5, ROCK, 2.0, FIRE, 2.0, GRASS, 0.5));
        CHART.put(GHOST, Map.of(NORMAL, 0.0, FIGHTING, 0.0, POISON, 0.5, BUG, 0.5, GHOST, 2.0, DARK, 2.0));
        HashMap<ElementalType, Double> steelMap = new HashMap<ElementalType, Double>(Map.of(NORMAL, 0.5, FIGHTING, 2.0, FLYING, 0.5, POISON, 0.0, GROUND, 2.0, ROCK, 0.5, BUG, 0.5, STEEL, 0.5, FIRE, 2.0, GRASS, 0.5));
        steelMap.put(PSYCHIC, 0.5);
        steelMap.put(ICE, 0.5);
        steelMap.put(DRAGON, 0.5);
        steelMap.put(FAIRY, 0.5);
        CHART.put(STEEL, steelMap);
        CHART.put(FIRE, Map.of(GROUND, 2.0, ROCK, 2.0, BUG, 0.5, STEEL, 0.5, FIRE, 0.5, WATER, 2.0, GRASS, 0.5, ICE, 0.5, FAIRY, 0.5));
        CHART.put(WATER, Map.of(STEEL, 0.5, FIRE, 0.5, WATER, 0.5, GRASS, 2.0, ELECTRIC, 2.0, ICE, 0.5));
        CHART.put(GRASS, Map.of(FLYING, 2.0, POISON, 2.0, GROUND, 0.5, BUG, 2.0, FIRE, 2.0, WATER, 0.5, GRASS, 0.5, ELECTRIC, 0.5, ICE, 2.0));
        CHART.put(ELECTRIC, Map.of(FLYING, 0.5, GROUND, 2.0, STEEL, 0.5, ELECTRIC, 0.5));
        CHART.put(PSYCHIC, Map.of(FIGHTING, 0.5, BUG, 2.0, GHOST, 2.0, PSYCHIC, 0.5, DARK, 2.0));
        CHART.put(ICE, Map.of(FIGHTING, 2.0, ROCK, 2.0, STEEL, 2.0, FIRE, 2.0, ICE, 0.5));
        CHART.put(DRAGON, Map.of(FIRE, 0.5, WATER, 0.5, GRASS, 0.5, ELECTRIC, 0.5, ICE, 2.0, DRAGON, 2.0, FAIRY, 2.0));
        CHART.put(DARK, Map.of(FIGHTING, 2.0, BUG, 2.0, GHOST, 0.5, PSYCHIC, 0.0, DARK, 0.5, FAIRY, 2.0));
        CHART.put(FAIRY, Map.of(FIGHTING, 0.5, POISON, 2.0, BUG, 0.5, STEEL, 2.0, DRAGON, 0.0, DARK, 0.5));
    }
}

