/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.utils;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.berry.BerryItem;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleEffects;
import com.gitlab.srcmc.rctapi.api.ai.utils.BattleStates;
import com.gitlab.srcmc.rctapi.api.ai.utils.TypeChart;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.stream.Streams;

public enum MoveType {
    DAMAGE,
    STATUS,
    HEAL,
    CURE,
    BUFF,
    MALUS;

    private static final Map<MoveType, Evaluator> MOVE_TYPE_EVALUATORS;
    private static final Map<String, Evaluator> MOVE_EVALUATORS;
    private static final Map<String, Handler> MOVE_HANDLERS;
    private static final Map<String, MoveType> MOVE_TYPES;

    public static MoveType of(InBattleMove move) {
        return MoveType.of(TypeChart.getMove(move));
    }

    public static MoveType of(Move move) {
        MoveType mt = MOVE_TYPES.get(move.getName());
        return mt == null ? (DamageCategories.INSTANCE.getSTATUS().getName().equals(move.getDamageCategory().getName()) ? STATUS : DAMAGE) : mt;
    }

    public static MoveType of(String moveId) {
        MoveType mt = MOVE_TYPES.get(moveId);
        return mt == null ? STATUS : mt;
    }

    public static BattleEffects.Custom toEffect(MoveType t) {
        switch (t.ordinal()) {
            case 0: {
                return BattleEffects.Custom.USED_DAMAGE;
            }
            case 2: {
                return BattleEffects.Custom.USED_HEAL;
            }
            case 3: {
                return BattleEffects.Custom.USED_CURE;
            }
            case 4: {
                return BattleEffects.Custom.USED_BUFF;
            }
            case 5: {
                return BattleEffects.Custom.USED_MALUS;
            }
        }
        return BattleEffects.Custom.USED_STATUS;
    }

    public static double eval(BattlePokemon from, BattlePokemon to, String moveId) {
        return MOVE_EVALUATORS.getOrDefault(moveId, (f, t, m) -> 1.0).eval(from, to, null);
    }

    public static double eval(BattlePokemon from, BattlePokemon to, MoveType moveType) {
        return MOVE_TYPE_EVALUATORS.getOrDefault((Object)moveType, (f, t, m) -> 1.0).eval(from, to, null);
    }

    public static void handle(String moveId, BattlePokemon from, BattlePokemon to, boolean hasHit) {
        if (hasHit) {
            MOVE_HANDLERS.getOrDefault(moveId, (f, t) -> {}).handle(from, to);
        }
        MoveType.registerUsedMoveType(moveId, from);
    }

    private static void registerUsedMoveType(String moveId, BattlePokemon pkmn) {
        BattleEffects.Custom ef;
        BattleStates.PokemonState ps = BattleStates.get(pkmn.getActor().getBattle()).getPokemonState(pkmn);
        if (!ps.has(ef = MoveType.toEffect(MoveType.of(moveId)))) {
            ps.add(ef);
        }
        for (MoveType mt : MoveType.values()) {
            BattleEffects.Custom oef = MoveType.toEffect(mt);
            if (ef == oef) continue;
            ps.expire(oef);
        }
    }

    private static boolean ability(BattlePokemon p, String ... names) {
        String a = BattleStates.getTransformationOrEffected(p).getAbility().getName();
        for (String n : names) {
            if (!a.equals(n)) continue;
            return true;
        }
        return false;
    }

    private static List<BattlePokemon> alive(BattleActor a) {
        return Stream.of(a.getSide().getActors()).flatMap(b -> b.getPokemonList().stream()).filter(p -> p.getHealth() > 0).toList();
    }

    static {
        MOVE_TYPE_EVALUATORS = Map.ofEntries(Map.entry(BUFF, (from, to, move) -> 1.0), Map.entry(CURE, (from, to, move) -> 1.0), Map.entry(DAMAGE, (from, to, move) -> 1.0), Map.entry(HEAL, (from, to, move) -> 1.0), Map.entry(MALUS, (from, to, move) -> MoveType.ability(to, "clearbody") ? 0.0 : 1.0 / Math.max(1.0, from.getFacedOpponents().stream().map(opp -> TypeChart.getEffectiveness(opp, from)).max(Double::compare).orElse(0.0))), Map.entry(STATUS, (from, to, move) -> 1.0 / Math.max(1.0, from.getFacedOpponents().stream().map(opp -> TypeChart.getEffectiveness(opp, from)).max(Double::compare).orElse(0.0))));
        MOVE_EVALUATORS = Map.ofEntries(Map.entry("attract", (from, to, move) -> BattleEffects.Pokemon.Volatile.attract(to) ? 0.0 : 1.0), Map.entry("confuseray", (from, to, move) -> BattleEffects.Pokemon.Volatile.confusion(to) || !BattleEffects.Pokemon.State.raised(to) && BattleEffects.Field.Terrain.mistyterrain(to) ? 0.0 : 1.0), Map.entry("flatter", (from, to, move) -> BattleEffects.Pokemon.Volatile.confusion(to) || !BattleEffects.Pokemon.State.raised(to) && BattleEffects.Field.Terrain.mistyterrain(to) ? 0.0 : 1.0), Map.entry("supersonic", (from, to, move) -> BattleEffects.Pokemon.Volatile.confusion(to) || !BattleEffects.Pokemon.State.raised(to) && BattleEffects.Field.Terrain.mistyterrain(to) ? 0.0 : 1.0), Map.entry("swagger", (from, to, move) -> BattleEffects.Pokemon.Volatile.confusion(to) || !BattleEffects.Pokemon.State.raised(to) && BattleEffects.Field.Terrain.mistyterrain(to) ? 0.0 : 1.0), Map.entry("sweetkiss", (from, to, move) -> BattleEffects.Pokemon.Volatile.confusion(to) || !BattleEffects.Pokemon.State.raised(to) && BattleEffects.Field.Terrain.mistyterrain(to) ? 0.0 : 1.0), Map.entry("teeterdance", (from, to, move) -> BattleEffects.Pokemon.Volatile.confusion(to) || !BattleEffects.Pokemon.State.raised(to) && BattleEffects.Field.Terrain.mistyterrain(to) ? 0.0 : 1.0), Map.entry("curse", (from, to, move) -> TypeChart.is(from, 256) && BattleEffects.Pokemon.Volatile.cursed(to) ? 0.0 : 1.0), Map.entry("leechseed", (from, to, move) -> BattleEffects.Pokemon.Volatile.leech(to) ? 0.0 : 1.0), Map.entry("ingrain", (from, to, move) -> BattleEffects.Pokemon.Volatile.ingrain(from) ? 0.0 : 1.0), Map.entry("aquaring", (from, to, move) -> BattleEffects.Pokemon.Volatile.aquaring(from) ? 0.0 : 1.0), Map.entry("telekinesis", (from, to, move) -> BattleEffects.Pokemon.State.raised(to) ? 0.0 : 1.0), Map.entry("magnetrise", (from, to, move) -> BattleEffects.Pokemon.State.raised(from) ? 0.0 : 1.0), Map.entry("flowershield", (from, to, move) -> from.getActor().getSide().getActivePokemon().stream().filter(p -> p.hasPokemon()).map(p -> p.getBattlePokemon()).anyMatch(p -> TypeChart.is(p, 4096)) ? 1.0 : 0.0), Map.entry("auroraveil", (from, to, move) -> !BattleEffects.Side.Screen.auroraveil(from) && (BattleEffects.Field.Weather.snow(from) || BattleEffects.Field.Weather.hail(from)) ? 1.0 : 0.0), Map.entry("reflect", (from, to, move) -> BattleEffects.Side.Screen.reflect(from) || BattleEffects.Side.Screen.auroraveil(from) ? 0.0 : 1.0), Map.entry("lightscreen", (from, to, move) -> BattleEffects.Side.Screen.lightscreen(from) || BattleEffects.Side.Screen.auroraveil(from) ? 0.0 : 1.0), Map.entry("sunnyday", (from, to, move) -> BattleEffects.Field.Weather.harshsunlight(from) || BattleEffects.Field.Weather.extremelyharshsunlight(from) || BattleEffects.Field.Weather.heavyrain(from) || BattleEffects.Field.Weather.strongwinds(from) ? 0.0 : 1.0), Map.entry("raindance", (from, to, move) -> BattleEffects.Field.Weather.rain(from) || BattleEffects.Field.Weather.extremelyharshsunlight(from) || BattleEffects.Field.Weather.heavyrain(from) || BattleEffects.Field.Weather.strongwinds(from) ? 0.0 : 1.0), Map.entry("sandstorm", (from, to, move) -> BattleEffects.Field.Weather.sandstorm(from) || BattleEffects.Field.Weather.extremelyharshsunlight(from) || BattleEffects.Field.Weather.heavyrain(from) || BattleEffects.Field.Weather.strongwinds(from) ? 0.0 : 1.0), Map.entry("hail", (from, to, move) -> BattleEffects.Field.Weather.hail(from) || BattleEffects.Field.Weather.snow(from) || BattleEffects.Field.Weather.extremelyharshsunlight(from) || BattleEffects.Field.Weather.heavyrain(from) || BattleEffects.Field.Weather.strongwinds(from) ? 0.0 : 1.0), Map.entry("electricterrain", (from, to, move) -> BattleEffects.Field.Terrain.electricterrain(from) ? 0.0 : 1.0), Map.entry("grassyterrain", (from, to, move) -> BattleEffects.Field.Terrain.grassyterrain(from) ? 0.0 : 1.0), Map.entry("mistyterrain", (from, to, move) -> BattleEffects.Field.Terrain.mistyterrain(from) ? 0.0 : 1.0), Map.entry("psychicterrain", (from, to, move) -> BattleEffects.Field.Terrain.psychicterrain(from) ? 0.0 : 1.0), Map.entry("wish", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.WISH) ? 0.0 : 1.0), Map.entry("meanlook", (from, to, move) -> BattleEffects.Pokemon.State.trapped(to) ? 0.0 : 1.0), Map.entry("spiderweb", (from, to, move) -> BattleEffects.Pokemon.State.trapped(to) ? 0.0 : 1.0), Map.entry("block", (from, to, move) -> BattleEffects.Pokemon.State.trapped(to) ? 0.0 : 1.0), Map.entry("fakeout", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).age(BattleEffects.Custom.TURN) > 1 ? 0.0 : 1.75), Map.entry("firstimpression", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).age(BattleEffects.Custom.TURN) > 1 ? 0.0 : 1.75), Map.entry("tailwind", (from, to, move) -> BattleEffects.Side.Tailwind.tailwind(from) ? 0.0 : 1.0), Map.entry("gravity", (from, to, move) -> BattleEffects.Field.Gravity.gravity(from) ? 0.0 : 1.0), Map.entry("trickroom", (from, to, move) -> BattleEffects.Field.Room.trickroom(from) ? 0.0 : 1.0), Map.entry("spikes", (from, to, move) -> (double)(3 - BattleEffects.Side.Hazard.spikes(to)) / 3.0), Map.entry("stealthrock", (from, to, move) -> BattleEffects.Side.Hazard.stealthrock(to) > 0 ? 0.0 : 1.0), Map.entry("toxicspikes", (from, to, move) -> (double)(2 - BattleEffects.Side.Hazard.toxicspikes(to)) / 2.0), Map.entry("stickyweb", (from, to, move) -> BattleEffects.Side.Hazard.stickyweb(to) > 0 ? 0.0 : 1.0), Map.entry("protect", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.PROTECT) ? 0.15 : 1.0), Map.entry("detect", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.PROTECT) ? 0.15 : 1.0), Map.entry("endure", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.PROTECT) ? 0.15 : 1.0), Map.entry("wideguard", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.PROTECT) ? 0.15 : 1.0), Map.entry("quickguard", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.PROTECT) ? 0.15 : 1.0), Map.entry("spikyshield", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.PROTECT) ? 0.15 : 1.0), Map.entry("kingsshield", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.PROTECT) ? 0.15 : 1.0), Map.entry("banefulbunker", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.PROTECT) ? 0.15 : 1.0), Map.entry("taunt", (from, to, move) -> BattleEffects.Pokemon.Volatile.taunt(to) ? 0.0 : 1.0), Map.entry("glare", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || TypeChart.is(to, 8192) || MoveType.ability(to, "limber", "comatose", "purifyingsalt") ? 0.0 : 1.0), Map.entry("stunspore", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || TypeChart.is(to, 12288) || MoveType.ability(to, "limber", "comatose", "purifyingsalt") ? 0.0 : 1.0), Map.entry("thunderwave", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || TypeChart.is(to, 8224) || MoveType.ability(to, "limber", "comatose", "purifyingsalt") ? 0.0 : 1.0), Map.entry("poisongas", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || TypeChart.is(to, 528) && !MoveType.ability(from, "corrosion") || MoveType.ability(to, "immunity", "comatose", "purifyingsalt", "pastelveil") ? 0.0 : 1.0), Map.entry("poisonpowder", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || TypeChart.is(to, 4624) && !MoveType.ability(from, "corrosion") || MoveType.ability(to, "immunity", "comatose", "purifyingsalt", "pastelveil") ? 0.0 : 1.0), Map.entry("toxicthread", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || TypeChart.is(to, 528) && !MoveType.ability(from, "corrosion") || MoveType.ability(to, "immunity", "comatose", "purifyingsalt", "pastelveil") ? 0.25 : 1.0), Map.entry("toxic", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || TypeChart.is(to, 528) && !MoveType.ability(from, "corrosion") || MoveType.ability(to, "immunity", "comatose", "purifyingsalt", "pastelveil") ? 0.0 : 1.0), Map.entry("willowisp", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || TypeChart.is(to, 1024) || MoveType.ability(to, "waterveil", "waterbubble", "comatose", "thermalexchange", "purifyingsalt") ? 0.0 : 1.0), Map.entry("darkvoid", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || MoveType.ability(to, "insomnia", "vitalspirit", "purifyingsalt", "comatose") ? 0.5 : 1.0), Map.entry("grasswhistle", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || MoveType.ability(to, "insomnia", "vitalspirit", "purifyingsalt", "comatose", "soundproof") ? 0.0 : 1.0), Map.entry("hypnosis", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || MoveType.ability(to, "insomnia", "vitalspirit", "purifyingsalt", "comatose") ? 0.0 : 1.0), Map.entry("lovelykiss", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || MoveType.ability(to, "insomnia", "vitalspirit", "purifyingsalt", "comatose") ? 0.0 : 1.0), Map.entry("sing", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || MoveType.ability(to, "insomnia", "vitalspirit", "purifyingsalt", "comatose", "soundproof") ? 0.0 : 1.0), Map.entry("sleeppowder", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || TypeChart.is(to, 4096) || MoveType.ability(to, "insomnia", "vitalspirit", "purifyingsalt", "comatose", "overcoat") ? 0.0 : 1.0), Map.entry("spore", (from, to, move) -> BattleEffects.Pokemon.Status.any(to) || TypeChart.is(to, 4096) || MoveType.ability(to, "insomnia", "vitalspirit", "purifyingsalt", "comatose", "overcoat") ? 0.0 : 1.0), Map.entry("yawn", (from, to, move) -> BattleEffects.Pokemon.Volatile.yawn(to) || BattleEffects.Pokemon.Status.any(to) || MoveType.ability(to, "insomnia", "vitalspirit", "purifyingsalt", "comatose") ? 0.0 : 1.0), Map.entry("sleeptalk", (from, to, move) -> BattleEffects.Pokemon.Status.slp(from) || MoveType.ability(from, "comatose") ? 1.0 : 0.0), Map.entry("snore", (from, to, move) -> BattleEffects.Pokemon.Status.slp(from) || MoveType.ability(from, "comatose") ? 1.0 : 0.0), Map.entry("explosion", (from, to, move) -> MoveType.ability(to, "damp") || MoveType.alive(from.actor).size() < 2 ? 0.0 : 1.0 - 0.5 * ((double)from.getHealth() / (double)from.getMaxHealth())), Map.entry("mistyexplosion", (from, to, move) -> MoveType.ability(to, "damp") || MoveType.alive(from.actor).size() < 2 ? 0.0 : 1.0 - 0.5 * ((double)from.getHealth() / (double)from.getMaxHealth())), Map.entry("selfdestruct", (from, to, move) -> MoveType.ability(to, "damp") || MoveType.alive(from.actor).size() < 2 ? 0.0 : 1.0 - 0.5 * ((double)from.getHealth() / (double)from.getMaxHealth())), Map.entry("lunardance", (from, to, move) -> MoveType.alive(from.actor).size() < 2 ? 0.0 : 1.0 - 0.5 * ((double)from.getHealth() / (double)from.getMaxHealth())), Map.entry("finalgambit", (from, to, move) -> MoveType.alive(from.actor).size() < 2 ? 0.0 : 1.0 - 0.5 * ((double)from.getHealth() / (double)from.getMaxHealth())), Map.entry("memento", (from, to, move) -> MoveType.alive(from.actor).size() < 2 ? 0.0 : 1.0 - 0.5 * ((double)from.getHealth() / (double)from.getMaxHealth())), Map.entry("healingwish", (from, to, move) -> MoveType.alive(from.actor).size() < 2 ? 0.0 : 1.0 - 0.5 * ((double)from.getHealth() / (double)from.getMaxHealth())), Map.entry("allyswitch", (from, to, move) -> from.getActor().getActivePokemon().size() > 1 ? 1.0 : 0.1), Map.entry("followme", (from, to, move) -> from.getActor().getActivePokemon().size() > 1 ? 1.0 : 0.1), Map.entry("ragepowder", (from, to, move) -> from.getActor().getActivePokemon().size() > 1 ? 1.0 : 0.1), Map.entry("helpinghand", (from, to, move) -> from.getActor().getActivePokemon().size() > 1 ? 1.0 : 0.1), Map.entry("afteryou", (from, to, move) -> from.getActor().getActivePokemon().size() > 1 ? 1.0 : 0.1), Map.entry("instruct", (from, to, move) -> from.getActor().getActivePokemon().size() > 1 ? 1.0 : 0.1), Map.entry("coaching", (from, to, move) -> from.getActor().getActivePokemon().size() > 1 ? 1.0 : 0.1), Map.entry("dreameater", (from, to, move) -> BattleEffects.Pokemon.Status.slp(to) || MoveType.ability(to, "comatose") ? 1.0 : 0.0), Map.entry("nightmare", (from, to, move) -> BattleEffects.Pokemon.Status.slp(to) || MoveType.ability(to, "comatose") ? 1.0 : 0.0), Map.entry("wakeupslap", (from, to, move) -> BattleEffects.Pokemon.Status.slp(to) || MoveType.ability(to, "comatose") ? 1.75 : 1.0), Map.entry("acrobatics", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.ITEM_ENDED) || from.getEffectedPokemon().heldItem().isEmpty() || from.getEffectedPokemon().heldItem().is((Item)CobblemonItems.FLYING_GEM) ? 1.75 : 1.0), Map.entry("bestow", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.ITEM_ENDED) || from.getEffectedPokemon().heldItem().isEmpty() ? 0.0 : 1.0), Map.entry("fling", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.ITEM_ENDED) || from.getEffectedPokemon().heldItem().isEmpty() ? 0.0 : 1.0), Map.entry("switcheroo", (from, to, move) -> !(!BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.ITEM_ENDED) && !from.getEffectedPokemon().heldItem().isEmpty() || !BattleStates.get(from.actor.battle).getPokemonState(to).has(BattleEffects.Custom.ITEM_ENDED) && !to.getEffectedPokemon().heldItem().isEmpty()) ? 0.0 : 1.0), Map.entry("trick", (from, to, move) -> !(!BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.ITEM_ENDED) && !from.getEffectedPokemon().heldItem().isEmpty() || !BattleStates.get(from.actor.battle).getPokemonState(to).has(BattleEffects.Custom.ITEM_ENDED) && !to.getEffectedPokemon().heldItem().isEmpty()) ? 0.0 : 1.0), Map.entry("recycle", (from, to, move) -> BattleStates.get(from.actor.battle).getPokemonState(from).has(BattleEffects.Custom.ITEM_ENDED) ? 1.0 : 0.0), Map.entry("teatime", (from, to, move) -> Streams.of((Iterable)from.actor.battle.getActivePokemon()).anyMatch(p -> p.isAlive() && p.getBattlePokemon().getEffectedPokemon().heldItem().getItem() instanceof BerryItem && !BattleStates.get(from.actor.battle).getPokemonState(p.getBattlePokemon()).has(BattleEffects.Custom.ITEM_ENDED)) ? 1.0 : 0.0));
        MOVE_HANDLERS = Map.ofEntries(Map.entry("wish", (f, t) -> BattleStates.get(f.actor.battle).getPokemonState(f).add(BattleEffects.Custom.WISH)), Map.entry("meanlook", (f, t) -> BattleStates.get(f.actor.battle).getPokemonState(t).add(BattleEffects.Custom.MEANLOOK)), Map.entry("spiderweb", (f, t) -> BattleStates.get(f.actor.battle).getPokemonState(t).add(BattleEffects.Custom.SPIDERWEB)), Map.entry("block", (f, t) -> BattleStates.get(f.actor.battle).getPokemonState(t).add(BattleEffects.Custom.BLOCK)), Map.entry("protect", (f, t) -> BattleStates.get(f.actor.battle).getPokemonState(f).add(BattleEffects.Custom.PROTECT)), Map.entry("detect", (f, t) -> BattleStates.get(f.actor.battle).getPokemonState(f).add(BattleEffects.Custom.PROTECT)), Map.entry("endure", (f, t) -> BattleStates.get(f.actor.battle).getPokemonState(f).add(BattleEffects.Custom.PROTECT)), Map.entry("wideguard", (f, t) -> BattleStates.get(f.actor.battle).getPokemonState(f).add(BattleEffects.Custom.PROTECT)), Map.entry("quickguard", (f, t) -> BattleStates.get(f.actor.battle).getPokemonState(f).add(BattleEffects.Custom.PROTECT)), Map.entry("spikyshield", (f, t) -> BattleStates.get(f.actor.battle).getPokemonState(f).add(BattleEffects.Custom.PROTECT)), Map.entry("kingsshield", (f, t) -> BattleStates.get(f.actor.battle).getPokemonState(f).add(BattleEffects.Custom.PROTECT)), Map.entry("banefulbunker", (f, t) -> BattleStates.get(f.actor.battle).getPokemonState(f).add(BattleEffects.Custom.PROTECT)));
        MOVE_TYPES = Map.ofEntries(Map.entry("10000000voltthunderbolt", DAMAGE), Map.entry("absorb", DAMAGE), Map.entry("accelerock", DAMAGE), Map.entry("acid", DAMAGE), Map.entry("acidarmor", BUFF), Map.entry("aciddownpour", DAMAGE), Map.entry("acidspray", DAMAGE), Map.entry("acrobatics", DAMAGE), Map.entry("acupressure", BUFF), Map.entry("aerialace", DAMAGE), Map.entry("aeroblast", DAMAGE), Map.entry("afteryou", STATUS), Map.entry("agility", BUFF), Map.entry("aircutter", DAMAGE), Map.entry("airslash", DAMAGE), Map.entry("alloutpummeling", DAMAGE), Map.entry("alluringvoice", DAMAGE), Map.entry("allyswitch", STATUS), Map.entry("amnesia", BUFF), Map.entry("anchorshot", DAMAGE), Map.entry("ancientpower", DAMAGE), Map.entry("appleacid", DAMAGE), Map.entry("aquacutter", DAMAGE), Map.entry("aquajet", DAMAGE), Map.entry("aquaring", HEAL), Map.entry("aquastep", DAMAGE), Map.entry("aquatail", DAMAGE), Map.entry("armthrust", DAMAGE), Map.entry("armorcannon", DAMAGE), Map.entry("aromatherapy", CURE), Map.entry("aromaticmist", BUFF), Map.entry("assist", STATUS), Map.entry("assurance", DAMAGE), Map.entry("astonish", DAMAGE), Map.entry("astralbarrage", DAMAGE), Map.entry("attackorder", DAMAGE), Map.entry("attract", STATUS), Map.entry("aurasphere", DAMAGE), Map.entry("aurawheel", DAMAGE), Map.entry("aurorabeam", DAMAGE), Map.entry("auroraveil", BUFF), Map.entry("autotomize", BUFF), Map.entry("avalanche", DAMAGE), Map.entry("axekick", DAMAGE), Map.entry("babydolleyes", MALUS), Map.entry("baddybad", DAMAGE), Map.entry("banefulbunker", STATUS), Map.entry("barbbarrage", DAMAGE), Map.entry("barrage", DAMAGE), Map.entry("barrier", BUFF), Map.entry("batonpass", STATUS), Map.entry("beakblast", DAMAGE), Map.entry("beatup", DAMAGE), Map.entry("behemothbash", DAMAGE), Map.entry("behemothblade", DAMAGE), Map.entry("belch", DAMAGE), Map.entry("bellydrum", BUFF), Map.entry("bestow", STATUS), Map.entry("bide", DAMAGE), Map.entry("bind", DAMAGE), Map.entry("bite", DAMAGE), Map.entry("bitterblade", DAMAGE), Map.entry("bittermalice", DAMAGE), Map.entry("blackholeeclipse", DAMAGE), Map.entry("blastburn", DAMAGE), Map.entry("blazekick", DAMAGE), Map.entry("blazingtorque", DAMAGE), Map.entry("bleakwindstorm", DAMAGE), Map.entry("blizzard", DAMAGE), Map.entry("block", STATUS), Map.entry("bloodmoon", DAMAGE), Map.entry("bloomdoom", DAMAGE), Map.entry("blueflare", DAMAGE), Map.entry("bodypress", DAMAGE), Map.entry("bodyslam", DAMAGE), Map.entry("boltbeak", DAMAGE), Map.entry("boltstrike", DAMAGE), Map.entry("boneclub", DAMAGE), Map.entry("bonerush", DAMAGE), Map.entry("bonemerang", DAMAGE), Map.entry("boomburst", DAMAGE), Map.entry("bounce", DAMAGE), Map.entry("bouncybubble", DAMAGE), Map.entry("branchpoke", DAMAGE), Map.entry("bravebird", DAMAGE), Map.entry("breakingswipe", DAMAGE), Map.entry("breakneckblitz", DAMAGE), Map.entry("brickbreak", DAMAGE), Map.entry("brine", DAMAGE), Map.entry("brutalswing", DAMAGE), Map.entry("bubble", DAMAGE), Map.entry("bubblebeam", DAMAGE), Map.entry("bugbite", DAMAGE), Map.entry("bugbuzz", DAMAGE), Map.entry("bulkup", BUFF), Map.entry("bulldoze", DAMAGE), Map.entry("bulletpunch", DAMAGE), Map.entry("bulletseed", DAMAGE), Map.entry("burnup", DAMAGE), Map.entry("burningbulwark", BUFF), Map.entry("burningjealousy", DAMAGE), Map.entry("buzzybuzz", DAMAGE), Map.entry("calmmind", BUFF), Map.entry("camouflage", STATUS), Map.entry("captivate", MALUS), Map.entry("catastropika", DAMAGE), Map.entry("ceaselessedge", DAMAGE), Map.entry("celebrate", STATUS), Map.entry("charge", BUFF), Map.entry("chargebeam", DAMAGE), Map.entry("charm", MALUS), Map.entry("chatter", DAMAGE), Map.entry("chillingwater", DAMAGE), Map.entry("chillyreception", STATUS), Map.entry("chipaway", DAMAGE), Map.entry("chloroblast", DAMAGE), Map.entry("circlethrow", DAMAGE), Map.entry("clamp", DAMAGE), Map.entry("clangingscales", DAMAGE), Map.entry("clangoroussoul", BUFF), Map.entry("clangoroussoulblaze", DAMAGE), Map.entry("clearsmog", DAMAGE), Map.entry("closecombat", DAMAGE), Map.entry("coaching", BUFF), Map.entry("coil", BUFF), Map.entry("collisioncourse", DAMAGE), Map.entry("combattorque", DAMAGE), Map.entry("cometpunch", DAMAGE), Map.entry("comeuppance", DAMAGE), Map.entry("confide", STATUS), Map.entry("confuseray", STATUS), Map.entry("confusion", DAMAGE), Map.entry("constrict", DAMAGE), Map.entry("continentalcrush", DAMAGE), Map.entry("conversion", STATUS), Map.entry("conversion2", STATUS), Map.entry("copycat", STATUS), Map.entry("coreenforcer", DAMAGE), Map.entry("corkscrewcrash", DAMAGE), Map.entry("corrosivegas", MALUS), Map.entry("cosmicpower", BUFF), Map.entry("cottonguard", BUFF), Map.entry("cottonspore", MALUS), Map.entry("counter", DAMAGE), Map.entry("courtchange", STATUS), Map.entry("covet", DAMAGE), Map.entry("crabhammer", DAMAGE), Map.entry("craftyshield", STATUS), Map.entry("crosschop", DAMAGE), Map.entry("crosspoison", DAMAGE), Map.entry("crunch", DAMAGE), Map.entry("crushclaw", DAMAGE), Map.entry("crushgrip", DAMAGE), Map.entry("curse", STATUS), Map.entry("cut", DAMAGE), Map.entry("darkpulse", DAMAGE), Map.entry("darkvoid", STATUS), Map.entry("darkestlariat", DAMAGE), Map.entry("dazzlinggleam", DAMAGE), Map.entry("decorate", BUFF), Map.entry("defendorder", BUFF), Map.entry("defensecurl", BUFF), Map.entry("defog", STATUS), Map.entry("destinybond", STATUS), Map.entry("detect", STATUS), Map.entry("devastatingdrake", DAMAGE), Map.entry("diamondstorm", DAMAGE), Map.entry("dig", DAMAGE), Map.entry("direclaw", DAMAGE), Map.entry("disable", STATUS), Map.entry("disarmingvoice", DAMAGE), Map.entry("discharge", DAMAGE), Map.entry("dive", DAMAGE), Map.entry("dizzypunch", DAMAGE), Map.entry("doodle", STATUS), Map.entry("doomdesire", DAMAGE), Map.entry("doublehit", DAMAGE), Map.entry("doubleironbash", DAMAGE), Map.entry("doublekick", DAMAGE), Map.entry("doubleshock", DAMAGE), Map.entry("doubleslap", DAMAGE), Map.entry("doubleteam", STATUS), Map.entry("doubleedge", DAMAGE), Map.entry("dracometeor", DAMAGE), Map.entry("dragonascent", DAMAGE), Map.entry("dragonbreath", DAMAGE), Map.entry("dragoncheer", BUFF), Map.entry("dragonclaw", DAMAGE), Map.entry("dragondance", BUFF), Map.entry("dragondarts", DAMAGE), Map.entry("dragonenergy", DAMAGE), Map.entry("dragonhammer", DAMAGE), Map.entry("dragonpulse", DAMAGE), Map.entry("dragonrage", DAMAGE), Map.entry("dragonrush", DAMAGE), Map.entry("dragontail", DAMAGE), Map.entry("drainpunch", DAMAGE), Map.entry("drainingkiss", DAMAGE), Map.entry("dreameater", DAMAGE), Map.entry("drillpeck", DAMAGE), Map.entry("drillrun", DAMAGE), Map.entry("drumbeating", DAMAGE), Map.entry("dualchop", DAMAGE), Map.entry("dualwingbeat", DAMAGE), Map.entry("dynamaxcannon", DAMAGE), Map.entry("dynamicpunch", DAMAGE), Map.entry("earthpower", DAMAGE), Map.entry("earthquake", DAMAGE), Map.entry("echoedvoice", DAMAGE), Map.entry("eerieimpulse", MALUS), Map.entry("eeriespell", DAMAGE), Map.entry("eggbomb", DAMAGE), Map.entry("electricterrain", STATUS), Map.entry("electrify", STATUS), Map.entry("electroball", DAMAGE), Map.entry("electrodrift", DAMAGE), Map.entry("electroshot", DAMAGE), Map.entry("electroweb", DAMAGE), Map.entry("embargo", STATUS), Map.entry("ember", DAMAGE), Map.entry("encore", STATUS), Map.entry("endeavor", DAMAGE), Map.entry("endure", STATUS), Map.entry("energyball", DAMAGE), Map.entry("entrainment", STATUS), Map.entry("eruption", DAMAGE), Map.entry("esperwing", DAMAGE), Map.entry("eternabeam", DAMAGE), Map.entry("expandingforce", DAMAGE), Map.entry("explosion", DAMAGE), Map.entry("extrasensory", DAMAGE), Map.entry("extremeevoboost", BUFF), Map.entry("extremespeed", DAMAGE), Map.entry("facade", DAMAGE), Map.entry("fairylock", STATUS), Map.entry("fairywind", DAMAGE), Map.entry("fakeout", DAMAGE), Map.entry("faketears", MALUS), Map.entry("falsesurrender", DAMAGE), Map.entry("falseswipe", DAMAGE), Map.entry("featherdance", MALUS), Map.entry("feint", DAMAGE), Map.entry("feintattack", DAMAGE), Map.entry("fellstinger", DAMAGE), Map.entry("ficklebeam", DAMAGE), Map.entry("fierydance", DAMAGE), Map.entry("fierywrath", DAMAGE), Map.entry("filletaway", STATUS), Map.entry("finalgambit", DAMAGE), Map.entry("fireblast", DAMAGE), Map.entry("firefang", DAMAGE), Map.entry("firelash", DAMAGE), Map.entry("firepledge", DAMAGE), Map.entry("firepunch", DAMAGE), Map.entry("firespin", DAMAGE), Map.entry("firstimpression", DAMAGE), Map.entry("fishiousrend", DAMAGE), Map.entry("fissure", DAMAGE), Map.entry("flail", DAMAGE), Map.entry("flameburst", DAMAGE), Map.entry("flamecharge", DAMAGE), Map.entry("flamewheel", DAMAGE), Map.entry("flamethrower", DAMAGE), Map.entry("flareblitz", DAMAGE), Map.entry("flash", STATUS), Map.entry("flashcannon", DAMAGE), Map.entry("flatter", MALUS), Map.entry("fleurcannon", DAMAGE), Map.entry("fling", DAMAGE), Map.entry("flipturn", DAMAGE), Map.entry("floatyfall", DAMAGE), Map.entry("floralhealing", HEAL), Map.entry("flowershield", BUFF), Map.entry("flowertrick", DAMAGE), Map.entry("fly", DAMAGE), Map.entry("flyingpress", DAMAGE), Map.entry("focusblast", DAMAGE), Map.entry("focusenergy", BUFF), Map.entry("focuspunch", DAMAGE), Map.entry("followme", STATUS), Map.entry("forcepalm", DAMAGE), Map.entry("foresight", STATUS), Map.entry("forestscurse", STATUS), Map.entry("foulplay", DAMAGE), Map.entry("freezeshock", DAMAGE), Map.entry("freezedry", DAMAGE), Map.entry("freezingglare", DAMAGE), Map.entry("freezyfrost", DAMAGE), Map.entry("frenzyplant", DAMAGE), Map.entry("frostbreath", DAMAGE), Map.entry("frustration", DAMAGE), Map.entry("furyattack", DAMAGE), Map.entry("furycutter", DAMAGE), Map.entry("furyswipes", DAMAGE), Map.entry("fusionbolt", DAMAGE), Map.entry("fusionflare", DAMAGE), Map.entry("futuresight", DAMAGE), Map.entry("gmaxbefuddle", DAMAGE), Map.entry("gmaxcannonade", DAMAGE), Map.entry("gmaxcentiferno", DAMAGE), Map.entry("gmaxchistrike", DAMAGE), Map.entry("gmaxcuddle", DAMAGE), Map.entry("gmaxdepletion", DAMAGE), Map.entry("gmaxdrumsolo", DAMAGE), Map.entry("gmaxfinale", DAMAGE), Map.entry("gmaxfireball", DAMAGE), Map.entry("gmaxfoamburst", DAMAGE), Map.entry("gmaxgoldrush", DAMAGE), Map.entry("gmaxgravitas", DAMAGE), Map.entry("gmaxhydrosnipe", DAMAGE), Map.entry("gmaxmalodor", DAMAGE), Map.entry("gmaxmeltdown", DAMAGE), Map.entry("gmaxoneblow", DAMAGE), Map.entry("gmaxrapidflow", DAMAGE), Map.entry("gmaxreplenish", DAMAGE), Map.entry("gmaxresonance", DAMAGE), Map.entry("gmaxsandblast", DAMAGE), Map.entry("gmaxsmite", DAMAGE), Map.entry("gmaxsnooze", DAMAGE), Map.entry("gmaxsteelsurge", DAMAGE), Map.entry("gmaxstonesurge", DAMAGE), Map.entry("gmaxstunshock", DAMAGE), Map.entry("gmaxsweetness", DAMAGE), Map.entry("gmaxtartness", DAMAGE), Map.entry("gmaxterror", DAMAGE), Map.entry("gmaxvinelash", DAMAGE), Map.entry("gmaxvolcalith", DAMAGE), Map.entry("gmaxvoltcrash", DAMAGE), Map.entry("gmaxwildfire", DAMAGE), Map.entry("gmaxwindrage", DAMAGE), Map.entry("gastroacid", MALUS), Map.entry("geargrind", DAMAGE), Map.entry("gearup", BUFF), Map.entry("genesissupernova", DAMAGE), Map.entry("geomancy", BUFF), Map.entry("gigadrain", DAMAGE), Map.entry("gigaimpact", DAMAGE), Map.entry("gigatonhammer", DAMAGE), Map.entry("gigavolthavoc", DAMAGE), Map.entry("glaciallance", DAMAGE), Map.entry("glaciate", DAMAGE), Map.entry("glaiverush", DAMAGE), Map.entry("glare", STATUS), Map.entry("glitzyglow", DAMAGE), Map.entry("grassknot", DAMAGE), Map.entry("grasspledge", DAMAGE), Map.entry("grasswhistle", STATUS), Map.entry("grassyglide", DAMAGE), Map.entry("grassyterrain", STATUS), Map.entry("gravapple", DAMAGE), Map.entry("gravity", STATUS), Map.entry("growl", MALUS), Map.entry("growth", BUFF), Map.entry("grudge", STATUS), Map.entry("guardsplit", STATUS), Map.entry("guardswap", STATUS), Map.entry("guardianofalola", DAMAGE), Map.entry("guillotine", DAMAGE), Map.entry("gunkshot", DAMAGE), Map.entry("gust", DAMAGE), Map.entry("gyroball", DAMAGE), Map.entry("hail", STATUS), Map.entry("hammerarm", DAMAGE), Map.entry("happyhour", STATUS), Map.entry("hardpress", DAMAGE), Map.entry("harden", BUFF), Map.entry("haze", STATUS), Map.entry("headcharge", DAMAGE), Map.entry("headsmash", DAMAGE), Map.entry("headbutt", DAMAGE), Map.entry("headlongrush", DAMAGE), Map.entry("healbell", CURE), Map.entry("healblock", STATUS), Map.entry("healorder", HEAL), Map.entry("healpulse", HEAL), Map.entry("healingwish", HEAL), Map.entry("heartstamp", DAMAGE), Map.entry("heartswap", STATUS), Map.entry("heatcrash", DAMAGE), Map.entry("heatwave", DAMAGE), Map.entry("heavyslam", DAMAGE), Map.entry("helpinghand", BUFF), Map.entry("hex", DAMAGE), Map.entry("hiddenpower", DAMAGE), Map.entry("highhorsepower", DAMAGE), Map.entry("highjumpkick", DAMAGE), Map.entry("holdback", DAMAGE), Map.entry("holdhands", STATUS), Map.entry("honeclaws", BUFF), Map.entry("hornattack", DAMAGE), Map.entry("horndrill", DAMAGE), Map.entry("hornleech", DAMAGE), Map.entry("howl", BUFF), Map.entry("hurricane", DAMAGE), Map.entry("hydrocannon", DAMAGE), Map.entry("hydropump", DAMAGE), Map.entry("hydrosteam", DAMAGE), Map.entry("hydrovortex", DAMAGE), Map.entry("hyperbeam", DAMAGE), Map.entry("hyperdrill", DAMAGE), Map.entry("hyperfang", DAMAGE), Map.entry("hypervoice", DAMAGE), Map.entry("hyperspacefury", DAMAGE), Map.entry("hyperspacehole", DAMAGE), Map.entry("hypnosis", STATUS), Map.entry("iceball", DAMAGE), Map.entry("icebeam", DAMAGE), Map.entry("iceburn", DAMAGE), Map.entry("icefang", DAMAGE), Map.entry("icehammer", DAMAGE), Map.entry("icepunch", DAMAGE), Map.entry("iceshard", DAMAGE), Map.entry("icespinner", DAMAGE), Map.entry("iciclecrash", DAMAGE), Map.entry("iciclespear", DAMAGE), Map.entry("icywind", DAMAGE), Map.entry("imprison", STATUS), Map.entry("incinerate", DAMAGE), Map.entry("infernalparade", DAMAGE), Map.entry("inferno", DAMAGE), Map.entry("infernooverdrive", DAMAGE), Map.entry("infestation", DAMAGE), Map.entry("ingrain", HEAL), Map.entry("instruct", STATUS), Map.entry("iondeluge", STATUS), Map.entry("irondefense", BUFF), Map.entry("ironhead", DAMAGE), Map.entry("irontail", DAMAGE), Map.entry("ivycudgel", DAMAGE), Map.entry("jawlock", DAMAGE), Map.entry("jetpunch", DAMAGE), Map.entry("judgment", DAMAGE), Map.entry("jumpkick", DAMAGE), Map.entry("junglehealing", HEAL), Map.entry("karatechop", DAMAGE), Map.entry("kinesis", STATUS), Map.entry("kingsshield", STATUS), Map.entry("knockoff", DAMAGE), Map.entry("kowtowcleave", DAMAGE), Map.entry("landswrath", DAMAGE), Map.entry("laserfocus", BUFF), Map.entry("lashout", DAMAGE), Map.entry("lastresort", DAMAGE), Map.entry("lastrespects", DAMAGE), Map.entry("lavaplume", DAMAGE), Map.entry("leafblade", DAMAGE), Map.entry("leafstorm", DAMAGE), Map.entry("leaftornado", DAMAGE), Map.entry("leafage", DAMAGE), Map.entry("leechlife", DAMAGE), Map.entry("leechseed", STATUS), Map.entry("leer", MALUS), Map.entry("letssnuggleforever", DAMAGE), Map.entry("lick", DAMAGE), Map.entry("lifedew", HEAL), Map.entry("lightofruin", DAMAGE), Map.entry("lightscreen", BUFF), Map.entry("lightthatburnsthesky", DAMAGE), Map.entry("liquidation", DAMAGE), Map.entry("lockon", STATUS), Map.entry("lovelykiss", STATUS), Map.entry("lowkick", DAMAGE), Map.entry("lowsweep", DAMAGE), Map.entry("luckychant", STATUS), Map.entry("luminacrash", DAMAGE), Map.entry("lunarblessing", HEAL), Map.entry("lunardance", STATUS), Map.entry("lunge", DAMAGE), Map.entry("lusterpurge", DAMAGE), Map.entry("machpunch", DAMAGE), Map.entry("magiccoat", STATUS), Map.entry("magicpowder", STATUS), Map.entry("magicroom", STATUS), Map.entry("magicalleaf", DAMAGE), Map.entry("magicaltorque", DAMAGE), Map.entry("magmastorm", DAMAGE), Map.entry("magnetbomb", DAMAGE), Map.entry("magnetrise", STATUS), Map.entry("magneticflux", BUFF), Map.entry("magnitude", DAMAGE), Map.entry("makeitrain", DAMAGE), Map.entry("maliciousmoonsault", DAMAGE), Map.entry("malignantchain", DAMAGE), Map.entry("matblock", STATUS), Map.entry("matchagotcha", DAMAGE), Map.entry("maxairstream", DAMAGE), Map.entry("maxdarkness", DAMAGE), Map.entry("maxflare", DAMAGE), Map.entry("maxflutterby", DAMAGE), Map.entry("maxgeyser", DAMAGE), Map.entry("maxguard", DAMAGE), Map.entry("maxhailstorm", DAMAGE), Map.entry("maxknuckle", DAMAGE), Map.entry("maxlightning", DAMAGE), Map.entry("maxmindstorm", DAMAGE), Map.entry("maxooze", DAMAGE), Map.entry("maxovergrowth", DAMAGE), Map.entry("maxphantasm", DAMAGE), Map.entry("maxquake", DAMAGE), Map.entry("maxrockfall", DAMAGE), Map.entry("maxstarfall", DAMAGE), Map.entry("maxsteelspike", DAMAGE), Map.entry("maxstrike", DAMAGE), Map.entry("maxwyrmwind", DAMAGE), Map.entry("mefirst", STATUS), Map.entry("meanlook", STATUS), Map.entry("meditate", BUFF), Map.entry("megadrain", DAMAGE), Map.entry("megakick", DAMAGE), Map.entry("megapunch", DAMAGE), Map.entry("megahorn", DAMAGE), Map.entry("memento", STATUS), Map.entry("menacingmoonrazemaelstrom", DAMAGE), Map.entry("metalburst", DAMAGE), Map.entry("metalclaw", DAMAGE), Map.entry("metalsound", MALUS), Map.entry("meteorassault", DAMAGE), Map.entry("meteorbeam", DAMAGE), Map.entry("meteormash", DAMAGE), Map.entry("metronome", STATUS), Map.entry("mightycleave", DAMAGE), Map.entry("milkdrink", HEAL), Map.entry("mimic", STATUS), Map.entry("mindblown", DAMAGE), Map.entry("mindreader", STATUS), Map.entry("minimize", STATUS), Map.entry("miracleeye", STATUS), Map.entry("mirrorcoat", DAMAGE), Map.entry("mirrormove", STATUS), Map.entry("mirrorshot", DAMAGE), Map.entry("mist", STATUS), Map.entry("mistball", DAMAGE), Map.entry("mistyexplosion", DAMAGE), Map.entry("mistyterrain", STATUS), Map.entry("moonblast", DAMAGE), Map.entry("moongeistbeam", DAMAGE), Map.entry("moonlight", HEAL), Map.entry("morningsun", HEAL), Map.entry("mortalspin", DAMAGE), Map.entry("mountaingale", DAMAGE), Map.entry("mudbomb", DAMAGE), Map.entry("mudshot", DAMAGE), Map.entry("mudsport", STATUS), Map.entry("mudslap", DAMAGE), Map.entry("muddywater", DAMAGE), Map.entry("multiattack", DAMAGE), Map.entry("mysticalfire", DAMAGE), Map.entry("mysticalpower", DAMAGE), Map.entry("nastyplot", BUFF), Map.entry("naturalgift", DAMAGE), Map.entry("naturepower", STATUS), Map.entry("naturesmadness", DAMAGE), Map.entry("needlearm", DAMAGE), Map.entry("neverendingnightmare", DAMAGE), Map.entry("nightdaze", DAMAGE), Map.entry("nightshade", DAMAGE), Map.entry("nightslash", DAMAGE), Map.entry("nightmare", STATUS), Map.entry("noretreat", STATUS), Map.entry("nobleroar", MALUS), Map.entry("noxioustorque", DAMAGE), Map.entry("nuzzle", DAMAGE), Map.entry("oblivionwing", DAMAGE), Map.entry("obstruct", STATUS), Map.entry("oceanicoperetta", DAMAGE), Map.entry("octazooka", DAMAGE), Map.entry("octolock", STATUS), Map.entry("odorsleuth", STATUS), Map.entry("ominouswind", DAMAGE), Map.entry("orderup", DAMAGE), Map.entry("originpulse", DAMAGE), Map.entry("outrage", DAMAGE), Map.entry("overdrive", DAMAGE), Map.entry("overheat", DAMAGE), Map.entry("painsplit", STATUS), Map.entry("paraboliccharge", DAMAGE), Map.entry("partingshot", MALUS), Map.entry("payday", DAMAGE), Map.entry("payback", DAMAGE), Map.entry("peck", DAMAGE), Map.entry("perishsong", STATUS), Map.entry("petalblizzard", DAMAGE), Map.entry("petaldance", DAMAGE), Map.entry("phantomforce", DAMAGE), Map.entry("photongeyser", DAMAGE), Map.entry("pikapapow", DAMAGE), Map.entry("pinmissile", DAMAGE), Map.entry("plasmafists", DAMAGE), Map.entry("playnice", MALUS), Map.entry("playrough", DAMAGE), Map.entry("pluck", DAMAGE), Map.entry("poisonfang", DAMAGE), Map.entry("poisongas", STATUS), Map.entry("poisonjab", DAMAGE), Map.entry("poisonpowder", STATUS), Map.entry("poisonsting", DAMAGE), Map.entry("poisontail", DAMAGE), Map.entry("pollenpuff", DAMAGE), Map.entry("poltergeist", DAMAGE), Map.entry("populationbomb", DAMAGE), Map.entry("pounce", DAMAGE), Map.entry("pound", DAMAGE), Map.entry("powder", STATUS), Map.entry("powdersnow", DAMAGE), Map.entry("powergem", DAMAGE), Map.entry("powershift", STATUS), Map.entry("powersplit", STATUS), Map.entry("powerswap", STATUS), Map.entry("powertrick", STATUS), Map.entry("powertrip", DAMAGE), Map.entry("powerwhip", DAMAGE), Map.entry("poweruppunch", DAMAGE), Map.entry("precipiceblades", DAMAGE), Map.entry("present", DAMAGE), Map.entry("prismaticlaser", DAMAGE), Map.entry("protect", STATUS), Map.entry("psybeam", DAMAGE), Map.entry("psyblade", DAMAGE), Map.entry("psychup", STATUS), Map.entry("psychic", DAMAGE), Map.entry("psychicfangs", DAMAGE), Map.entry("psychicnoise", DAMAGE), Map.entry("psychicterrain", STATUS), Map.entry("psychoboost", DAMAGE), Map.entry("psychocut", DAMAGE), Map.entry("psychoshift", CURE), Map.entry("psyshieldbash", DAMAGE), Map.entry("psyshock", DAMAGE), Map.entry("psystrike", DAMAGE), Map.entry("psywave", DAMAGE), Map.entry("pulverizingpancake", DAMAGE), Map.entry("punishment", DAMAGE), Map.entry("purify", CURE), Map.entry("pursuit", DAMAGE), Map.entry("pyroball", DAMAGE), Map.entry("quash", STATUS), Map.entry("quickattack", DAMAGE), Map.entry("quickguard", STATUS), Map.entry("quiverdance", BUFF), Map.entry("rage", DAMAGE), Map.entry("ragefist", DAMAGE), Map.entry("ragepowder", STATUS), Map.entry("ragingbull", DAMAGE), Map.entry("ragingfury", DAMAGE), Map.entry("raindance", STATUS), Map.entry("rapidspin", DAMAGE), Map.entry("razorleaf", DAMAGE), Map.entry("razorshell", DAMAGE), Map.entry("razorwind", DAMAGE), Map.entry("recover", HEAL), Map.entry("recycle", STATUS), Map.entry("reflect", BUFF), Map.entry("reflecttype", STATUS), Map.entry("refresh", HEAL), Map.entry("relicsong", DAMAGE), Map.entry("rest", HEAL), Map.entry("retaliate", DAMAGE), Map.entry("return", DAMAGE), Map.entry("revelationdance", DAMAGE), Map.entry("revenge", DAMAGE), Map.entry("reversal", DAMAGE), Map.entry("revivalblessing", HEAL), Map.entry("risingvoltage", DAMAGE), Map.entry("roar", STATUS), Map.entry("roaroftime", DAMAGE), Map.entry("rockblast", DAMAGE), Map.entry("rockclimb", DAMAGE), Map.entry("rockpolish", BUFF), Map.entry("rockslide", DAMAGE), Map.entry("rocksmash", DAMAGE), Map.entry("rockthrow", DAMAGE), Map.entry("rocktomb", DAMAGE), Map.entry("rockwrecker", DAMAGE), Map.entry("roleplay", STATUS), Map.entry("rollingkick", DAMAGE), Map.entry("rollout", DAMAGE), Map.entry("roost", HEAL), Map.entry("rototiller", STATUS), Map.entry("round", DAMAGE), Map.entry("ruination", DAMAGE), Map.entry("sacredfire", DAMAGE), Map.entry("sacredsword", DAMAGE), Map.entry("safeguard", STATUS), Map.entry("saltcure", DAMAGE), Map.entry("sandattack", MALUS), Map.entry("sandtomb", DAMAGE), Map.entry("sandsearstorm", DAMAGE), Map.entry("sandstorm", STATUS), Map.entry("sappyseed", DAMAGE), Map.entry("savagespinout", DAMAGE), Map.entry("scald", DAMAGE), Map.entry("scaleshot", DAMAGE), Map.entry("scaryface", MALUS), Map.entry("scorchingsands", DAMAGE), Map.entry("scratch", DAMAGE), Map.entry("screech", MALUS), Map.entry("searingshot", DAMAGE), Map.entry("searingsunrazesmash", DAMAGE), Map.entry("secretpower", DAMAGE), Map.entry("secretsword", DAMAGE), Map.entry("seedbomb", DAMAGE), Map.entry("seedflare", DAMAGE), Map.entry("seismictoss", DAMAGE), Map.entry("selfdestruct", DAMAGE), Map.entry("shadowball", DAMAGE), Map.entry("shadowbone", DAMAGE), Map.entry("shadowclaw", DAMAGE), Map.entry("shadowforce", DAMAGE), Map.entry("shadowpunch", DAMAGE), Map.entry("shadowsneak", DAMAGE), Map.entry("sharpen", BUFF), Map.entry("shatteredpsyche", DAMAGE), Map.entry("shedtail", STATUS), Map.entry("sheercold", DAMAGE), Map.entry("shellsidearm", DAMAGE), Map.entry("shellsmash", BUFF), Map.entry("shelltrap", DAMAGE), Map.entry("shelter", STATUS), Map.entry("shiftgear", BUFF), Map.entry("shockwave", DAMAGE), Map.entry("shoreup", HEAL), Map.entry("signalbeam", DAMAGE), Map.entry("silktrap", STATUS), Map.entry("silverwind", DAMAGE), Map.entry("simplebeam", STATUS), Map.entry("sing", STATUS), Map.entry("sinisterarrowraid", DAMAGE), Map.entry("sizzlyslide", DAMAGE), Map.entry("sketch", STATUS), Map.entry("skillswap", STATUS), Map.entry("skittersmack", DAMAGE), Map.entry("skullbash", DAMAGE), Map.entry("skyattack", DAMAGE), Map.entry("skydrop", DAMAGE), Map.entry("skyuppercut", DAMAGE), Map.entry("slackoff", HEAL), Map.entry("slam", DAMAGE), Map.entry("slash", DAMAGE), Map.entry("sleeppowder", STATUS), Map.entry("sleeptalk", STATUS), Map.entry("sludge", DAMAGE), Map.entry("sludgebomb", DAMAGE), Map.entry("sludgewave", DAMAGE), Map.entry("smackdown", DAMAGE), Map.entry("smartstrike", DAMAGE), Map.entry("smellingsalts", DAMAGE), Map.entry("smog", DAMAGE), Map.entry("smokescreen", MALUS), Map.entry("snaptrap", DAMAGE), Map.entry("snarl", DAMAGE), Map.entry("snatch", STATUS), Map.entry("snipeshot", DAMAGE), Map.entry("snore", DAMAGE), Map.entry("snowscape", STATUS), Map.entry("soak", STATUS), Map.entry("softboiled", HEAL), Map.entry("solarbeam", DAMAGE), Map.entry("solarblade", DAMAGE), Map.entry("sonicboom", DAMAGE), Map.entry("soulstealing7starstrike", DAMAGE), Map.entry("spacialrend", DAMAGE), Map.entry("spark", DAMAGE), Map.entry("sparklingaria", DAMAGE), Map.entry("sparklyswirl", DAMAGE), Map.entry("spectralthief", DAMAGE), Map.entry("speedswap", STATUS), Map.entry("spicyextract", BUFF), Map.entry("spiderweb", STATUS), Map.entry("spikecannon", DAMAGE), Map.entry("spikes", STATUS), Map.entry("spikyshield", STATUS), Map.entry("spinout", DAMAGE), Map.entry("spiritbreak", DAMAGE), Map.entry("spiritshackle", DAMAGE), Map.entry("spitup", DAMAGE), Map.entry("spite", STATUS), Map.entry("splash", STATUS), Map.entry("splinteredstormshards", DAMAGE), Map.entry("splishysplash", DAMAGE), Map.entry("spore", STATUS), Map.entry("spotlight", STATUS), Map.entry("springtidestorm", DAMAGE), Map.entry("stealthrock", STATUS), Map.entry("steameruption", DAMAGE), Map.entry("steamroller", DAMAGE), Map.entry("steelbeam", DAMAGE), Map.entry("steelroller", DAMAGE), Map.entry("steelwing", DAMAGE), Map.entry("stickyweb", STATUS), Map.entry("stockpile", BUFF), Map.entry("stokedsparksurfer", DAMAGE), Map.entry("stomp", DAMAGE), Map.entry("stompingtantrum", DAMAGE), Map.entry("stoneaxe", DAMAGE), Map.entry("stoneedge", DAMAGE), Map.entry("storedpower", DAMAGE), Map.entry("stormthrow", DAMAGE), Map.entry("strangesteam", DAMAGE), Map.entry("strength", DAMAGE), Map.entry("strengthsap", HEAL), Map.entry("stringshot", STATUS), Map.entry("struggle", DAMAGE), Map.entry("strugglebug", DAMAGE), Map.entry("stuffcheeks", STATUS), Map.entry("stunspore", STATUS), Map.entry("submission", DAMAGE), Map.entry("substitute", STATUS), Map.entry("subzeroslammer", DAMAGE), Map.entry("suckerpunch", DAMAGE), Map.entry("sunnyday", STATUS), Map.entry("sunsteelstrike", DAMAGE), Map.entry("superfang", DAMAGE), Map.entry("supercellslam", DAMAGE), Map.entry("superpower", DAMAGE), Map.entry("supersonic", STATUS), Map.entry("supersonicskystrike", DAMAGE), Map.entry("surf", DAMAGE), Map.entry("surgingstrikes", DAMAGE), Map.entry("swagger", MALUS), Map.entry("swallow", STATUS), Map.entry("sweetkiss", STATUS), Map.entry("sweetscent", STATUS), Map.entry("swift", DAMAGE), Map.entry("switcheroo", STATUS), Map.entry("swordsdance", BUFF), Map.entry("synchronoise", DAMAGE), Map.entry("synthesis", HEAL), Map.entry("syrupbomb", DAMAGE), Map.entry("tachyoncutter", DAMAGE), Map.entry("tackle", DAMAGE), Map.entry("tailglow", BUFF), Map.entry("tailslap", DAMAGE), Map.entry("tailwhip", MALUS), Map.entry("tailwind", BUFF), Map.entry("takedown", DAMAGE), Map.entry("takeheart", BUFF), Map.entry("tarshot", MALUS), Map.entry("taunt", STATUS), Map.entry("tearfullook", MALUS), Map.entry("teatime", STATUS), Map.entry("technoblast", DAMAGE), Map.entry("tectonicrage", DAMAGE), Map.entry("teeterdance", STATUS), Map.entry("telekinesis", STATUS), Map.entry("teleport", STATUS), Map.entry("temperflare", DAMAGE), Map.entry("terablast", DAMAGE), Map.entry("terastarstorm", DAMAGE), Map.entry("terrainpulse", DAMAGE), Map.entry("thief", DAMAGE), Map.entry("thousandarrows", DAMAGE), Map.entry("thousandwaves", DAMAGE), Map.entry("thrash", DAMAGE), Map.entry("throatchop", DAMAGE), Map.entry("thunder", DAMAGE), Map.entry("thundercage", DAMAGE), Map.entry("thunderfang", DAMAGE), Map.entry("thunderpunch", DAMAGE), Map.entry("thundershock", DAMAGE), Map.entry("thunderwave", STATUS), Map.entry("thunderbolt", DAMAGE), Map.entry("thunderclap", DAMAGE), Map.entry("thunderouskick", DAMAGE), Map.entry("tickle", MALUS), Map.entry("tidyup", STATUS), Map.entry("topsyturvy", MALUS), Map.entry("torchsong", DAMAGE), Map.entry("torment", STATUS), Map.entry("toxic", STATUS), Map.entry("toxicspikes", STATUS), Map.entry("toxicthread", STATUS), Map.entry("trailblaze", DAMAGE), Map.entry("transform", STATUS), Map.entry("triattack", DAMAGE), Map.entry("trick", STATUS), Map.entry("trickroom", STATUS), Map.entry("trickortreat", STATUS), Map.entry("triplearrows", DAMAGE), Map.entry("tripleaxel", DAMAGE), Map.entry("tripledive", DAMAGE), Map.entry("triplekick", DAMAGE), Map.entry("tropkick", DAMAGE), Map.entry("trumpcard", DAMAGE), Map.entry("twinbeam", DAMAGE), Map.entry("twineedle", DAMAGE), Map.entry("twinkletackle", DAMAGE), Map.entry("twister", DAMAGE), Map.entry("uturn", DAMAGE), Map.entry("upperhand", DAMAGE), Map.entry("uproar", DAMAGE), Map.entry("vcreate", DAMAGE), Map.entry("vacuumwave", DAMAGE), Map.entry("veeveevolley", DAMAGE), Map.entry("venomdrench", MALUS), Map.entry("venoshock", DAMAGE), Map.entry("victorydance", BUFF), Map.entry("vinewhip", DAMAGE), Map.entry("visegrip", DAMAGE), Map.entry("vitalthrow", DAMAGE), Map.entry("voltswitch", DAMAGE), Map.entry("volttackle", DAMAGE), Map.entry("wakeupslap", DAMAGE), Map.entry("watergun", DAMAGE), Map.entry("waterpledge", DAMAGE), Map.entry("waterpulse", DAMAGE), Map.entry("watershuriken", DAMAGE), Map.entry("watersport", STATUS), Map.entry("waterspout", DAMAGE), Map.entry("waterfall", DAMAGE), Map.entry("wavecrash", DAMAGE), Map.entry("weatherball", DAMAGE), Map.entry("whirlpool", DAMAGE), Map.entry("whirlwind", STATUS), Map.entry("wickedblow", DAMAGE), Map.entry("wickedtorque", DAMAGE), Map.entry("wideguard", STATUS), Map.entry("wildcharge", DAMAGE), Map.entry("wildboltstorm", DAMAGE), Map.entry("willowisp", STATUS), Map.entry("wingattack", DAMAGE), Map.entry("wish", HEAL), Map.entry("withdraw", STATUS), Map.entry("wonderroom", STATUS), Map.entry("woodhammer", DAMAGE), Map.entry("workup", BUFF), Map.entry("worryseed", STATUS), Map.entry("wrap", DAMAGE), Map.entry("wringout", DAMAGE), Map.entry("xscissor", DAMAGE), Map.entry("yawn", STATUS), Map.entry("zapcannon", DAMAGE), Map.entry("zenheadbutt", DAMAGE), Map.entry("zingzap", DAMAGE), Map.entry("zippyzap", DAMAGE));
    }

    public static interface Evaluator {
        public double eval(BattlePokemon var1, BattlePokemon var2, Object var3);
    }

    public static interface Handler {
        public void handle(BattlePokemon var1, BattlePokemon var2);
    }
}

