/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.io.IOHelper;

public interface FileSystem {
    public Path parsePath(URI var1);

    public Path parsePath(String var1);

    public void checkAccess(Path var1, Set<? extends AccessMode> var2, LinkOption ... var3) throws IOException;

    public void createDirectory(Path var1, FileAttribute<?> ... var2) throws IOException;

    public void delete(Path var1) throws IOException;

    public SeekableByteChannel newByteChannel(Path var1, Set<? extends OpenOption> var2, FileAttribute<?> ... var3) throws IOException;

    public DirectoryStream<Path> newDirectoryStream(Path var1, DirectoryStream.Filter<? super Path> var2) throws IOException;

    public Path toAbsolutePath(Path var1);

    public Path toRealPath(Path var1, LinkOption ... var2) throws IOException;

    public Map<String, Object> readAttributes(Path var1, String var2, LinkOption ... var3) throws IOException;

    default public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Setting attributes is not supported");
    }

    default public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        IOHelper.copy(source, target, this, options);
    }

    default public void move(Path source, Path target, CopyOption ... options) throws IOException {
        IOHelper.move(source, target, this, options);
    }

    default public void createLink(Path link, Path existing) throws IOException {
        throw new UnsupportedOperationException("Links are not supported");
    }

    default public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException("Links are not supported");
    }

    default public Path readSymbolicLink(Path link) throws IOException {
        throw new UnsupportedOperationException("Links are not supported");
    }

    default public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
        throw new UnsupportedOperationException("Setting current working directory is not supported.");
    }

    default public String getSeparator() {
        return this.parsePath("").getFileSystem().getSeparator();
    }

    default public String getPathSeparator() {
        return File.pathSeparator;
    }

    default public String getMimeType(Path path) {
        Objects.requireNonNull(path);
        return null;
    }

    default public Charset getEncoding(Path path) {
        Objects.requireNonNull(path);
        return null;
    }

    default public Path getTempDirectory() {
        throw new UnsupportedOperationException("Temporary directories not supported");
    }

    default public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
        if (this.toAbsolutePath(path1).equals(this.toAbsolutePath(path2))) {
            return true;
        }
        return this.toRealPath(path1, options).equals(this.toRealPath(path2, options));
    }

    default public long getFileStoreTotalSpace(Path path) throws IOException {
        throw new UnsupportedOperationException("GetFileStoreTotalSpace is not supported");
    }

    default public long getFileStoreUnallocatedSpace(Path path) throws IOException {
        throw new UnsupportedOperationException("GetFileStoreUnallocatedSpace is not supported");
    }

    default public long getFileStoreUsableSpace(Path path) throws IOException {
        throw new UnsupportedOperationException("GetFileStoreUsableSpace is not supported");
    }

    default public long getFileStoreBlockSize(Path path) throws IOException {
        throw new UnsupportedOperationException("GetFileStoreBlockSize is not supported");
    }

    default public boolean isFileStoreReadOnly(Path path) throws IOException {
        throw new UnsupportedOperationException("IsFileStoreReadOnly is not supported");
    }

    public static FileSystem newDefaultFileSystem() {
        return IOHelper.ImplHolder.IMPL.newDefaultFileSystem(System.getProperty("java.io.tmpdir"));
    }

    @Deprecated
    public static FileSystem allowLanguageHomeAccess(FileSystem fileSystem) {
        return FileSystem.allowInternalResourceAccess(fileSystem);
    }

    public static FileSystem allowInternalResourceAccess(FileSystem fileSystem) {
        return IOHelper.ImplHolder.IMPL.allowInternalResourceAccess(fileSystem);
    }

    public static FileSystem newReadOnlyFileSystem(FileSystem fileSystem) {
        return IOHelper.ImplHolder.IMPL.newReadOnlyFileSystem(fileSystem);
    }

    public static FileSystem newFileSystem(java.nio.file.FileSystem fileSystem) {
        return IOHelper.ImplHolder.IMPL.newNIOFileSystem(fileSystem);
    }

    public static FileSystem newDenyIOFileSystem() {
        return IOHelper.ImplHolder.IMPL.newDenyIOFileSystem();
    }

    public static FileSystem newCompositeFileSystem(FileSystem fallbackFileSystem, Selector ... delegates) {
        return IOHelper.ImplHolder.IMPL.newCompositeFileSystem(fallbackFileSystem, delegates);
    }

    public static abstract class Selector
    implements Predicate<Path> {
        private final FileSystem fileSystem;

        protected Selector(FileSystem fileSystem) {
            this.fileSystem = Objects.requireNonNull(fileSystem, "FileSystem must be non-null");
        }

        public final FileSystem getFileSystem() {
            return this.fileSystem;
        }

        @Override
        public abstract boolean test(Path var1);

        public static Selector of(FileSystem fileSystem, final Predicate<Path> predicate) {
            Objects.requireNonNull(predicate, "Predicate must be non-null");
            return new Selector(fileSystem){

                @Override
                public boolean test(Path path) {
                    return predicate.test(path);
                }
            };
        }
    }
}

