/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageSingletons;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.impl.CTypeConversionSupport;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.PointerBase;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.UnsignedWord;

public final class CTypeConversion {
    private CTypeConversion() {
    }

    public static CCharPointerHolder toCString(CharSequence javaString) {
        return ImageSingletons.lookup(CTypeConversionSupport.class).toCString(javaString);
    }

    public static UnsignedWord toCString(CharSequence javaString, CCharPointer buffer, UnsignedWord bufferSize) {
        return ImageSingletons.lookup(CTypeConversionSupport.class).toCString(javaString, buffer, bufferSize);
    }

    public static UnsignedWord toCString(CharSequence javaString, Charset charset, CCharPointer buffer, UnsignedWord bufferSize) {
        return ImageSingletons.lookup(CTypeConversionSupport.class).toCString(javaString, charset, buffer, bufferSize);
    }

    public static String toJavaString(CCharPointer cString) {
        return ImageSingletons.lookup(CTypeConversionSupport.class).toJavaString(cString);
    }

    public static String toJavaString(CCharPointer cString, UnsignedWord length) {
        return ImageSingletons.lookup(CTypeConversionSupport.class).toJavaString(cString, length);
    }

    public static String toJavaString(CCharPointer cString, UnsignedWord length, Charset charset) {
        return ImageSingletons.lookup(CTypeConversionSupport.class).toJavaString(cString, length, charset);
    }

    public static String utf8ToJavaString(CCharPointer utf8String) {
        return ImageSingletons.lookup(CTypeConversionSupport.class).utf8ToJavaString(utf8String);
    }

    public static byte toCBoolean(boolean value) {
        return (byte)(value ? 1 : 0);
    }

    public static boolean toBoolean(int value) {
        return value != 0;
    }

    public static boolean toBoolean(PointerBase pointer) {
        return pointer.isNonNull();
    }

    public static CCharPointerPointerHolder toCStrings(CharSequence[] javaStrings) {
        return ImageSingletons.lookup(CTypeConversionSupport.class).toCStrings(javaStrings);
    }

    public static ByteBuffer asByteBuffer(PointerBase address, int size) {
        return ImageSingletons.lookup(CTypeConversionSupport.class).asByteBuffer(address, size);
    }

    public static CCharPointerHolder toCBytes(byte[] bytes) {
        return ImageSingletons.lookup(CTypeConversionSupport.class).toCBytes(bytes);
    }

    public static interface CCharPointerHolder
    extends AutoCloseable {
        public CCharPointer get();

        @Override
        public void close();
    }

    public static abstract class CCharPointerPointerHolder
    implements AutoCloseable {
        public abstract CCharPointerPointer get();

        @Override
        public abstract void close();
    }
}

