/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.collections;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.LockFreePool;

public class LockFreePrefixTree {
    private final Allocator allocator;
    private volatile Node root;

    public LockFreePrefixTree(Allocator allocator) {
        this.allocator = allocator;
        this.root = allocator.newNode(0L);
    }

    public Allocator allocator() {
        return this.allocator;
    }

    public Node root() {
        return this.root;
    }

    public void reset() {
        this.root = this.allocator.newNode(0L);
    }

    public <C> void topDown(C initialContext, BiFunction<C, Long, C> createContext, BiConsumer<C, Long> consumeValue) {
        this.root.topDown(initialContext, createContext, consumeValue);
    }

    public static abstract class Allocator {
        public abstract Node newNode(long var1);

        public abstract Node.LinearChildren newLinearChildren(int var1);

        public abstract Node.HashChildren newHashChildren(int var1);

        public abstract void shutdown();
    }

    public static class Node
    extends AtomicLong {
        private static final long serialVersionUID = -1L;
        private static final FrozenNode FROZEN_NODE = new FrozenNode();
        private static final int INITIAL_LINEAR_NODE_SIZE = 2;
        private static final int INITIAL_HASH_NODE_SIZE = 16;
        private static final int MAX_LINEAR_NODE_SIZE = 8;
        private static final int MAX_HASH_SKIPS = 10;
        private static final AtomicReferenceFieldUpdater<Node, AtomicReferenceArray> CHILDREN_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Node.class, AtomicReferenceArray.class, "children");
        private long key;
        private volatile AtomicReferenceArray<Node> children;

        private Node(long key) {
            this.key = key;
        }

        private Node() {
            this.key = 0L;
        }

        public long value() {
            return this.get();
        }

        private long getKey() {
            return this.key;
        }

        public void setValue(long value) {
            this.set(value);
        }

        public long incValue() {
            return this.incrementAndGet();
        }

        public long bitwiseOrValue(long pattern) {
            long newValue;
            long oldValue;
            while (!this.compareAndSet(oldValue = this.get(), newValue = oldValue | pattern)) {
            }
            return newValue;
        }

        public Node at(Allocator allocator, long childKey) {
            try {
                this.ensureChildren(allocator);
                while (true) {
                    Node newChild;
                    AtomicReferenceArray<Node> children0;
                    if ((children0 = this.readChildren()) instanceof LinearChildren) {
                        newChild = Node.getOrAddLinear(allocator, childKey, children0);
                        if (newChild != null) {
                            return newChild;
                        }
                        this.tryResizeLinear(allocator, children0);
                        continue;
                    }
                    newChild = Node.getOrAddHash(allocator, childKey, children0);
                    if (newChild != null) {
                        return newChild;
                    }
                    this.tryResizeHash(allocator, children0);
                }
            }
            catch (FailedAllocationException e) {
                return null;
            }
        }

        private static Node getOrAddLinear(Allocator allocator, long childKey, AtomicReferenceArray<Node> childrenArray) {
            for (int i = 0; i < childrenArray.length(); ++i) {
                Node child = Node.read(childrenArray, i);
                if (child == null) {
                    Node newChild = allocator.newNode(childKey);
                    if (Node.cas(childrenArray, i, null, newChild)) {
                        return newChild;
                    }
                    Node child1 = Node.read(childrenArray, i);
                    if (child1.getKey() != childKey) continue;
                    return child1;
                }
                if (child.getKey() != childKey) continue;
                return child;
            }
            return null;
        }

        private void tryResizeLinear(Allocator allocator, AtomicReferenceArray<Node> childrenArray) {
            AtomicReferenceArray newChildrenArray;
            if (childrenArray.length() < 8) {
                newChildrenArray = allocator.newLinearChildren(2 * childrenArray.length());
                for (int i = 0; i < childrenArray.length(); ++i) {
                    Node toCopy = Node.read(childrenArray, i);
                    Node.write(newChildrenArray, i, toCopy);
                }
            } else {
                newChildrenArray = allocator.newHashChildren(16);
                for (int i = 0; i < childrenArray.length(); ++i) {
                    Node toCopy = Node.read(childrenArray, i);
                    Node.addChildToLocalHash(toCopy, newChildrenArray);
                }
            }
            CHILDREN_UPDATER.compareAndSet(this, childrenArray, newChildrenArray);
        }

        private static Node getOrAddHash(Allocator allocator, long childKey, AtomicReferenceArray<Node> hashTable) {
            int index = Node.hash(childKey) % hashTable.length();
            int skips = 0;
            while (true) {
                Node node0;
                if ((node0 = Node.read(hashTable, index)) == null) {
                    Node newNode = allocator.newNode(childKey);
                    if (!Node.cas(hashTable, index, null, newNode)) continue;
                    return newNode;
                }
                if (node0 != FROZEN_NODE && node0.getKey() == childKey) {
                    return node0;
                }
                index = (index + 1) % hashTable.length();
                if (++skips > 10) break;
            }
            return null;
        }

        private static void addChildToLocalHash(Node node, AtomicReferenceArray<Node> hashTable) {
            int index = Node.hash(node.getKey()) % hashTable.length();
            while (Node.read(hashTable, index) != null) {
                index = (index + 1) % hashTable.length();
            }
            Node.write(hashTable, index, node);
        }

        private void tryResizeHash(Allocator allocator, AtomicReferenceArray<Node> children0) {
            Node.freezeHash(children0);
            HashChildren newChildrenHash = allocator.newHashChildren(2 * children0.length());
            for (int i = 0; i < children0.length(); ++i) {
                Node toCopy = Node.read(children0, i);
                if (toCopy == FROZEN_NODE) continue;
                Node.addChildToLocalHash(toCopy, newChildrenHash);
            }
            this.casChildren(children0, newChildrenHash);
        }

        private static void freezeHash(AtomicReferenceArray<Node> childrenHash) {
            for (int i = 0; i < childrenHash.length(); ++i) {
                if (Node.read(childrenHash, i) != null) continue;
                Node.cas(childrenHash, i, null, FROZEN_NODE);
            }
        }

        private static boolean cas(AtomicReferenceArray<Node> childrenArray, int i, Node expected, Node updated) {
            return childrenArray.compareAndSet(i, expected, updated);
        }

        private static Node read(AtomicReferenceArray<Node> childrenArray, int i) {
            return childrenArray.get(i);
        }

        private static void write(AtomicReferenceArray<Node> childrenArray, int i, Node newNode) {
            childrenArray.set(i, newNode);
        }

        private void ensureChildren(Allocator allocator) {
            if (this.readChildren() == null) {
                LinearChildren newChildren = allocator.newLinearChildren(2);
                this.casChildren(null, newChildren);
            }
        }

        private boolean casChildren(AtomicReferenceArray<Node> expected, AtomicReferenceArray<Node> updated) {
            return CHILDREN_UPDATER.compareAndSet(this, expected, updated);
        }

        private AtomicReferenceArray<Node> readChildren() {
            return this.children;
        }

        private static int hash(long key) {
            long v = key * -7046033566014671411L;
            v = Long.reverseBytes(v);
            return Integer.MAX_VALUE & (int)((v *= -7046033566014671411L) ^ v >> 32);
        }

        private <C> void topDown(C currentContext, BiFunction<C, Long, C> createContext, BiConsumer<C, Long> consumeValue) {
            AtomicReferenceArray<Node> childrenSnapshot = this.readChildren();
            consumeValue.accept(currentContext, this.get());
            if (childrenSnapshot == null) {
                return;
            }
            for (int i = 0; i < childrenSnapshot.length(); ++i) {
                Node child = Node.read(childrenSnapshot, i);
                if (child == null || child == FROZEN_NODE) continue;
                long childKey = child.getKey();
                C extendedContext = createContext.apply(currentContext, childKey);
                child.topDown(extendedContext, createContext, consumeValue);
            }
        }

        @Override
        public String toString() {
            return "Node<" + this.value() + ">";
        }

        private static final class LinearChildren
        extends AtomicReferenceArray<Node> {
            private static final long serialVersionUID = -1L;

            LinearChildren(int length) {
                super(length);
            }
        }

        private static final class HashChildren
        extends AtomicReferenceArray<Node> {
            private static final long serialVersionUID = -1L;

            HashChildren(int length) {
                super(length);
            }
        }

        private static final class FrozenNode
        extends Node {
            private static final long serialVersionUID = -1L;

            FrozenNode() {
                super(-1L);
            }
        }
    }

    public static class ObjectPoolingAllocator
    extends Allocator {
        private static final FailedAllocationException FAILED_ALLOCATION_EXCEPTION = new FailedAllocationException();
        private static final FailedAllocationException UNSUPPORTED_SIZE_EXCEPTION = new FailedAllocationException("Only arrays that have power-of-two length can be allocated.");
        private static final FailedAllocationException INTERNAL_FAILURE_EXCEPTION = new FailedAllocationException("Allocation failed due to internal exception.");
        private static final int MIN_HOUSEKEEPING_PERIOD_MILLIS = 4;
        private static final int DEFAULT_HOUSEKEEPING_PERIOD_MILLIS = 72;
        private static final int SIZE_CLASS_COUNT = 27;
        private static final int INITIAL_NODE_PREALLOCATION_COUNT = 4096;
        private static final int INITIAL_LINEAR_CHILDREN_PREALLOCATION_COUNT = 4096;
        private static final int INITIAL_HASH_CHILDREN_PREALLOCATION_COUNT = 256;
        private static final int MAX_NODE_PREALLOCATION_COUNT = 0x400000;
        private static final int MAX_CHILDREN_PREALLOCATION_COUNT = 0x100000;
        private static final int EXPECTED_MAX_HASH_NODE_SIZE = 1024;
        private static final boolean LOGGING = false;
        private final LockFreePool<Node> nodePool = ObjectPoolingAllocator.createNodePool();
        private final LockFreePool<Node.LinearChildren>[] linearChildrenPool = ObjectPoolingAllocator.createLinearChildrenPool();
        private final LockFreePool<Node.HashChildren>[] hashChildrenPool = ObjectPoolingAllocator.createHashChildrenPool();
        private final AtomicInteger missedNodePoolRequestCount = new AtomicInteger(0);
        private final AtomicIntegerArray missedLinearChildrenRequestCounts = new AtomicIntegerArray(27);
        private final AtomicIntegerArray missedHashChildrenRequestCounts = new AtomicIntegerArray(27);
        private final HousekeepingThread housekeepingThread;

        public ObjectPoolingAllocator() {
            this(72);
        }

        public ObjectPoolingAllocator(int housekeepingPeriodMillis) {
            this.housekeepingThread = new HousekeepingThread(housekeepingPeriodMillis);
            this.housekeepingThread.start();
        }

        private static LockFreePool<Node> createNodePool() {
            LockFreePool<Node> pool = new LockFreePool<Node>();
            for (int i = 0; i < 4096; ++i) {
                pool.add(new Node());
            }
            return pool;
        }

        private static LockFreePool<Node.LinearChildren>[] createLinearChildrenPool() {
            LockFreePool[] pools = new LockFreePool[27];
            for (int sizeClass = 0; sizeClass < pools.length; ++sizeClass) {
                pools[sizeClass] = new LockFreePool();
                if (Integer.numberOfTrailingZeros(2) > sizeClass || sizeClass > Integer.numberOfTrailingZeros(8)) continue;
                for (int i = 0; i < 4096; ++i) {
                    pools[sizeClass].add(new Node.LinearChildren(1 << sizeClass));
                }
            }
            return pools;
        }

        private static LockFreePool<Node.HashChildren>[] createHashChildrenPool() {
            LockFreePool[] pools = new LockFreePool[27];
            for (int sizeClass = 0; sizeClass < pools.length; ++sizeClass) {
                pools[sizeClass] = new LockFreePool();
                if (sizeClass < Integer.numberOfTrailingZeros(16) || sizeClass > Integer.numberOfTrailingZeros(1024)) continue;
                for (int i = 0; i < 256; ++i) {
                    pools[sizeClass].add(new Node.HashChildren(1 << sizeClass));
                }
            }
            return pools;
        }

        @Override
        public Node newNode(long key) {
            Node obj = this.nodePool.get();
            if (obj != null) {
                obj.key = key;
                return obj;
            }
            this.missedNodePoolRequestCount.incrementAndGet();
            throw FAILED_ALLOCATION_EXCEPTION;
        }

        @Override
        public Node.LinearChildren newLinearChildren(int length) {
            ObjectPoolingAllocator.checkPowerOfTwo(length);
            if (Integer.numberOfTrailingZeros(length) >= 27) {
                throw FAILED_ALLOCATION_EXCEPTION;
            }
            int sizeClass = Integer.numberOfTrailingZeros(length);
            Node.LinearChildren obj = this.linearChildrenPool[sizeClass].get();
            if (obj != null) {
                return obj;
            }
            if (sizeClass >= this.missedLinearChildrenRequestCounts.length()) {
                throw INTERNAL_FAILURE_EXCEPTION;
            }
            this.missedLinearChildrenRequestCounts.incrementAndGet(sizeClass);
            throw FAILED_ALLOCATION_EXCEPTION;
        }

        @Override
        public Node.HashChildren newHashChildren(int length) {
            ObjectPoolingAllocator.checkPowerOfTwo(length);
            if (Integer.numberOfTrailingZeros(length) >= 27) {
                throw FAILED_ALLOCATION_EXCEPTION;
            }
            int sizeClass = Integer.numberOfTrailingZeros(length);
            Node.HashChildren obj = this.hashChildrenPool[sizeClass].get();
            if (obj != null) {
                return obj;
            }
            if (sizeClass >= this.missedHashChildrenRequestCounts.length()) {
                throw INTERNAL_FAILURE_EXCEPTION;
            }
            this.missedHashChildrenRequestCounts.incrementAndGet(sizeClass);
            throw FAILED_ALLOCATION_EXCEPTION;
        }

        @Override
        public void shutdown() {
            this.housekeepingThread.isEnabled.set(false);
            try {
                this.housekeepingThread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for housekeeping thread shutdown.", e);
            }
        }

        public String status() {
            int sizeClass;
            StringBuilder content = new StringBuilder();
            content.append("ObjectPoolingAllocator").append(System.lineSeparator());
            content.append("======================").append(System.lineSeparator());
            content.append("  current node alloc misses:      ").append(this.missedNodePoolRequestCount.get()).append(System.lineSeparator());
            content.append("  current linear children misses: ").append(System.lineSeparator());
            content.append("    size class ");
            for (sizeClass = 0; sizeClass < 27; ++sizeClass) {
                content.append(String.format("%4d", sizeClass));
            }
            content.append(System.lineSeparator());
            content.append("    miss count ");
            for (sizeClass = 0; sizeClass < 27; ++sizeClass) {
                content.append(String.format("%4d", this.missedLinearChildrenRequestCounts.get(sizeClass)));
            }
            content.append(System.lineSeparator());
            content.append("  current hash children misses: ").append(System.lineSeparator());
            content.append("    size class ");
            for (sizeClass = 0; sizeClass < 27; ++sizeClass) {
                content.append(String.format("%4d", sizeClass));
            }
            content.append(System.lineSeparator());
            content.append("    miss count ");
            for (sizeClass = 0; sizeClass < 27; ++sizeClass) {
                content.append(String.format("%4d", this.missedHashChildrenRequestCounts.get(sizeClass)));
            }
            content.append(System.lineSeparator());
            content.append("  node prealloc growth:           ").append(this.housekeepingThread.nodePreallocationGrowth).append(System.lineSeparator());
            content.append("  linear children prealloc growth:").append(System.lineSeparator());
            content.append("    size class ");
            for (sizeClass = 0; sizeClass < 27; ++sizeClass) {
                content.append(String.format("%4d", sizeClass));
            }
            content.append(System.lineSeparator());
            content.append("    log_2(#)   ");
            for (sizeClass = 0; sizeClass < 27; ++sizeClass) {
                content.append(String.format("%4d", 31 - Integer.numberOfLeadingZeros(this.housekeepingThread.linearChildrenPreallocationGrowth[sizeClass])));
            }
            content.append(System.lineSeparator());
            content.append("  hash children prealloc growth:  ").append(System.lineSeparator());
            content.append("    size class ");
            for (sizeClass = 0; sizeClass < 27; ++sizeClass) {
                content.append(String.format("%4d", sizeClass));
            }
            content.append(System.lineSeparator());
            content.append("    log_2(#)   ");
            for (sizeClass = 0; sizeClass < 27; ++sizeClass) {
                content.append(String.format("%4d", 31 - Integer.numberOfLeadingZeros(this.housekeepingThread.hashChildrenPreallocationGrowth[sizeClass])));
            }
            content.append(System.lineSeparator());
            content.append("  node prealloc total:            ").append(this.housekeepingThread.nodePreallocationTotal).append(System.lineSeparator());
            content.append("  linear children prealloc total: ").append(System.lineSeparator());
            content.append("    size class ");
            for (sizeClass = 0; sizeClass < 27; ++sizeClass) {
                content.append(String.format("%8d", sizeClass));
            }
            content.append(System.lineSeparator());
            content.append("    log_2(#)   ");
            for (sizeClass = 0; sizeClass < 27; ++sizeClass) {
                content.append(String.format(" %7.1e", 1.0 * (double)this.housekeepingThread.linearChildrenPreallocationTotal[sizeClass]));
            }
            content.append(System.lineSeparator());
            content.append("  hash children prealloc total:   ").append(System.lineSeparator());
            content.append("    size class ");
            for (sizeClass = 0; sizeClass < 27; ++sizeClass) {
                content.append(String.format("%8d", sizeClass));
            }
            content.append(System.lineSeparator());
            content.append("    log_2(#)   ");
            for (sizeClass = 0; sizeClass < 27; ++sizeClass) {
                content.append(String.format(" %7.1e", 1.0 * (double)this.housekeepingThread.hashChildrenPreallocationTotal[sizeClass]));
            }
            content.append(System.lineSeparator());
            return content.toString();
        }

        private static void checkPowerOfTwo(int length) {
            if (Integer.bitCount(length) != 1) {
                throw UNSUPPORTED_SIZE_EXCEPTION;
            }
        }

        private static void log(String formatting, int a1) {
        }

        private static void log(String formatting, int a1, int a2) {
        }

        private static void log(String formatting, int a1, int a2, int a3) {
        }

        private class HousekeepingThread
        extends Thread {
            private final AtomicBoolean isEnabled;
            private final int defaultHousekeepingPeriodMillis;
            private int nextHousekeepingPeriodMillis;
            private int nodePreallocationGrowth;
            private final int[] linearChildrenPreallocationGrowth;
            private final int[] hashChildrenPreallocationGrowth;
            private long nodePreallocationTotal;
            private final long[] linearChildrenPreallocationTotal;
            private final long[] hashChildrenPreallocationTotal;

            HousekeepingThread(int defaultHousekeepingPeriodMillis) {
                int sizeClass;
                this.setDaemon(true);
                this.isEnabled = new AtomicBoolean(true);
                this.defaultHousekeepingPeriodMillis = defaultHousekeepingPeriodMillis;
                this.nextHousekeepingPeriodMillis = 4;
                this.nodePreallocationGrowth = 1;
                this.linearChildrenPreallocationGrowth = new int[27];
                for (sizeClass = 0; sizeClass < this.linearChildrenPreallocationGrowth.length; ++sizeClass) {
                    this.linearChildrenPreallocationGrowth[sizeClass] = 1;
                }
                this.hashChildrenPreallocationGrowth = new int[27];
                for (sizeClass = 0; sizeClass < this.hashChildrenPreallocationGrowth.length; ++sizeClass) {
                    this.hashChildrenPreallocationGrowth[sizeClass] = sizeClass < 16 ? 4 : 1;
                }
                this.nodePreallocationTotal = 0L;
                this.linearChildrenPreallocationTotal = new long[27];
                this.hashChildrenPreallocationTotal = new long[27];
            }

            private void housekeep() {
                this.housekeepNodePool();
                this.housekeepLinearChildrenPools();
                this.housekeepHashChildrenPools();
            }

            private void housekeepNodePool() {
                int count = ObjectPoolingAllocator.this.missedNodePoolRequestCount.get();
                if (count > 0) {
                    int growthEstimate = Math.max(4096, count);
                    growthEstimate = Math.max(growthEstimate, this.nodePreallocationGrowth);
                    ObjectPoolingAllocator.log("node prealloc = %d, prealloc growth = %d", growthEstimate, this.nodePreallocationGrowth);
                    for (int i = 0; i < growthEstimate; ++i) {
                        ObjectPoolingAllocator.this.nodePool.add(new Node());
                    }
                    ObjectPoolingAllocator.this.missedNodePoolRequestCount.set(0);
                    this.nextHousekeepingPeriodMillis = 4;
                    this.nodePreallocationGrowth = Math.min(0x400000, this.nodePreallocationGrowth * 2);
                    this.nodePreallocationTotal += (long)growthEstimate;
                }
            }

            private void housekeepLinearChildrenPools() {
                for (int sizeClass = 0; sizeClass < ObjectPoolingAllocator.this.linearChildrenPool.length; ++sizeClass) {
                    int count = ObjectPoolingAllocator.this.missedLinearChildrenRequestCounts.get(sizeClass);
                    if (count <= 0) continue;
                    int growthEstimate = Math.max(4096, count);
                    growthEstimate = Math.max(growthEstimate, this.linearChildrenPreallocationGrowth[sizeClass]);
                    ObjectPoolingAllocator.log("linear size class %d prealloc = %d, prealloc growth = %d", sizeClass, growthEstimate, this.linearChildrenPreallocationGrowth[sizeClass]);
                    for (int i = 0; i < growthEstimate; ++i) {
                        ObjectPoolingAllocator.this.linearChildrenPool[sizeClass].add(new Node.LinearChildren(1 << sizeClass));
                    }
                    ObjectPoolingAllocator.this.missedLinearChildrenRequestCounts.set(sizeClass, 0);
                    this.nextHousekeepingPeriodMillis = 4;
                    this.linearChildrenPreallocationGrowth[sizeClass] = Math.min(0x100000, this.linearChildrenPreallocationGrowth[sizeClass] * 2);
                    int n = sizeClass;
                    this.linearChildrenPreallocationTotal[n] = this.linearChildrenPreallocationTotal[n] + (long)growthEstimate;
                }
            }

            private void housekeepHashChildrenPools() {
                for (int sizeClass = 0; sizeClass < ObjectPoolingAllocator.this.hashChildrenPool.length; ++sizeClass) {
                    int growthEstimate;
                    int count = ObjectPoolingAllocator.this.missedHashChildrenRequestCounts.get(sizeClass);
                    if (count <= 0) continue;
                    if (sizeClass < Integer.numberOfTrailingZeros(1024)) {
                        growthEstimate = Math.max(256, count);
                        growthEstimate = Math.max(growthEstimate, this.hashChildrenPreallocationGrowth[sizeClass]);
                    } else {
                        growthEstimate = count;
                        growthEstimate = Math.max(growthEstimate, this.hashChildrenPreallocationGrowth[sizeClass]);
                    }
                    ObjectPoolingAllocator.log("hash size class %d prealloc = %d, prealloc growth = %d", sizeClass, growthEstimate, this.hashChildrenPreallocationGrowth[sizeClass]);
                    for (int i = 0; i < growthEstimate; ++i) {
                        ObjectPoolingAllocator.this.hashChildrenPool[sizeClass].add(new Node.HashChildren(1 << sizeClass));
                    }
                    ObjectPoolingAllocator.this.missedHashChildrenRequestCounts.set(sizeClass, 0);
                    this.nextHousekeepingPeriodMillis = 4;
                    this.hashChildrenPreallocationGrowth[sizeClass] = Math.min(0x100000, this.hashChildrenPreallocationGrowth[sizeClass] * 2);
                    int n = sizeClass;
                    this.hashChildrenPreallocationTotal[n] = this.hashChildrenPreallocationTotal[n] + (long)growthEstimate;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (this.isEnabled.get()) {
                    try {
                        HousekeepingThread housekeepingThread = this;
                        synchronized (housekeepingThread) {
                            ObjectPoolingAllocator.log("housekeeping thread sleeping... %d ms.", this.nextHousekeepingPeriodMillis);
                            this.wait(this.nextHousekeepingPeriodMillis);
                            this.nextHousekeepingPeriodMillis = Math.min(this.defaultHousekeepingPeriodMillis, this.nextHousekeepingPeriodMillis * 2);
                        }
                        this.housekeep();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Allocator's housekeeping thread was interrupted.", e);
                    }
                }
            }
        }
    }

    public static class HeapAllocator
    extends Allocator {
        @Override
        public Node newNode(long key) {
            return new Node(key);
        }

        @Override
        public Node.LinearChildren newLinearChildren(int length) {
            return new Node.LinearChildren(length);
        }

        @Override
        public Node.HashChildren newHashChildren(int length) {
            return new Node.HashChildren(length);
        }

        @Override
        public void shutdown() {
        }
    }

    private static class FailedAllocationException
    extends RuntimeException {
        private static final long serialVersionUID = -1L;

        FailedAllocationException() {
        }

        FailedAllocationException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

