/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.jfr.impl;

import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Label;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.LanguageInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.jfr.RootFunctionEvent;

abstract class RootFunctionEventImpl
extends Event
implements RootFunctionEvent {
    @Label(value="EngineId")
    @Description(value="Truffle Engine Unique Id")
    public long engineId;
    @Label(value="Id")
    @Description(value="Truffle Compilable Unique Id")
    public long id;
    @Label(value="Source")
    @Description(value="Compiled Source")
    public String source;
    @Label(value="Language")
    @Description(value="Guest Language")
    public String language;
    @Label(value="Root Function")
    @Description(value="Root Function")
    public String rootFunction;

    RootFunctionEventImpl() {
    }

    RootFunctionEventImpl(long engineId, long id, String source, String language, String rootFunction) {
        this.engineId = engineId;
        this.id = id;
        this.source = source;
        this.language = language;
        this.rootFunction = rootFunction;
    }

    @Override
    public void setRootFunction(OptimizedCallTarget target) {
        this.engineId = target.engineId();
        this.id = target.id;
        RootNode rootNode = target.getRootNode();
        this.source = RootFunctionEventImpl.targetName(rootNode);
        LanguageInfo languageInfo = rootNode.getLanguageInfo();
        this.language = languageInfo != null ? languageInfo.getId() : null;
        this.rootFunction = rootNode.getName();
        if (this.rootFunction == null) {
            this.rootFunction = rootNode.toString();
        }
    }

    @Override
    public void publish() {
        this.commit();
    }

    private static String targetName(RootNode rootNode) {
        SourceSection sourceSection = rootNode.getSourceSection();
        if (sourceSection != null && sourceSection.getSource() != null) {
            return sourceSection.getSource().getName() + ":" + sourceSection.getStartLine() + " 0x" + Integer.toHexString(sourceSection.getSource().hashCode());
        }
        return null;
    }
}

