/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot;

import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotVMConfigAccess;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl.Accessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl.ThreadLocalHandshake;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.ModulesSupport;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.HotSpotTruffleRuntime;
import sun.misc.Unsafe;

final class HotSpotThreadLocalHandshake
extends ThreadLocalHandshake {
    private static final Unsafe UNSAFE = HotSpotTruffleRuntime.UNSAFE;
    private static final Accessor.JavaLangSupport JAVA_LANG_SUPPORT = ModulesSupport.getJavaLangSupport();
    static final HotSpotThreadLocalHandshake SINGLETON = new HotSpotThreadLocalHandshake();
    private static final ThreadLocal<ThreadLocalHandshake.TruffleSafepointImpl> STATE = new ThreadLocal();
    private static final int PENDING_OFFSET = HotSpotThreadLocalHandshake.resolveJVMCIReservedLongOffset0();
    private static final long THREAD_EETOP_OFFSET;
    private static final long THREAD_CARRIER_THREAD_OFFSET;

    HotSpotThreadLocalHandshake() {
    }

    @Override
    protected boolean isSupported() {
        return true;
    }

    @Override
    public void ensureThreadInitialized() {
        STATE.set(this.getThreadState(Thread.currentThread()));
    }

    @Override
    public void poll(Node enclosingNode) {
        Thread carrierThread = JAVA_LANG_SUPPORT.currentCarrierThread();
        long eetop = UNSAFE.getLong(carrierThread, THREAD_EETOP_OFFSET);
        if (UNSAFE.getInt(null, eetop + (long)PENDING_OFFSET) != 0) {
            this.processHandshake(enclosingNode);
        }
    }

    static void doHandshake(Object node) {
        SINGLETON.processHandshake((Node)node);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public ThreadLocalHandshake.TruffleSafepointImpl getCurrent() {
        return STATE.get();
    }

    @Override
    protected void clearFastPending() {
        Thread carrierThread = JAVA_LANG_SUPPORT.currentCarrierThread();
        long eetop = UNSAFE.getLongVolatile(carrierThread, THREAD_EETOP_OFFSET);
        UNSAFE.putIntVolatile(null, eetop + (long)PENDING_OFFSET, 0);
    }

    @Override
    protected void setFastPending(Thread thread) {
        assert (thread.isAlive()) : "thread must remain alive while setting the pending flag";
        long eetop = UNSAFE.getLongVolatile(thread, THREAD_EETOP_OFFSET);
        if (eetop != 0L) {
            UNSAFE.putIntVolatile(null, eetop + (long)PENDING_OFFSET, 1);
        } else {
            Object carrierThread = UNSAFE.getObjectVolatile(thread, THREAD_CARRIER_THREAD_OFFSET);
            if (carrierThread == null) {
                return;
            }
            eetop = UNSAFE.getLongVolatile(carrierThread, THREAD_EETOP_OFFSET);
            UNSAFE.putIntVolatile(null, eetop + (long)PENDING_OFFSET, 1);
        }
    }

    static void setPendingFlagForVirtualThread() {
        ThreadLocalHandshake.TruffleSafepointImpl safepoint = STATE.get();
        if (safepoint != null) {
            Thread carrierThread = JAVA_LANG_SUPPORT.currentCarrierThread();
            long eetop = UNSAFE.getLongVolatile(carrierThread, THREAD_EETOP_OFFSET);
            boolean pendingBefore = safepoint.isFastPendingSet();
            UNSAFE.putIntVolatile(null, eetop + (long)PENDING_OFFSET, pendingBefore ? 1 : 0);
            boolean pendingAfter = safepoint.isFastPendingSet();
            if (!pendingBefore && pendingAfter) {
                UNSAFE.putIntVolatile(null, eetop + (long)PENDING_OFFSET, 1);
            }
        }
    }

    static void initializePendingOffset() {
        if (PENDING_OFFSET == -1) {
            throw CompilerDirectives.shouldNotReachHere("This JDK does not have JavaThread::_jvmci_reserved0");
        }
    }

    private static int resolveJVMCIReservedLongOffset0() {
        int longOffset;
        HotSpotVMConfigAccess access = new HotSpotVMConfigAccess(HotSpotJVMCIRuntime.runtime().getConfigStore());
        try {
            longOffset = (Integer)access.getFieldOffset("JavaThread::_jvmci_reserved0", Integer.class, "jlong", (Object)-1);
        }
        catch (NoSuchMethodError error) {
            return -1;
        }
        catch (JVMCIError error) {
            try {
                longOffset = (Integer)access.getFieldOffset("JavaThread::_jvmci_reserved0", Integer.class, "intptr_t*", (Object)-1);
            }
            catch (NoSuchMethodError e) {
                return -1;
            }
        }
        return longOffset;
    }

    static {
        try {
            THREAD_EETOP_OFFSET = HotSpotTruffleRuntime.getObjectFieldOffset(Thread.class.getDeclaredField("eetop"));
            Class<?> virtualThreadClass = Class.forName("java.lang.VirtualThread");
            THREAD_CARRIER_THREAD_OFFSET = HotSpotTruffleRuntime.getObjectFieldOffset(virtualThreadClass.getDeclaredField("carrierThread"));
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }
}

