/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Assumption;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.ReplaceObserver;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.RootCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Truffle;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.MaterializedFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.BlockNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeVisitor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedRuntimeAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedTruffleRuntime;

public final class OptimizedBlockNode<T extends Node>
extends BlockNode<T>
implements ReplaceObserver {
    @CompilerDirectives.CompilationFinal
    private volatile PartialBlocks<T> partialBlocks;
    private final BlockNode.ElementExecutor<T> executor;
    @CompilerDirectives.CompilationFinal
    private volatile Assumption alwaysNoArgument;

    OptimizedBlockNode(T[] elements, BlockNode.ElementExecutor<T> executor) {
        super(elements);
        this.executor = executor;
    }

    @Override
    @ExplodeLoop
    public Object executeGeneric(VirtualFrame frame, int argument) {
        PartialBlocks<T> g;
        int arg = this.profileArg(argument);
        if (CompilerDirectives.inCompiledCode() && (g = this.partialBlocks) != null) {
            return g.execute(frame, arg);
        }
        BlockNode.ElementExecutor<Node> ex = this.executor;
        Node[] e = this.getElements();
        int last = e.length - 1;
        for (int i = 0; i < last; ++i) {
            ex.executeVoid(frame, e[i], i, arg);
        }
        return ex.executeGeneric(frame, e[last], last, arg);
    }

    private int profileArg(int arg) {
        Assumption a = this.alwaysNoArgument;
        if (a == null) {
            if (CompilerDirectives.inInterpreter()) {
                this.alwaysNoArgument = OptimizedBlockNode.makeAlwaysZeroAssumption(arg == 0);
            }
        } else if (a.isValid()) {
            if (arg == 0) {
                return 0;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            a.invalidate();
        }
        return arg;
    }

    private static Assumption makeAlwaysZeroAssumption(boolean valid) {
        if (valid) {
            return Truffle.getRuntime().createAssumption("Always zero block node argument.");
        }
        return Assumption.NEVER_VALID;
    }

    @Override
    @ExplodeLoop
    public void executeVoid(VirtualFrame frame, int argument) {
        PartialBlocks<T> g;
        int arg = this.profileArg(argument);
        if (CompilerDirectives.inCompiledCode() && (g = this.partialBlocks) != null) {
            g.execute(frame, arg);
            return;
        }
        BlockNode.ElementExecutor<Node> ex = this.executor;
        Node[] e = this.getElements();
        for (int i = 0; i < e.length; ++i) {
            ex.executeVoid(frame, e[i], i, arg);
        }
    }

    @Override
    @ExplodeLoop
    public byte executeByte(VirtualFrame frame, int argument) throws UnexpectedResultException {
        PartialBlocks<T> g;
        int arg = this.profileArg(argument);
        if (CompilerDirectives.inCompiledCode() && (g = this.partialBlocks) != null) {
            return g.executeByte(frame, arg);
        }
        BlockNode.ElementExecutor<Node> ex = this.executor;
        Node[] e = this.getElements();
        int last = e.length - 1;
        for (int i = 0; i < last; ++i) {
            ex.executeVoid(frame, e[i], i, arg);
        }
        return ex.executeByte(frame, e[last], last, arg);
    }

    @Override
    @ExplodeLoop
    public short executeShort(VirtualFrame frame, int argument) throws UnexpectedResultException {
        PartialBlocks<T> g;
        int arg = this.profileArg(argument);
        if (CompilerDirectives.inCompiledCode() && (g = this.partialBlocks) != null) {
            return g.executeShort(frame, arg);
        }
        BlockNode.ElementExecutor<Node> ex = this.executor;
        Node[] e = this.getElements();
        int last = e.length - 1;
        for (int i = 0; i < last; ++i) {
            ex.executeVoid(frame, e[i], i, arg);
        }
        return ex.executeShort(frame, e[last], last, arg);
    }

    @Override
    @ExplodeLoop
    public char executeChar(VirtualFrame frame, int argument) throws UnexpectedResultException {
        PartialBlocks<T> g;
        int arg = this.profileArg(argument);
        if (CompilerDirectives.inCompiledCode() && (g = this.partialBlocks) != null) {
            return g.executeChar(frame, arg);
        }
        BlockNode.ElementExecutor<Node> ex = this.executor;
        Node[] e = this.getElements();
        int last = e.length - 1;
        for (int i = 0; i < last; ++i) {
            ex.executeVoid(frame, e[i], i, arg);
        }
        return ex.executeChar(frame, e[last], last, arg);
    }

    @Override
    @ExplodeLoop
    public int executeInt(VirtualFrame frame, int argument) throws UnexpectedResultException {
        PartialBlocks<T> g;
        int arg = this.profileArg(argument);
        if (CompilerDirectives.inCompiledCode() && (g = this.partialBlocks) != null) {
            return g.executeInt(frame, arg);
        }
        BlockNode.ElementExecutor<Node> ex = this.executor;
        Node[] e = this.getElements();
        int last = e.length - 1;
        for (int i = 0; i < last; ++i) {
            ex.executeVoid(frame, e[i], i, arg);
        }
        return ex.executeInt(frame, e[last], last, arg);
    }

    @Override
    @ExplodeLoop
    public long executeLong(VirtualFrame frame, int argument) throws UnexpectedResultException {
        PartialBlocks<T> g;
        int arg = this.profileArg(argument);
        if (CompilerDirectives.inCompiledCode() && (g = this.partialBlocks) != null) {
            return g.executeLong(frame, arg);
        }
        BlockNode.ElementExecutor<Node> ex = this.executor;
        Node[] e = this.getElements();
        int last = e.length - 1;
        for (int i = 0; i < last; ++i) {
            ex.executeVoid(frame, e[i], i, arg);
        }
        return ex.executeLong(frame, e[last], last, arg);
    }

    @Override
    @ExplodeLoop
    public float executeFloat(VirtualFrame frame, int argument) throws UnexpectedResultException {
        PartialBlocks<T> g;
        int arg = this.profileArg(argument);
        if (CompilerDirectives.inCompiledCode() && (g = this.partialBlocks) != null) {
            return g.executeFloat(frame, arg);
        }
        BlockNode.ElementExecutor<Node> ex = this.executor;
        Node[] e = this.getElements();
        int last = e.length - 1;
        for (int i = 0; i < last; ++i) {
            ex.executeVoid(frame, e[i], i, arg);
        }
        return ex.executeFloat(frame, e[last], last, arg);
    }

    @Override
    @ExplodeLoop
    public double executeDouble(VirtualFrame frame, int argument) throws UnexpectedResultException {
        PartialBlocks<T> g;
        int arg = this.profileArg(argument);
        if (CompilerDirectives.inCompiledCode() && (g = this.partialBlocks) != null) {
            return g.executeDouble(frame, arg);
        }
        BlockNode.ElementExecutor<Node> ex = this.executor;
        Node[] e = this.getElements();
        int last = e.length - 1;
        for (int i = 0; i < last; ++i) {
            ex.executeVoid(frame, e[i], i, arg);
        }
        return ex.executeDouble(frame, e[last], last, arg);
    }

    @Override
    @ExplodeLoop
    public boolean executeBoolean(VirtualFrame frame, int argument) throws UnexpectedResultException {
        PartialBlocks<T> g;
        int arg = this.profileArg(argument);
        if (CompilerDirectives.inCompiledCode() && (g = this.partialBlocks) != null) {
            return g.executeBoolean(frame, arg);
        }
        BlockNode.ElementExecutor<Node> ex = this.executor;
        Node[] e = this.getElements();
        int last = e.length - 1;
        for (int i = 0; i < last; ++i) {
            ex.executeVoid(frame, e[i], i, arg);
        }
        return ex.executeBoolean(frame, e[last], last, arg);
    }

    static List<OptimizedCallTarget> preparePartialBlockCompilations(OptimizedCallTarget rootCompilation) {
        int maxBlockSize;
        int nonTrivialNodeCount;
        if (rootCompilation.getOptionValue(OptimizedRuntimeOptions.PartialBlockCompilation).booleanValue() && (nonTrivialNodeCount = rootCompilation.getNonTrivialNodeCount()) > (maxBlockSize = rootCompilation.getOptionValue(OptimizedRuntimeOptions.PartialBlockCompilationSize).intValue())) {
            BlockVisitor visitor = new BlockVisitor(rootCompilation, maxBlockSize);
            NodeUtil.forEachChild(rootCompilation.getRootNode(), visitor);
            return visitor.blockTargets;
        }
        return Collections.emptyList();
    }

    private static <T extends Node> PartialBlocks<T> computePartialBlocks(OptimizedCallTarget rootCompilation, OptimizedBlockNode<T> currentBlock, BlockVisitor visitor, Object[] array, int maxBlockSize) {
        int currentBlockSize = 0;
        int currentBlockIndex = 0;
        int totalCount = 0;
        int[] blockRanges = null;
        int[] blockSizes = null;
        for (int i = 0; i < array.length; ++i) {
            Object child = array[i];
            if (child == null) continue;
            Node childNode = (Node)child;
            int nodeCountBefore = visitor.count;
            visitor.visit(childNode);
            int childCount = visitor.count - nodeCountBefore;
            totalCount += childCount;
            int newBlockSize = currentBlockSize + childCount;
            if (newBlockSize <= maxBlockSize) {
                currentBlockSize = newBlockSize;
                continue;
            }
            if (i > 0) {
                if (blockRanges == null) {
                    blockRanges = new int[8];
                    blockSizes = new int[blockRanges.length + 1];
                } else if (currentBlockIndex >= blockRanges.length) {
                    blockRanges = Arrays.copyOf(blockRanges, blockRanges.length * 2);
                    blockSizes = Arrays.copyOf(blockSizes, blockRanges.length + 1);
                }
                blockSizes[currentBlockIndex] = currentBlockSize;
                blockRanges[currentBlockIndex++] = i;
            }
            currentBlockSize = childCount;
        }
        if (blockRanges != null) {
            blockSizes[currentBlockIndex] = currentBlockSize;
            visitor.count -= totalCount;
            blockRanges = blockRanges.length != currentBlockIndex ? Arrays.copyOf(blockRanges, currentBlockIndex) : blockRanges;
            return new PartialBlocks<T>(rootCompilation, currentBlock, blockRanges, blockSizes, visitor.blockIndex++);
        }
        return null;
    }

    public PartialBlocks<T> getPartialBlocks() {
        return this.partialBlocks;
    }

    @Override
    public boolean nodeReplaced(Node oldNode, Node newNode, CharSequence reason) {
        Node elementParent;
        PartialBlocks<T> blocks = this.partialBlocks;
        if (blocks == null) {
            return false;
        }
        Node element = newNode;
        for (elementParent = element.getParent(); elementParent != this && elementParent != null; elementParent = elementParent.getParent()) {
            element = elementParent;
        }
        if (elementParent != this) {
            assert (false);
            return false;
        }
        int elementIndex = -1;
        Node[] elements = this.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (element != elements[i]) continue;
            elementIndex = i;
            break;
        }
        if (elementIndex == -1) {
            assert (false);
            return false;
        }
        assert (elementIndex < this.getElements().length);
        assert (elementIndex >= 0);
        int foundBlockIndex = Arrays.binarySearch(blocks.blockRanges, elementIndex);
        int callTargetIndex = foundBlockIndex < 0 ? -foundBlockIndex - 1 : foundBlockIndex + 1;
        blocks.blockTargets[callTargetIndex].nodeReplaced(oldNode, newNode, reason);
        return false;
    }

    private void reportBlocksInstalled(CharSequence reason) {
        for (Node node = this.getParent(); node != null; node = node.getParent()) {
            RootCallTarget target;
            boolean consumed = false;
            if (node instanceof ReplaceObserver) {
                consumed = ((ReplaceObserver)((Object)node)).nodeReplaced(this, this, reason);
            } else if (node instanceof RootNode && (target = ((RootNode)node).getCallTarget()) instanceof ReplaceObserver) {
                consumed = ((ReplaceObserver)((Object)target)).nodeReplaced(this, this, reason);
            }
            if (consumed) break;
        }
    }

    public static final class PartialBlocks<T extends Node> {
        final OptimizedBlockNode<?> block;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final OptimizedCallTarget[] blockTargets;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final int[] blockRanges;

        PartialBlocks(OptimizedCallTarget rootCompilation, OptimizedBlockNode<T> block, int[] blockRanges, int[] blockSizes, int blockIndex) {
            assert (blockRanges.length > 0);
            this.block = block;
            this.blockRanges = blockRanges;
            RootNode rootNode = rootCompilation.getRootNode();
            assert (rootNode == block.getRootNode());
            OptimizedTruffleRuntime runtime = OptimizedTruffleRuntime.getRuntime();
            Class<?> materializedFrameClass = runtime.createMaterializedFrame(new Object[0]).getClass();
            FrameDescriptor descriptor = rootNode.getFrameDescriptor();
            runtime.markFrameMaterializeCalled(descriptor);
            int startIndex = 0;
            OptimizedCallTarget[] targets = new OptimizedCallTarget[blockRanges.length + 1];
            for (int i = 0; i < targets.length; ++i) {
                int endIndex = i < blockRanges.length ? blockRanges[i] : block.getElements().length;
                PartialBlockRootNode<T> partialRootNode = new PartialBlockRootNode<T>(new FrameDescriptor(), block, startIndex, endIndex, blockIndex);
                OptimizedRuntimeAccessor.NODES.applySharingLayer(rootNode, partialRootNode);
                targets[i] = (OptimizedCallTarget)partialRootNode.getCallTarget();
                targets[i].setNonTrivialNodeCount(blockSizes[i]);
                targets[i].initializeUnsafeArgumentTypes(new Class[]{materializedFrameClass, Integer.class});
                targets[i].setSpeculationLog(rootCompilation.getSpeculationLog());
                startIndex = endIndex;
            }
            this.blockTargets = targets;
        }

        public OptimizedCallTarget[] getBlockTargets() {
            return this.blockTargets;
        }

        public int[] getBlockRanges() {
            return this.blockRanges;
        }

        int executeInt(VirtualFrame frame, int arg) throws UnexpectedResultException {
            Object result = this.execute(frame, arg);
            if (result instanceof Integer) {
                return (Integer)result;
            }
            throw new UnexpectedResultException(result);
        }

        byte executeByte(VirtualFrame frame, int arg) throws UnexpectedResultException {
            Object result = this.execute(frame, arg);
            if (result instanceof Byte) {
                return (Byte)result;
            }
            throw new UnexpectedResultException(result);
        }

        short executeShort(VirtualFrame frame, int arg) throws UnexpectedResultException {
            Object result = this.execute(frame, arg);
            if (result instanceof Short) {
                return (Short)result;
            }
            throw new UnexpectedResultException(result);
        }

        long executeLong(VirtualFrame frame, int arg) throws UnexpectedResultException {
            Object result = this.execute(frame, arg);
            if (result instanceof Long) {
                return (Long)result;
            }
            throw new UnexpectedResultException(result);
        }

        char executeChar(VirtualFrame frame, int arg) throws UnexpectedResultException {
            Object result = this.execute(frame, arg);
            if (result instanceof Character) {
                return ((Character)result).charValue();
            }
            throw new UnexpectedResultException(result);
        }

        float executeFloat(VirtualFrame frame, int arg) throws UnexpectedResultException {
            Object result = this.execute(frame, arg);
            if (result instanceof Float) {
                return ((Float)result).floatValue();
            }
            throw new UnexpectedResultException(result);
        }

        double executeDouble(VirtualFrame frame, int arg) throws UnexpectedResultException {
            Object result = this.execute(frame, arg);
            if (result instanceof Double) {
                return (Double)result;
            }
            throw new UnexpectedResultException(result);
        }

        boolean executeBoolean(VirtualFrame frame, int arg) throws UnexpectedResultException {
            Object result = this.execute(frame, arg);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            throw new UnexpectedResultException(result);
        }

        @ExplodeLoop
        Object execute(VirtualFrame frame, int arg) {
            Object[] arguments = new Object[]{frame.materialize(), arg};
            int[] ranges = this.blockRanges;
            OptimizedCallTarget[] targets = this.blockTargets;
            for (int i = 0; i < ranges.length; ++i) {
                targets[i].doInvoke(arguments);
            }
            return targets[ranges.length].doInvoke(arguments);
        }
    }

    static final class BlockVisitor
    implements NodeVisitor {
        final List<OptimizedCallTarget> blockTargets = new ArrayList<OptimizedCallTarget>();
        final OptimizedCallTarget rootCompilation;
        final int maxBlockSize;
        int blockIndex;
        int count;

        BlockVisitor(OptimizedCallTarget rootCompilation, int maxBlockSize) {
            this.rootCompilation = rootCompilation;
            this.maxBlockSize = maxBlockSize;
        }

        @Override
        public boolean visit(Node node) {
            ++this.count;
            if (node instanceof BlockNode) {
                this.computeBlock((OptimizedBlockNode)node);
            } else {
                NodeUtil.forEachChild(node, this);
            }
            return true;
        }

        private <T extends Node> void computeBlock(final OptimizedBlockNode<T> blockNode) {
            Object[] children = blockNode.getElements();
            PartialBlocks<T> oldBlocks = blockNode.getPartialBlocks();
            final PartialBlocks<T> newBlocks = oldBlocks == null ? OptimizedBlockNode.computePartialBlocks(this.rootCompilation, blockNode, this, children, this.maxBlockSize) : oldBlocks;
            if (oldBlocks == null) {
                blockNode.atomic(new Runnable(){
                    final /* synthetic */ BlockVisitor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        PartialBlocks otherOldBlocks = blockNode.getPartialBlocks();
                        if (otherOldBlocks == null) {
                            blockNode.partialBlocks = newBlocks;
                            blockNode.reportBlocksInstalled("Partial blocks installed");
                        }
                    }
                });
            }
            if (newBlocks != null) {
                this.blockTargets.addAll(Arrays.asList(newBlocks.blockTargets));
            }
        }
    }

    static final class PartialBlockRootNode<T extends Node>
    extends RootNode {
        private final OptimizedBlockNode<T> block;
        private final int startIndex;
        private final int endIndex;
        private final int blockIndex;
        private SourceSection cachedSourceSection;

        PartialBlockRootNode(FrameDescriptor descriptor, OptimizedBlockNode<T> block, int startIndex, int endIndex, int blockIndex) {
            super(null, descriptor);
            this.block = block;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.blockIndex = blockIndex;
            assert (startIndex != endIndex) : "no empty blocks allowed";
        }

        @Override
        public boolean isCloningAllowed() {
            return false;
        }

        @Override
        public String getName() {
            return this.computeName(this.block.getRootNode().getName());
        }

        @Override
        public boolean isInternal() {
            return true;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public SourceSection getSourceSection() {
            SourceSection section = this.cachedSourceSection;
            if (section == null) {
                Node[] elements = this.block.getElements();
                SourceSection startSection = elements[this.startIndex].getSourceSection();
                SourceSection endSection = elements[this.endIndex - 1].getSourceSection();
                section = startSection != null && endSection != null && startSection.getSource().equals(endSection.getSource()) ? (startSection.getCharIndex() <= endSection.getCharEndIndex() ? startSection.getSource().createSection(startSection.getStartLine(), startSection.getStartColumn(), endSection.getEndLine(), endSection.getEndColumn()) : startSection) : (startSection != null ? startSection : endSection);
                this.cachedSourceSection = section;
            }
            return section;
        }

        @Override
        public String getQualifiedName() {
            return this.computeName(this.block.getRootNode().getQualifiedName());
        }

        private String computeName(String name) {
            StringBuilder blockIndices = new StringBuilder();
            for (Node parent = this.block.getParent(); parent != null; parent = parent.getParent()) {
                PartialBlocks blocks;
                if (!(parent instanceof OptimizedBlockNode) || (blocks = ((OptimizedBlockNode)parent).getPartialBlocks()) == null) continue;
                blockIndices.append(((PartialBlockRootNode)blocks.getBlockTargets()[0].getRootNode()).blockIndex);
                blockIndices.append(":");
            }
            blockIndices.append(this.blockIndex);
            String suffix = "<Partial-" + String.valueOf(blockIndices) + "-range:" + this.startIndex + ":" + this.endIndex + ">";
            if (name == null) {
                return suffix;
            }
            return name + suffix;
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            Object[] arguments = frame.getArguments();
            MaterializedFrame outerFrame = (MaterializedFrame)arguments[0];
            int arg = this.readAndProfileArg(arguments);
            BlockNode.ElementExecutor<Node> ex = this.block.executor;
            Node[] e = this.block.getElements();
            int last = this.endIndex - 1;
            for (int i = this.startIndex; i < last; ++i) {
                ex.executeVoid(outerFrame, e[i], i, arg);
            }
            if (last == this.block.getElements().length - 1) {
                return ex.executeGeneric(outerFrame, e[last], last, arg);
            }
            ex.executeVoid(outerFrame, e[last], last, arg);
            return null;
        }

        private int readAndProfileArg(Object[] arguments) {
            Assumption alwaysNoArgument = this.block.alwaysNoArgument;
            if (alwaysNoArgument != null && alwaysNoArgument.isValid()) {
                return 0;
            }
            return (Integer)arguments[1];
        }

        @Override
        public String toString() {
            return this.getQualifiedName();
        }
    }
}

