/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Truffle;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.AbstractCompilationTask;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.BackgroundCompileQueue;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.EngineData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedTruffleRuntime;

public final class CompilationTask
extends AbstractCompilationTask
implements Callable<Void>,
Comparable<CompilationTask> {
    private static final Consumer<CompilationTask> COMPILATION_ACTION = new Consumer<CompilationTask>(){

        @Override
        public void accept(CompilationTask task) {
            OptimizedCallTarget callTarget = (OptimizedCallTarget)task.targetRef.get();
            if (callTarget != null && task.start()) {
                try {
                    ((OptimizedTruffleRuntime)Truffle.getRuntime()).doCompile(callTarget, task);
                }
                finally {
                    callTarget.compiledTier(task.tier());
                    task.finished();
                }
            }
        }
    };
    final WeakReference<OptimizedCallTarget> targetRef;
    private final BackgroundCompileQueue.Priority priority;
    private final long id;
    private final Consumer<CompilationTask> action;
    private final EngineData engineData;
    private volatile Future<?> future;
    private volatile boolean cancelled;
    volatile BooleanSupplier cancelledPredicate;
    private volatile boolean started;
    private int lastCount;
    private long lastTime;
    private double lastWeight;
    private boolean isOSR;
    private double lastRate;
    private long time;
    private int queueChange;
    private static final double EPSILON = 1.0E-6;

    private CompilationTask(BackgroundCompileQueue.Priority priority, WeakReference<OptimizedCallTarget> targetRef, Consumer<CompilationTask> action, long id) {
        this.priority = priority;
        this.targetRef = targetRef;
        this.action = action;
        this.id = id;
        this.lastWeight = -1.0;
        this.lastTime = System.nanoTime();
        OptimizedCallTarget target = (OptimizedCallTarget)targetRef.get();
        if (target == null) {
            this.lastCount = Integer.MIN_VALUE;
            this.engineData = null;
            this.isOSR = false;
            this.cancelledPredicate = null;
        } else {
            this.lastCount = target.getCallAndLoopCount();
            this.engineData = target.engine;
            this.isOSR = target.isOSR();
            this.cancelledPredicate = target.engine.cancelledPredicate;
        }
    }

    static CompilationTask createInitializationTask(WeakReference<OptimizedCallTarget> targetRef, Consumer<CompilationTask> action) {
        return new CompilationTask(BackgroundCompileQueue.Priority.INITIALIZATION, targetRef, action, 0L);
    }

    static CompilationTask createCompilationTask(BackgroundCompileQueue.Priority priority, WeakReference<OptimizedCallTarget> targetRef, long id) {
        return new CompilationTask(priority, targetRef, COMPILATION_ACTION, id);
    }

    public void awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this.future.get(timeout, unit);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void awaitCompletion() throws ExecutionException, InterruptedException {
        try {
            this.future.get();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public synchronized boolean cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            if (!this.started) {
                this.future.cancel(false);
                this.finished();
            }
            return true;
        }
        return false;
    }

    void reset() {
        this.cancelled = false;
    }

    public void finished() {
        OptimizedCallTarget target = (OptimizedCallTarget)this.targetRef.get();
        if (target != null) {
            target.resetCompilationTask();
        }
    }

    public synchronized boolean start() {
        assert (!this.started) : "Should not start a stared task";
        if (this.cancelled) {
            return false;
        }
        this.started = true;
        return true;
    }

    @Override
    public boolean isCancelled() {
        BooleanSupplier cancelPredicate = this.cancelledPredicate;
        return this.cancelled || cancelPredicate != null && cancelPredicate.getAsBoolean();
    }

    @Override
    public boolean isLastTier() {
        return this.priority.tier == BackgroundCompileQueue.Priority.Tier.LAST;
    }

    @Override
    public boolean hasNextTier() {
        if (this.isLastTier()) {
            return false;
        }
        OptimizedCallTarget callTarget = (OptimizedCallTarget)this.targetRef.get();
        if (callTarget == null) {
            return false;
        }
        return !callTarget.engine.firstTierOnly;
    }

    public Future<?> getFuture() {
        return this.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFuture(Future<?> future) {
        CompilationTask compilationTask = this;
        synchronized (compilationTask) {
            if (this.future != null) {
                throw new IllegalStateException("The future should not be re-set.");
            }
            this.future = future;
        }
    }

    public String toString() {
        return "Task[id=" + this.id + ", tier=" + String.valueOf((Object)this.priority.tier) + ", weight=" + this.lastWeight + "]";
    }

    private boolean priorityQueueEnabled() {
        if (this.engineData == null) {
            return false;
        }
        return this.engineData.priorityQueue && (this.engineData.multiTier && this.priority.tier == BackgroundCompileQueue.Priority.Tier.FIRST || !this.engineData.multiTier && this.priority.tier == BackgroundCompileQueue.Priority.Tier.LAST);
    }

    @Override
    public int compareTo(CompilationTask that) {
        int valueCompare;
        int tierCompare = this.priority.tier.compareTo(that.priority.tier);
        if (tierCompare != 0) {
            return tierCompare;
        }
        if (this.priorityQueueEnabled() && (valueCompare = -1 * Long.compare(this.priority.value, that.priority.value)) != 0) {
            return valueCompare;
        }
        return Long.compare(this.id, that.id);
    }

    @Override
    public Void call() throws Exception {
        this.action.accept(this);
        return null;
    }

    boolean isHigherPriorityThan(CompilationTask other) {
        if (this.action != COMPILATION_ACTION || other.action != COMPILATION_ACTION) {
            return this.action != COMPILATION_ACTION;
        }
        int tier = this.tier();
        if (this.engineData.traversingFirstTierPriority && tier != other.tier()) {
            return tier < other.tier();
        }
        if (this.engineData.weightingBothTiers || this.isFirstTier()) {
            return this.lastWeight > other.lastWeight;
        }
        return false;
    }

    boolean updateWeight(long currentTime) {
        OptimizedCallTarget target = (OptimizedCallTarget)this.targetRef.get();
        if (target == null) {
            return false;
        }
        long elapsed = currentTime - this.lastTime;
        if (this.lastWeight > 0.0 && elapsed < 1000000L || elapsed < 0L) {
            return true;
        }
        int count = target.getCallAndLoopCount();
        this.lastRate = this.rate(count, elapsed);
        this.lastTime = currentTime;
        this.lastCount = count;
        double weight = (1.0 + this.lastRate) * (double)this.lastCount;
        assert (weight >= 0.0) : "weight must be positive";
        this.lastWeight = weight * this.bonus();
        return true;
    }

    private double bonus() {
        double bonus = 1.0;
        if (!this.engineData.traversingFirstTierPriority && this.isFirstTier()) {
            bonus *= this.engineData.traversingFirstTierBonus;
        }
        if (this.targetHighestCompiledTier() >= this.tier()) {
            bonus *= this.engineData.traversingInvalidatedBonus;
        }
        if (this.isOSR) {
            bonus *= this.engineData.traversingOSRBonus;
        }
        return bonus;
    }

    public List<String> bonusDescriptors() {
        ArrayList<String> bonuses = new ArrayList<String>(3);
        if (!this.engineData.traversingFirstTierPriority && this.isFirstTier() && CompilationTask.hasEffect(this.engineData.traversingFirstTierBonus)) {
            bonuses.add("first tier");
        }
        if (this.targetHighestCompiledTier() >= this.tier() && CompilationTask.hasEffect(this.engineData.traversingInvalidatedBonus)) {
            bonuses.add("invalidation");
        }
        if (this.isOSR && CompilationTask.hasEffect(this.engineData.traversingOSRBonus)) {
            bonuses.add("OSR");
        }
        return bonuses;
    }

    private static boolean hasEffect(double bonus) {
        return Math.abs(bonus - 1.0) > 1.0E-6;
    }

    private double rate(int count, long elapsed) {
        this.lastRate = ((double)count - (double)this.lastCount) / (double)Math.max(elapsed, 1000L);
        return this.lastRate;
    }

    public int targetHighestCompiledTier() {
        OptimizedCallTarget target = (OptimizedCallTarget)this.targetRef.get();
        if (target == null) {
            return -1;
        }
        return target.highestCompiledTier();
    }

    public long time() {
        return this.time;
    }

    public double weight() {
        return this.lastWeight;
    }

    public double rate() {
        return this.lastRate;
    }

    public int queueChange() {
        return this.queueChange;
    }

    void setTime(long time) {
        this.time = time;
    }

    void setQueueChange(int queueChange) {
        this.queueChange = queueChange;
    }

    public static class ExecutorServiceWrapper
    extends FutureTask<Void>
    implements Comparable<ExecutorServiceWrapper> {
        final CompilationTask compileTask;

        ExecutorServiceWrapper(CompilationTask compileTask) {
            super(compileTask);
            this.compileTask = compileTask;
        }

        @Override
        public int compareTo(ExecutorServiceWrapper that) {
            return this.compileTask.compareTo(that.compileTask);
        }

        @Override
        public String toString() {
            return "ExecutorServiceWrapper(" + String.valueOf(this.compileTask) + ")";
        }

        public CompilationTask getCompileTask() {
            return this.compileTask;
        }
    }
}

