/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.CompilationTask;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.DynamicThresholdsQueue;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.EngineData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedRuntimeAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.TraversingBlockingQueue;

public class BackgroundCompileQueue {
    protected final OptimizedTruffleRuntime runtime;
    private final AtomicLong idCounter;
    private volatile TruffleThreadPoolExecutor executor;
    private boolean shutdown = false;
    private long delayMillis;

    public BackgroundCompileQueue(OptimizedTruffleRuntime runtime) {
        this.runtime = runtime;
        this.idCounter = new AtomicLong();
    }

    private static int log2(int n) {
        assert (n > 0);
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService(OptimizedCallTarget callTarget) {
        TruffleThreadPoolExecutor service = this.executor;
        if (service != null) {
            return service;
        }
        BackgroundCompileQueue backgroundCompileQueue = this;
        synchronized (backgroundCompileQueue) {
            service = this.executor;
            if (service != null) {
                return service;
            }
            if (this.shutdown) {
                throw new RejectedExecutionException("The BackgroundCompileQueue is shutdown");
            }
            this.delayMillis = callTarget.getOptionValue(OptimizedRuntimeOptions.EncodedGraphCachePurgeDelay).intValue();
            int threads = callTarget.getOptionValue(OptimizedRuntimeOptions.CompilerThreads);
            if (threads == 0) {
                availableProcessors = Runtime.getRuntime().availableProcessors();
                if (availableProcessors >= 4) {
                    threads = 2;
                }
            } else if (threads < 0) {
                availableProcessors = Runtime.getRuntime().availableProcessors();
                int logCPU = BackgroundCompileQueue.log2(availableProcessors);
                int loglogCPU = BackgroundCompileQueue.log2(Math.max(logCPU, 1));
                threads = Math.min(availableProcessors / 4 + loglogCPU, 16);
            }
            threads = Math.max(1, threads);
            ThreadFactory factory = this.newThreadFactory("TruffleCompilerThread", callTarget);
            long compilerIdleDelay = this.runtime.getCompilerIdleDelay(callTarget);
            long keepAliveTime = compilerIdleDelay >= 0L ? compilerIdleDelay : 0L;
            BlockingQueue<Runnable> queue = this.createQueue(callTarget, threads);
            TruffleThreadPoolExecutor threadPoolExecutor = new TruffleThreadPoolExecutor(threads, threads, keepAliveTime, TimeUnit.MILLISECONDS, queue, factory);
            if (compilerIdleDelay > 0L) {
                threadPoolExecutor.allowCoreThreadTimeOut(true);
            }
            this.executor = threadPoolExecutor;
            return this.executor;
        }
    }

    private BlockingQueue<Runnable> createQueue(OptimizedCallTarget callTarget, int threads) {
        if (callTarget.getOptionValue(OptimizedRuntimeOptions.TraversingCompilationQueue).booleanValue()) {
            if (callTarget.getOptionValue(OptimizedRuntimeOptions.DynamicCompilationThresholds).booleanValue() && callTarget.getOptionValue(OptimizedRuntimeOptions.BackgroundCompilation).booleanValue()) {
                double minScale = callTarget.getOptionValue(OptimizedRuntimeOptions.DynamicCompilationThresholdsMinScale);
                int minNormalLoad = callTarget.getOptionValue(OptimizedRuntimeOptions.DynamicCompilationThresholdsMinNormalLoad);
                int maxNormalLoad = callTarget.getOptionValue(OptimizedRuntimeOptions.DynamicCompilationThresholdsMaxNormalLoad);
                return new DynamicThresholdsQueue(threads, minScale, minNormalLoad, maxNormalLoad, new IdlingLinkedBlockingDeque<Runnable>());
            }
            return new TraversingBlockingQueue(new IdlingLinkedBlockingDeque<Runnable>());
        }
        return new IdlingPriorityBlockingQueue<Runnable>();
    }

    protected ThreadFactory newThreadFactory(String threadNamePrefix, OptimizedCallTarget callTarget) {
        return new TruffleCompilerThreadFactory(threadNamePrefix, this.runtime);
    }

    private CompilationTask submitTask(CompilationTask compilationTask, OptimizedCallTarget target) {
        ExecutorService e = this.getExecutorService(target);
        compilationTask.setFuture(e.submit(compilationTask));
        return compilationTask;
    }

    public CompilationTask submitCompilation(Priority priority, OptimizedCallTarget target) {
        WeakReference<OptimizedCallTarget> targetReference = new WeakReference<OptimizedCallTarget>(target);
        CompilationTask compilationTask = CompilationTask.createCompilationTask(priority, targetReference, this.nextId());
        return this.submitTask(compilationTask, target);
    }

    public CompilationTask submitInitialization(OptimizedCallTarget target, Consumer<CompilationTask> action) {
        WeakReference<OptimizedCallTarget> targetReference = new WeakReference<OptimizedCallTarget>(target);
        CompilationTask initializationTask = CompilationTask.createInitializationTask(targetReference, action);
        return this.submitTask(initializationTask, target);
    }

    private long nextId() {
        return this.idCounter.getAndIncrement();
    }

    public final void flush(EngineData engine) {
        TruffleThreadPoolExecutor e = this.executor;
        if (e == null) {
            return;
        }
        e.flush(engine);
    }

    public int getQueueSize() {
        TruffleThreadPoolExecutor threadPool = this.executor;
        if (threadPool != null) {
            return threadPool.getQueue().size();
        }
        return 0;
    }

    public Collection<OptimizedCallTarget> getQueuedTargets(EngineData engine) {
        TruffleThreadPoolExecutor e = this.executor;
        if (e == null) {
            return List.of();
        }
        return e.getQueuedTargets(engine);
    }

    public Collection<OptimizedCallTarget> getAllTargets(EngineData engine) {
        TruffleThreadPoolExecutor e = this.executor;
        if (e == null) {
            return List.of();
        }
        return e.getAllTargets(engine);
    }

    public void shutdownAndAwaitTermination(long timeout) {
        this.flush(null);
        this.shutdownNow();
        this.awaitTermination(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownNow() {
        TruffleThreadPoolExecutor e = this.executor;
        if (e == null) {
            BackgroundCompileQueue backgroundCompileQueue = this;
            synchronized (backgroundCompileQueue) {
                e = this.executor;
                if (e == null) {
                    this.shutdown = true;
                    return;
                }
            }
        }
        e.shutdownNow();
    }

    private void awaitTermination(long timeout) {
        TruffleThreadPoolExecutor e = this.executor;
        if (e == null) {
            return;
        }
        try {
            e.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Waiting for compiler threads was interrupted.", ex);
        }
    }

    protected void notifyIdleCompilerThread() {
    }

    private static final class TruffleThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final Set<CompilationTask.ExecutorServiceWrapper> allTargets = ConcurrentHashMap.newKeySet();

        private TruffleThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        void flush(EngineData engine) {
            for (OptimizedCallTarget target : this.getAllTargets(engine)) {
                target.cancelCompilation("Polyglot engine was closed.");
            }
        }

        Collection<OptimizedCallTarget> getQueuedTargets(EngineData engine) {
            return TruffleThreadPoolExecutor.extractTargets(engine, (CompilationTask.ExecutorServiceWrapper[])this.getQueue().toArray(CompilationTask.ExecutorServiceWrapper[]::new));
        }

        Collection<OptimizedCallTarget> getAllTargets(EngineData engine) {
            return TruffleThreadPoolExecutor.extractTargets(engine, (CompilationTask.ExecutorServiceWrapper[])this.allTargets.toArray(CompilationTask.ExecutorServiceWrapper[]::new));
        }

        private static Collection<OptimizedCallTarget> extractTargets(EngineData engine, CompilationTask.ExecutorServiceWrapper[] serviceWrappers) {
            ArrayList<OptimizedCallTarget> queuedTargets = new ArrayList<OptimizedCallTarget>();
            for (CompilationTask.ExecutorServiceWrapper wrapper : serviceWrappers) {
                OptimizedCallTarget target = (OptimizedCallTarget)wrapper.compileTask.targetRef.get();
                if (target == null || engine != null && target.engine != engine) continue;
                queuedTargets.add(target);
            }
            return Collections.unmodifiableCollection(queuedTargets);
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
            CompilationTask.ExecutorServiceWrapper wrapper = new CompilationTask.ExecutorServiceWrapper((CompilationTask)callable);
            this.allTargets.add(wrapper);
            return wrapper;
        }

        @Override
        public boolean remove(Runnable task) {
            this.allTargets.remove(task);
            return super.remove(task);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            this.allTargets.remove(r);
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            ThreadFactory threadFactory = this.getThreadFactory();
            if (threadFactory instanceof JoinableThreadFactory) {
                return ((JoinableThreadFactory)threadFactory).joinOtherThreads(timeout, unit);
            }
            return super.awaitTermination(timeout, unit);
        }
    }

    private final class IdlingLinkedBlockingDeque<E>
    extends LinkedBlockingDeque<E> {
        private IdlingLinkedBlockingDeque() {
        }

        @Override
        public E takeFirst() throws InterruptedException {
            while (!BackgroundCompileQueue.this.executor.allowsCoreThreadTimeOut()) {
                Object elem = this.poll(BackgroundCompileQueue.this.delayMillis, TimeUnit.MILLISECONDS);
                if (elem == null) {
                    BackgroundCompileQueue.this.notifyIdleCompilerThread();
                    continue;
                }
                return elem;
            }
            return super.take();
        }

        @Override
        public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
            long timeoutMillis = unit.toMillis(timeout);
            if (timeoutMillis < BackgroundCompileQueue.this.delayMillis) {
                return super.pollFirst(timeout, unit);
            }
            while (timeoutMillis > BackgroundCompileQueue.this.delayMillis) {
                Object elem = super.pollFirst(BackgroundCompileQueue.this.delayMillis, TimeUnit.MILLISECONDS);
                if (elem != null) {
                    return elem;
                }
                BackgroundCompileQueue.this.notifyIdleCompilerThread();
                timeoutMillis -= BackgroundCompileQueue.this.delayMillis;
            }
            return super.pollFirst(timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    private final class IdlingPriorityBlockingQueue<E>
    extends PriorityBlockingQueue<E> {
        private IdlingPriorityBlockingQueue() {
        }

        @Override
        public E take() throws InterruptedException {
            while (!BackgroundCompileQueue.this.executor.allowsCoreThreadTimeOut()) {
                Object elem = this.poll(BackgroundCompileQueue.this.delayMillis, TimeUnit.MILLISECONDS);
                if (elem == null) {
                    BackgroundCompileQueue.this.notifyIdleCompilerThread();
                    continue;
                }
                return elem;
            }
            return super.take();
        }
    }

    private final class TruffleCompilerThreadFactory
    implements JoinableThreadFactory {
        private final String namePrefix;
        private final OptimizedTruffleRuntime runtime;
        private final Set<Thread> threads = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

        TruffleCompilerThreadFactory(String namePrefix, OptimizedTruffleRuntime runtime) {
            this.namePrefix = namePrefix;
            this.runtime = runtime;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r){

                @Override
                public void run() {
                    this.setContextClassLoader(this.getClass().getClassLoader());
                    try (AutoCloseable compilerThreadScope = TruffleCompilerThreadFactory.this.runtime.openCompilerThreadScope();
                         AutoCloseable polyglotThreadScope = OptimizedRuntimeAccessor.ENGINE.createPolyglotThreadScope();){
                        super.run();
                        if (BackgroundCompileQueue.this.executor.allowsCoreThreadTimeOut()) {
                            BackgroundCompileQueue.this.notifyIdleCompilerThread();
                        }
                    }
                    catch (Exception e) {
                        throw new InternalError(e);
                    }
                }
            };
            t.setName(this.namePrefix + "-" + t.getId());
            t.setPriority(10);
            t.setDaemon(true);
            this.threads.add(t);
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean joinOtherThreads(long timeout, TimeUnit unit) throws InterruptedException {
            long timeoutNanos = unit.toNanos(timeout);
            Set<Thread> set = this.threads;
            synchronized (set) {
                if (this.threads.contains(Thread.currentThread())) {
                    Thread.interrupted();
                }
                for (Thread thread : this.threads) {
                    if (thread == Thread.currentThread()) continue;
                    long joinStart = System.nanoTime();
                    TimeUnit.NANOSECONDS.timedJoin(thread, timeoutNanos);
                    long joinEnd = System.nanoTime();
                    if ((timeoutNanos -= joinEnd - joinStart) > 0L) continue;
                    return false;
                }
                return true;
            }
        }
    }

    static final class Priority {
        public static final Priority INITIALIZATION = new Priority(0, Tier.INITIALIZATION);
        final Tier tier;
        final int value;

        Priority(int value, Tier tier) {
            this.value = value;
            this.tier = tier;
        }

        public static enum Tier {
            INITIALIZATION,
            FIRST,
            LAST;

        }
    }

    public static interface JoinableThreadFactory
    extends ThreadFactory {
        public boolean joinOtherThreads(long var1, TimeUnit var3) throws InterruptedException;
    }
}

