/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.Json;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonValue;

public class RegexProperties
implements JsonConvertible {
    private static final int FLAG_ALTERNATIONS = 1;
    private static final int FLAG_CAPTURE_GROUPS = 2;
    private static final int FLAG_CHAR_CLASSES = 4;
    private static final int FLAG_LONE_SURROGATES = 8;
    private static final int FLAG_QUANTIFIERS = 16;
    private static final int FLAG_LOOK_AHEAD_ASSERTIONS = 32;
    private static final int FLAG_NEGATIVE_LOOK_AHEAD_ASSERTIONS = 64;
    private static final int FLAG_LOOK_BEHIND_ASSERTIONS = 128;
    private static final int FLAG_NON_LITERAL_LOOK_BEHIND_ASSERTIONS = 256;
    private static final int FLAG_NEGATIVE_LOOK_BEHIND_ASSERTIONS = 512;
    private static final int FLAG_LARGE_BOUNDED_QUANTIFIERS = 1024;
    private static final int FLAG_CHAR_CLASSES_CAN_BE_MATCHED_WITH_MASK = 2048;
    private static final int FLAG_FIXED_CODEPOINT_WIDTH = 4096;
    private static final int FLAG_CAPTURE_GROUPS_IN_LOOK_AROUND_ASSERTIONS = 8192;
    private static final int FLAG_EMPTY_CAPTURE_GROUPS = 16384;
    private static final int FLAG_BACK_REFERENCES = 32768;
    private static final int FLAG_RECURSIVE_BACK_REFERENCES = 65536;
    private static final int FLAG_NESTED_LOOK_BEHIND_ASSERTIONS = 131072;
    private static final int FLAG_LOOK_AROUND_WITH_CAPTURE_GROUPS_NESTED_IN_QUANTIFIER = 262144;
    private static final int FLAG_CONDITIONAL_BACKREFERENCES = 524288;
    private static final int FLAG_CONDITIONAL_REFERENCES_INTO_LOOK_AHEADS = 0x100000;
    private static final int FLAG_MATCH_BOUNDARY_ASSERTIONS = 0x200000;
    private static final int FLAG_NESTED_BOUNDED_QUANTIFIER = 0x400000;
    private int flags = 6144;
    private int innerLiteralStart = -1;
    private int innerLiteralEnd = -1;

    protected boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    private void setFlag(int flag) {
        this.flags |= flag;
    }

    private void clearFlag(int flag) {
        this.flags &= ~flag;
    }

    public boolean hasAlternations() {
        return this.getFlag(1);
    }

    public void setAlternations() {
        this.setFlag(1);
    }

    public boolean hasCaptureGroups() {
        return this.getFlag(2);
    }

    public void setCaptureGroups() {
        this.setFlag(2);
    }

    public boolean hasEmptyCaptureGroups() {
        return this.getFlag(16384);
    }

    public void setEmptyCaptureGroups() {
        this.setFlag(16384);
    }

    public boolean hasCharClasses() {
        return this.getFlag(4);
    }

    public void setCharClasses() {
        this.setFlag(4);
    }

    public boolean hasLoneSurrogates() {
        return this.getFlag(8);
    }

    public void setLoneSurrogates() {
        this.setFlag(8);
    }

    public boolean hasQuantifiers() {
        return this.getFlag(16);
    }

    public void setQuantifiers() {
        this.setFlag(16);
    }

    public boolean hasLookAroundAssertions() {
        return this.getFlag(736);
    }

    public boolean hasLookAheadAssertions() {
        return this.getFlag(32);
    }

    public void setLookAheadAssertions() {
        this.setFlag(32);
    }

    public boolean hasNegativeLookAheadAssertions() {
        return this.getFlag(64);
    }

    public void setNegativeLookAheadAssertions() {
        this.setFlag(64);
    }

    public boolean hasLookBehindAssertions() {
        return this.getFlag(128);
    }

    public void setLookBehindAssertions() {
        this.setFlag(128);
    }

    public boolean hasNonLiteralLookBehindAssertions() {
        return this.getFlag(256);
    }

    public void setNonLiteralLookBehindAssertions() {
        this.setFlag(256);
    }

    public boolean hasNegativeLookBehindAssertions() {
        return this.getFlag(512);
    }

    public void setNegativeLookBehindAssertions() {
        this.setFlag(512);
    }

    public boolean hasLargeBoundedQuantifiers() {
        return this.getFlag(1024);
    }

    public void setLargeBoundedQuantifiers() {
        this.setFlag(1024);
    }

    public boolean hasNestedBoundedQuantifiers() {
        return this.getFlag(0x400000);
    }

    public void setNestedBoundedQuantifier() {
        this.setFlag(0x400000);
    }

    public boolean charClassesCanBeMatchedWithMask() {
        return this.getFlag(2048);
    }

    public void unsetCharClassesCanBeMatchedWithMask() {
        this.clearFlag(2048);
    }

    public boolean isFixedCodePointWidth() {
        return this.getFlag(4096);
    }

    public void unsetFixedCodePointWidth() {
        this.clearFlag(4096);
    }

    public void setInnerLiteral(int start, int end) {
        this.innerLiteralStart = start;
        this.innerLiteralEnd = end;
    }

    public boolean hasInnerLiteral() {
        return this.innerLiteralStart >= 0;
    }

    public int getInnerLiteralStart() {
        return this.innerLiteralStart;
    }

    public int getInnerLiteralEnd() {
        return this.innerLiteralEnd;
    }

    public boolean hasCaptureGroupsInLookAroundAssertions() {
        return this.getFlag(8192);
    }

    public void setCaptureGroupsInLookAroundAssertions() {
        this.setFlag(8192);
    }

    public boolean hasBackReferences() {
        return this.getFlag(32768);
    }

    public void setBackReferences() {
        this.setFlag(32768);
    }

    public boolean hasRecursiveBackReferences() {
        return this.getFlag(65536);
    }

    public void setRecursiveBackReferences() {
        this.setFlag(65536);
    }

    public boolean hasNestedLookBehindAssertions() {
        return this.getFlag(131072);
    }

    public void setNestedLookBehindAssertions() {
        this.setFlag(131072);
    }

    public boolean hasLookAroundWithCaptureGroupsNestedInQuantifier() {
        return this.getFlag(262144);
    }

    public void setLookAroundWithCaptureGroupsNestedInQuantifier() {
        this.setFlag(262144);
    }

    public boolean hasConditionalBackReferences() {
        return this.getFlag(524288);
    }

    public void setConditionalBackReferences() {
        this.setFlag(524288);
    }

    public boolean hasConditionalReferencesIntoLookAheads() {
        return this.getFlag(0x100000);
    }

    public void setConditionalReferencesIntoLookAheads() {
        this.setFlag(0x100000);
    }

    public boolean hasMatchBoundaryAssertions() {
        return this.getFlag(0x200000);
    }

    public void setMatchBoundaryAssertions() {
        this.setFlag(0x200000);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("alternations", this.hasAlternations()), Json.prop("charClasses", this.hasCharClasses()), Json.prop("captureGroups", this.hasCaptureGroups()), Json.prop("matchBoundaryAssertions", this.hasMatchBoundaryAssertions()), Json.prop("lookAheadAssertions", this.hasLookAheadAssertions()), Json.prop("negativeLookAheadAssertions", this.hasNegativeLookAheadAssertions()), Json.prop("lookBehindAssertions", this.hasLookBehindAssertions()), Json.prop("nonLiteralLookBehindAssertions", this.hasNonLiteralLookBehindAssertions()), Json.prop("negativeLookBehindAssertions", this.hasNegativeLookBehindAssertions()), Json.prop("largeBoundedQuantifiers", this.hasLargeBoundedQuantifiers()), Json.prop("nestedBoundedQuantifiers", this.hasNestedBoundedQuantifiers()), Json.prop("captureGroupsInLookAroundAssertions", this.hasCaptureGroupsInLookAroundAssertions()), Json.prop("backReferences", this.hasBackReferences()), Json.prop("nestedLookBehindAssertions", this.hasNestedLookBehindAssertions()), Json.prop("lookAroundWithCaptureGroupsNestedInQuantifier", this.hasLookAroundWithCaptureGroupsNestedInQuantifier()), Json.prop("conditionalBackReferences", this.hasConditionalBackReferences()), Json.prop("conditionalReferencesIntoLookAheads", this.hasConditionalReferencesIntoLookAheads()));
    }
}

