/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSource;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexLexer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexParser;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexValidator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;

public abstract class RegexFlavor {
    protected static final int BACKREFERENCES_TO_UNMATCHED_GROUPS_FAIL = 1;
    protected static final int EMPTY_CHECKS_MONITOR_CAPTURE_GROUPS = 2;
    protected static final int NESTED_CAPTURE_GROUPS_KEPT_ON_LOOP_REENTRY = 4;
    protected static final int FAILING_EMPTY_CHECKS_DONT_BACKTRACK = 8;
    protected static final int USES_LAST_GROUP_RESULT_FIELD = 16;
    protected static final int LOOKBEHINDS_RUN_LEFT_TO_RIGHT = 32;
    protected static final int NEEDS_GROUP_START_POSITIONS = 64;
    protected static final int HAS_CONDITIONAL_BACKREFERENCES = 128;
    protected static final int SUPPORTS_RECURSIVE_BACKREFERENCES = 256;
    protected static final int EMPTY_CHECKS_ON_MANDATORY_LOOP_ITERATIONS = 512;
    protected static final int BACKREFERENCE_IGNORE_CASE_MULTI_CHAR_EXPANSION = 1024;
    protected static final int LOOKBEHINDS_REQUIRE_FIXED_WIDTH_PATTERN = 2048;
    private final int traits;

    protected RegexFlavor(int traits) {
        this.traits = traits;
    }

    public abstract String getName();

    public abstract RegexLexer createLexer(RegexSource var1, CompilationBuffer var2);

    public abstract RegexParser createParser(RegexLanguage var1, RegexSource var2, CompilationBuffer var3);

    public abstract RegexValidator createValidator(RegexLanguage var1, RegexSource var2, CompilationBuffer var3);

    public abstract EqualsIgnoreCasePredicate getEqualsIgnoreCasePredicate(RegexAST var1);

    public abstract CaseFoldData.CaseFoldAlgorithm getCaseFoldAlgorithm(RegexAST var1);

    private boolean hasTrait(int traitMask) {
        return (this.traits & traitMask) != 0;
    }

    public boolean backreferencesToUnmatchedGroupsFail() {
        return this.hasTrait(1);
    }

    public boolean supportsRecursiveBackreferences() {
        return this.hasTrait(256);
    }

    public boolean emptyChecksMonitorCaptureGroups() {
        return this.hasTrait(2);
    }

    public boolean nestedCaptureGroupsKeptOnLoopReentry() {
        return this.hasTrait(4);
    }

    public boolean failingEmptyChecksDontBacktrack() {
        return this.hasTrait(8);
    }

    public boolean canHaveEmptyLoopIterations() {
        return this.emptyChecksMonitorCaptureGroups() || this.failingEmptyChecksDontBacktrack();
    }

    public boolean usesLastGroupResultField() {
        return this.hasTrait(16);
    }

    public boolean lookBehindsRunLeftToRight() {
        return this.hasTrait(32);
    }

    public boolean lookBehindsRequireFixedWidthPattern() {
        return this.hasTrait(2048);
    }

    public boolean needsGroupStartPositions() {
        return this.hasTrait(64);
    }

    public boolean hasConditionalBackReferences() {
        return this.hasTrait(128);
    }

    public boolean matchesTransitionsStepByStep() {
        return this.emptyChecksMonitorCaptureGroups() || this.hasConditionalBackReferences() || this.failingEmptyChecksDontBacktrack();
    }

    public boolean emptyChecksOnMandatoryLoopIterations() {
        return this.hasTrait(512);
    }

    public boolean backreferenceIgnoreCaseMultiCharExpansion() {
        return this.hasTrait(1024);
    }

    @FunctionalInterface
    public static interface EqualsIgnoreCasePredicate {
        public boolean test(int var1, int var2, boolean var3);
    }
}

