/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexFlags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSource;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.ClassSetContents;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.CodePointSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.Constants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.IntRangesBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.Counter;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexProperties;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.Token;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.AtomicGroup;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Group;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.QuantifiableTerm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexASTRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.SubexpressionCall;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Term;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.visitors.DepthFirstTraversalRegexASTVisitor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.visitors.MarkAsDeadVisitor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.visitors.NodeCountVisitor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.Encodings;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.Equivalence;

public final class RegexASTBuilder {
    private final RegexOptions options;
    private final Encodings.Encoding encoding;
    private final RegexAST ast;
    private final RegexProperties properties;
    private final Counter.ThresholdCounter groupCount;
    private final NodeCountVisitor countVisitor;
    private final boolean canExplodeUTF16;
    private final CompilationBuffer compilationBuffer;
    private Group curGroup;
    private Sequence curSequence;
    private Term curTerm;
    private SourceSection overrideSourceSection;
    private final EconomicMap<Group, Integer> groupStartPositions;

    @CompilerDirectives.TruffleBoundary
    public RegexASTBuilder(RegexLanguage language, RegexSource source, RegexFlags flags, boolean canExplodeUTF16, CompilationBuffer compilationBuffer) {
        this.options = source.getOptions();
        this.encoding = source.getEncoding();
        this.canExplodeUTF16 = canExplodeUTF16;
        this.ast = new RegexAST(language, source, flags);
        this.properties = this.ast.getProperties();
        this.groupCount = this.ast.getGroupCount();
        this.countVisitor = new NodeCountVisitor();
        this.compilationBuffer = compilationBuffer;
        this.groupStartPositions = source.getOptions().getFlavor().needsGroupStartPositions() ? EconomicMap.create(Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE) : null;
    }

    public CompilationBuffer getCompilationBuffer() {
        return this.compilationBuffer;
    }

    public Group getCurGroup() {
        return this.curGroup;
    }

    public Sequence getCurSequence() {
        return this.curSequence;
    }

    public Term getCurTerm() {
        return this.curTerm;
    }

    public int getCurGroupStartPosition() {
        return this.groupStartPositions.get(this.curGroup, 0);
    }

    private void setGroupStartPosition(Group group, Token token) {
        if (token != null) {
            this.setGroupStartPosition(group, token.getPosition());
        }
    }

    private void setGroupStartPosition(Group group, int startPosition) {
        if (this.options.getFlavor().needsGroupStartPositions()) {
            this.groupStartPositions.putIfAbsent(group, startPosition);
        }
    }

    public void setOverrideSourceSection(SourceSection sourceSection) {
        this.overrideSourceSection = sourceSection;
    }

    public void clearOverrideSourceSection() {
        this.overrideSourceSection = null;
    }

    private void addSourceSection(RegexASTNode node, Token token) {
        this.ast.addSourceSection(node, this.overrideSourceSection == null && token != null ? token.getSourceSection() : this.overrideSourceSection);
    }

    public boolean curGroupIsRoot() {
        return this.curGroup == this.ast.getRoot();
    }

    public void pushRootGroup() {
        this.pushRootGroup(true);
    }

    public void pushRootGroup(boolean rootCapture) {
        RegexASTRootNode rootParent = this.ast.createRootNode();
        this.ast.setRoot(this.pushGroup(null, rootCapture ? this.ast.createCaptureGroup(this.groupCount.inc()) : this.ast.createGroup(), rootParent, true));
        this.setGroupStartPosition(this.ast.getRoot(), 0);
        if (this.options.isDumpAutomataWithSourceSections()) {
            this.ast.addSourceSections(this.ast.getRoot(), Arrays.asList(this.ast.getSource().getSource().createSection(0, 1), this.ast.getSource().getSource().createSection(this.ast.getSource().getPattern().length() + 1, 1)));
        }
    }

    public RegexAST popRootGroup() {
        this.optimizeGroup(this.curGroup);
        this.ast.getRoot().setEnclosedCaptureGroupsHi(this.groupCount.getCount());
        return this.ast;
    }

    public void pushGroup(Token token) {
        this.pushGroup(token, this.ast.createGroup(), null, true);
        if (token != null && token.kind == Token.Kind.inlineFlags) {
            this.curGroup.setLocalFlags(true);
        }
    }

    public void pushGroup() {
        this.pushGroup(null);
    }

    public void pushCaptureGroup(Token token) {
        this.pushGroup(token, this.ast.createCaptureGroup(this.groupCount.inc()), null, true);
    }

    public void pushCaptureGroup() {
        this.pushCaptureGroup(null);
    }

    public void pushLookAheadAssertion(Token token, boolean negate) {
        LookAheadAssertion lookAhead = this.ast.createLookAheadAssertion(negate);
        this.addSourceSection(lookAhead, token);
        this.addTerm(lookAhead);
        this.pushGroup(token, this.ast.createGroup(), lookAhead, true);
    }

    public void pushLookAheadAssertion(boolean negate) {
        this.pushLookAheadAssertion(null, negate);
    }

    public void pushLookBehindAssertion(Token token, boolean negate) {
        LookBehindAssertion lookBehind = this.ast.createLookBehindAssertion(negate);
        this.addSourceSection(lookBehind, token);
        this.addTerm(lookBehind);
        this.pushGroup(token, this.ast.createGroup(), lookBehind, true);
    }

    public void pushLookBehindAssertion(boolean negate) {
        this.pushLookBehindAssertion(null, negate);
    }

    public void pushAtomicGroup(Token token) {
        AtomicGroup atomicGroup = this.ast.createAtomicGroup();
        this.addSourceSection(atomicGroup, token);
        this.addTerm(atomicGroup);
        this.pushGroup(token, this.ast.createGroup(), atomicGroup, true);
    }

    public void pushAtomicGroup() {
        this.pushAtomicGroup(null);
    }

    public void pushConditionalBackReferenceGroup(Token.BackReference token) {
        assert (token.kind == Token.Kind.conditionalBackreference);
        assert (token.getGroupNumbers().length == 1);
        this.pushGroup(token, this.ast.createConditionalBackReferenceGroup(token.getGroupNumbers()[0]), null, true);
    }

    public void pushConditionalBackReferenceGroup(int referencedGroupNumber, boolean namedReference) {
        this.pushConditionalBackReferenceGroup(Token.createConditionalBackReference(referencedGroupNumber, namedReference));
    }

    private Group pushGroup(Token token, Group group, RegexASTSubtreeRootNode parent, boolean openFirstSequence) {
        if (parent != null) {
            parent.setGroup(group);
        } else {
            this.addTerm(group);
        }
        this.addSourceSection(group, token);
        this.setGroupStartPosition(group, token);
        this.curGroup = group;
        this.curGroup.setEnclosedCaptureGroupsLo(this.groupCount.getCount());
        if (openFirstSequence) {
            this.nextSequence();
        } else {
            this.curSequence = null;
            this.curTerm = null;
        }
        return group;
    }

    private void pushGroup(boolean openNextSequence) {
        this.pushGroup(null, this.ast.createGroup(), null, openNextSequence);
    }

    public void popGroup(Token token) {
        RegexASTNode parent;
        if (this.tryMergeSingleCharClassAlternations()) {
            this.curGroup.removeLastSequence();
            this.ast.getNodeCount().dec();
        }
        this.optimizeGroup(this.curGroup);
        this.curGroup.setEnclosedCaptureGroupsHi(this.groupCount.getCount());
        this.addSourceSection(this.curGroup, token);
        if (this.curGroup.getParent().isSubtreeRoot()) {
            this.addSourceSection(this.curGroup.getParent(), token);
        }
        if ((parent = this.curGroup.getParent()).isSubtreeRoot()) {
            this.curTerm = (Term)parent;
            this.curSequence = parent.getParent().asSequence();
        } else {
            this.curTerm = this.curGroup;
            this.curSequence = (Sequence)parent;
        }
        this.curGroup = this.curSequence.getParent();
    }

    public void popGroup() {
        this.popGroup(null);
    }

    public void nextSequence() {
        if (!this.tryMergeSingleCharClassAlternations()) {
            this.curSequence = this.curGroup.addSequence(this.ast);
        }
        this.curTerm = null;
    }

    private void addTerm(Term term) {
        this.curSequence.add(term);
        this.curTerm = term;
    }

    private boolean shouldExplodeUTF16() {
        return this.canExplodeUTF16 && this.options.isUTF16ExplodeAstralSymbols();
    }

    public void addCharClass(Token.CharacterClass token) {
        CodePointSet codePointSet = this.pruneCharClass(token.getCodePointSet());
        if (this.shouldExplodeUTF16()) {
            this.addTerm(this.translateUnicodeCharClass(codePointSet, token, token.wasSingleChar()));
        } else {
            this.addTerm(this.createCharClass(codePointSet, token, token.wasSingleChar()));
        }
    }

    public void addCharClass(CodePointSet charSet, boolean wasSingleChar) {
        this.addCharClass(Token.createCharClass(charSet, wasSingleChar));
    }

    public void addCharClass(CodePointSet charSet, boolean wasSingleChar, SourceSection sourceSection) {
        Token.CharacterClass charClass = Token.createCharClass(charSet, wasSingleChar);
        charClass.setSourceSection(sourceSection);
        this.addCharClass(charClass);
    }

    public void addCharClass(CodePointSet charSet) {
        this.addCharClass(charSet, charSet.matchesSingleChar());
    }

    public void addLiteralChar(Token.LiteralCharacter literalCharacter) {
        this.addCharClass(CodePointSet.create(literalCharacter.getCodePoint()), true, literalCharacter.getSourceSection());
    }

    private CodePointSet pruneCharClass(CodePointSet cps) {
        return this.encoding.getFullSet().createIntersection(cps, this.compilationBuffer);
    }

    private CharacterClass createCharClass(CodePointSet charSet, Token token) {
        return this.createCharClass(charSet, token, false);
    }

    private CharacterClass createCharClass(CodePointSet charSet, Token token, boolean wasSingleChar) {
        CharacterClass characterClass = this.ast.createCharacterClass(charSet);
        this.addSourceSection(characterClass, token);
        if (wasSingleChar) {
            characterClass.setWasSingleChar();
        }
        return characterClass;
    }

    private Term translateUnicodeCharClass(CodePointSet codePointSet, Token token, boolean wasSingleChar) {
        StashedState ignored;
        if (Constants.BMP_WITHOUT_SURROGATES.contains(codePointSet)) {
            return this.createCharClass(codePointSet, token, wasSingleChar);
        }
        Group group = this.ast.createGroup();
        group.setEnclosedCaptureGroupsLo(this.groupCount.getCount());
        group.setEnclosedCaptureGroupsHi(this.groupCount.getCount());
        IntRangesBuffer tmp = this.compilationBuffer.getIntRangesBuffer1();
        CodePointSet bmpRanges = codePointSet.createIntersection(Constants.BMP_WITHOUT_SURROGATES, tmp);
        CodePointSet astralRanges = codePointSet.createIntersection(Constants.ASTRAL_SYMBOLS, tmp);
        CodePointSet loneLeadSurrogateRanges = codePointSet.createIntersection(Constants.LEAD_SURROGATES, tmp);
        CodePointSet loneTrailSurrogateRanges = codePointSet.createIntersection(Constants.TRAIL_SURROGATES, tmp);
        assert (astralRanges.matchesSomething() || loneLeadSurrogateRanges.matchesSomething() || loneTrailSurrogateRanges.matchesSomething());
        if (bmpRanges.matchesSomething()) {
            Sequence bmpAlternative = group.addSequence(this.ast);
            bmpAlternative.add(this.createCharClass(bmpRanges, token));
        }
        if (loneLeadSurrogateRanges.matchesSomething()) {
            Sequence loneLeadSurrogateAlternative = group.addSequence(this.ast);
            loneLeadSurrogateAlternative.add(this.createCharClass(loneLeadSurrogateRanges, token));
            ignored = this.withTempState(group, loneLeadSurrogateAlternative, null);
            try {
                this.addNoTrailSurrogateAhead();
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        if (loneTrailSurrogateRanges.matchesSomething()) {
            Sequence loneTrailSurrogateAlternative = group.addSequence(this.ast);
            ignored = this.withTempState(group, loneTrailSurrogateAlternative, null);
            try {
                this.addNoLeadSurrogateBehind();
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
            loneTrailSurrogateAlternative.add(this.createCharClass(loneTrailSurrogateRanges, token));
        }
        if (astralRanges.matchesSomething()) {
            CodePointSetAccumulator completeRanges = this.compilationBuffer.getCodePointSetAccumulator1();
            completeRanges.clear();
            char curLead = Character.highSurrogate(astralRanges.getLo(0));
            CodePointSetAccumulator curTrails = this.compilationBuffer.getCodePointSetAccumulator2();
            curTrails.clear();
            for (int i = 0; i < astralRanges.size(); ++i) {
                Sequence finishedAlternative;
                char startLead = Character.highSurrogate(astralRanges.getLo(i));
                char startTrail = Character.lowSurrogate(astralRanges.getLo(i));
                char endLead = Character.highSurrogate(astralRanges.getHi(i));
                char endTrail = Character.lowSurrogate(astralRanges.getHi(i));
                if (startLead > curLead) {
                    if (!curTrails.isEmpty()) {
                        finishedAlternative = group.addSequence(this.ast);
                        finishedAlternative.add(this.createCharClass(CodePointSet.create((int)curLead), token));
                        finishedAlternative.add(this.createCharClass(curTrails.toCodePointSet(), token));
                    }
                    curLead = startLead;
                    curTrails.clear();
                }
                if (startLead == endLead) {
                    curTrails.addRange(startTrail, endTrail);
                    continue;
                }
                if (startTrail != Constants.TRAIL_SURROGATES.getLo(0)) {
                    curTrails.addRange(startTrail, Constants.TRAIL_SURROGATES.getHi(0));
                    assert (startLead < '\uffff');
                    startLead = (char)(startLead + '\u0001');
                }
                if (!curTrails.isEmpty()) {
                    finishedAlternative = group.addSequence(this.ast);
                    finishedAlternative.add(this.createCharClass(CodePointSet.create((int)curLead), token));
                    finishedAlternative.add(this.createCharClass(curTrails.toCodePointSet(), token));
                }
                curLead = endLead;
                curTrails.clear();
                if (endTrail != Constants.TRAIL_SURROGATES.getHi(0)) {
                    curTrails.addRange(Constants.TRAIL_SURROGATES.getLo(0), endTrail);
                    assert (endLead > '\u0000');
                    endLead = (char)(endLead - '\u0001');
                }
                if (startLead > endLead) continue;
                completeRanges.addRange(startLead, endLead);
            }
            if (!curTrails.isEmpty()) {
                Sequence lastAlternative = group.addSequence(this.ast);
                lastAlternative.add(this.createCharClass(CodePointSet.create((int)curLead), token));
                lastAlternative.add(this.createCharClass(curTrails.toCodePointSet(), token));
            }
            if (!completeRanges.isEmpty()) {
                Sequence completeRangesAlt = this.ast.createSequence();
                group.insertFirst(completeRangesAlt);
                completeRangesAlt.add(this.createCharClass(completeRanges.toCodePointSet(), token));
                completeRangesAlt.add(this.createCharClass(Constants.TRAIL_SURROGATES, token));
            }
        }
        assert (group.size() != 1 || group.getFirstAlternative().getTerms().size() != 1);
        return group;
    }

    private void addNoLeadSurrogateBehind() {
        this.addCaretOrLookBehind(Constants.LEAD_SURROGATES.createInverse(Encodings.UTF_16));
    }

    private void addNoTrailSurrogateAhead() {
        this.addDollarOrLookAhead(Constants.TRAIL_SURROGATES.createInverse(Encodings.UTF_16));
    }

    public void addClassSet(Token.ClassSet token, CaseFoldData.CaseFoldUnfoldAlgorithm caseUnfoldAlgo) {
        CodePointSetAccumulator buf = this.compilationBuffer.getCodePointSetAccumulator1();
        ClassSetContents contents = token.getContents();
        if (contents.isEmpty()) {
            this.addCharClass(CodePointSet.getEmpty());
            return;
        }
        this.pushGroup(false);
        String[] sortedStrings = new String[contents.getStrings().size()];
        contents.getStrings().toArray((String[])sortedStrings);
        Arrays.sort(sortedStrings, Comparator.comparingInt(String::length).reversed());
        for (String string : sortedStrings) {
            if (string.isEmpty()) continue;
            this.nextSequence();
            string.codePoints().forEachOrdered(cp -> {
                if (caseUnfoldAlgo != null) {
                    buf.clear();
                    buf.addCodePoint(cp);
                    CaseFoldData.applyCaseFoldUnfold(buf, this.compilationBuffer.getCodePointSetAccumulator2(), caseUnfoldAlgo);
                    this.addCharClass(buf.toCodePointSet());
                } else {
                    this.addCharClass(CodePointSet.create(cp));
                }
            });
        }
        if (!contents.getCodePointSet().isEmpty()) {
            this.nextSequence();
            if (caseUnfoldAlgo != null) {
                buf.clear();
                buf.addSet(contents.getCodePointSet());
                CaseFoldData.applyCaseFoldUnfold(buf, this.compilationBuffer.getCodePointSetAccumulator2(), caseUnfoldAlgo);
                this.addCharClass(buf.toCodePointSet());
            } else {
                this.addCharClass(contents.getCodePointSet());
            }
        }
        if (contents.getStrings().contains("")) {
            this.nextSequence();
        }
        this.popGroup();
    }

    public void addBackReference(Token.BackReference token) {
        this.addBackReference(token, false);
    }

    public void addBackReference(Token.BackReference token, boolean ignoreCase) {
        this.addBackReference(token, ignoreCase, false);
    }

    public void addBackReference(Token.BackReference token, boolean ignoreCase, boolean ignoreCaseAltMode) {
        assert (token.kind == Token.Kind.backReference);
        BackReference backReference = this.ast.createBackReference(token.getGroupNumbers());
        this.addSourceSection(backReference, token);
        this.addTerm(backReference);
        boolean allNestedReferences = true;
        boolean allForwardReferences = true;
        boolean allNestedOrForwardReferences = true;
        for (int groupNumber : backReference.getGroupNumbers()) {
            boolean nestedReference;
            boolean forwardReference = groupNumber >= this.groupCount.getCount();
            boolean bl = nestedReference = !forwardReference && RegexASTBuilder.isNestedBackReference(backReference, groupNumber);
            if (nestedReference) {
                this.ast.setGroupRecursivelyReferenced(groupNumber);
            }
            allNestedReferences = allNestedReferences && nestedReference;
            allForwardReferences = allForwardReferences && forwardReference;
            allNestedOrForwardReferences = allNestedOrForwardReferences && (forwardReference || nestedReference);
        }
        if (allForwardReferences) {
            backReference.setForwardReference();
        }
        if (allNestedReferences) {
            backReference.setNestedBackReference();
        }
        if (allNestedOrForwardReferences) {
            backReference.setNestedOrForwardReference();
        }
        if (ignoreCase) {
            backReference.setIgnoreCaseReference();
        }
        if (ignoreCaseAltMode) {
            backReference.setIgnoreCaseReferenceAltMode();
        }
    }

    public void addBackReference(int groupNumber, boolean namedReference, boolean ignoreCase) {
        this.addBackReference(Token.createBackReference(groupNumber, namedReference), ignoreCase);
    }

    private static boolean isNestedBackReference(BackReference backReference, int groupNumber) {
        RegexASTNode parent = backReference.getParent().getParent();
        while (parent.asGroup().getGroupNumber() != groupNumber) {
            if ((parent = parent.getParent()).isRoot()) {
                return false;
            }
            if (parent.isSubtreeRoot()) {
                parent = parent.getParent();
            }
            parent = parent.getParent();
        }
        return true;
    }

    public void addSubexpressionCall(int groupNumber) {
        SubexpressionCall subexpressionCall = this.ast.createSubexpressionCall(groupNumber);
        this.addTerm(subexpressionCall);
    }

    public void addPositionAssertion(Token token) {
        PositionAssertion positionAssertion = this.ast.createPositionAssertion(switch (token.kind) {
            case Token.Kind.A, Token.Kind.caret -> PositionAssertion.Type.CARET;
            case Token.Kind.Z, Token.Kind.z, Token.Kind.dollar -> PositionAssertion.Type.DOLLAR;
            default -> throw new IllegalArgumentException("unexpected token kind: " + String.valueOf((Object)token.kind));
        });
        this.addSourceSection(positionAssertion, token);
        this.addTerm(positionAssertion);
    }

    public void addCaret() {
        this.addPositionAssertion(Token.createCaret());
    }

    public void addDollar() {
        this.addPositionAssertion(Token.createDollar());
    }

    public void addPositionAssertion(PositionAssertion.Type type) {
        this.addTerm(this.ast.createPositionAssertion(type));
    }

    public void addQuantifier(Token.Quantifier quantifier) {
        QuantifiableTerm prev;
        Term prevTerm;
        boolean curTermIsZeroWidthGroup;
        assert (this.curTerm == this.curSequence.getLastTerm());
        if (quantifier.isDead()) {
            this.replaceCurTermWithDeadNode();
            return;
        }
        if (quantifier.getMax() == 0) {
            this.removeCurTerm();
            return;
        }
        boolean bl = curTermIsZeroWidthGroup = this.curTerm.isGroup() && this.curTerm.asGroup().isAlwaysZeroWidth();
        if (this.options.getFlavor().canHaveEmptyLoopIterations()) {
            if (quantifier.getMin() == 0 && this.curTerm.isCharacterClass() && this.curTerm.asCharacterClass().getCharSet().matchesNothing()) {
                this.removeCurTerm();
                return;
            }
        } else if (quantifier.getMin() == 0 && (this.curTerm.isLookAroundAssertion() || curTermIsZeroWidthGroup || this.curTerm.isCharacterClass() && this.curTerm.asCharacterClass().getCharSet().matchesNothing())) {
            this.removeCurTerm();
            return;
        }
        if (quantifier.getMin() > 0 && (this.curTerm.isLookAroundAssertion() || curTermIsZeroWidthGroup)) {
            if (quantifier.isPossessive()) {
                this.wrapCurTermInAtomicGroup();
            }
            return;
        }
        if (quantifier.getMin() == 1 && quantifier.getMax() == 1) {
            if (quantifier.isPossessive()) {
                this.wrapCurTermInAtomicGroup();
            }
            return;
        }
        this.curTerm = this.addQuantifier(this.curTerm, quantifier);
        if (quantifier.isPossessive()) {
            this.wrapCurTermInAtomicGroup();
            return;
        }
        if (this.curSequence.size() > 1 && (prevTerm = this.curSequence.getTerms().get(this.curSequence.size() - 2)).isQuantifiableTerm() && (prev = prevTerm.asQuantifiableTerm()).hasQuantifier() && prev.getQuantifier().isGreedy() == quantifier.isGreedy() && this.curTerm.asQuantifiableTerm().equalsSemantic(prev, true)) {
            long max;
            this.removeCurTerm();
            long min = (long)prev.getQuantifier().getMin() + (long)quantifier.getMin();
            long l = max = prev.getQuantifier().isInfiniteLoop() || quantifier.isInfiniteLoop() ? -1L : (long)prev.getQuantifier().getMax() + (long)quantifier.getMax();
            if (min > Integer.MAX_VALUE) {
                this.replaceCurTermWithDeadNode();
                return;
            }
            if (max > Integer.MAX_VALUE) {
                max = -1L;
            }
            this.setQuantifier(prev, Token.createQuantifier((int)min, (int)max, quantifier.isGreedy(), false, quantifier.isSingleChar()));
        }
    }

    private QuantifiableTerm addQuantifier(Term term, Token.Quantifier quantifier) {
        QuantifiableTerm quantifiableTerm;
        QuantifiableTerm quantifiableTerm2 = quantifiableTerm = term.isQuantifiableTerm() ? term.asQuantifiableTerm() : this.wrapTermInGroup(term);
        if (quantifiableTerm.hasQuantifier()) {
            quantifiableTerm = this.wrapTermInGroup(term);
        }
        this.addSourceSection(quantifiableTerm, quantifier);
        this.setQuantifier(quantifiableTerm, quantifier);
        return quantifiableTerm;
    }

    private void setQuantifier(QuantifiableTerm term, Token.Quantifier quantifier) {
        term.setQuantifier(quantifier);
        if (!term.isUnrollingCandidate(this.options)) {
            this.properties.setLargeBoundedQuantifiers();
        }
        this.properties.setQuantifiers();
    }

    private Group wrapTermInGroup(Term term) {
        Group wrapperGroup = this.ast.createGroup();
        if (term.isGroup()) {
            wrapperGroup.setEnclosedCaptureGroupsLo(term.asGroup().getCaptureGroupsLo());
            wrapperGroup.setEnclosedCaptureGroupsHi(term.asGroup().getCaptureGroupsHi());
        } else if (term.isAtomicGroup()) {
            wrapperGroup.setEnclosedCaptureGroupsLo(term.asAtomicGroup().getEnclosedCaptureGroupsLow());
            wrapperGroup.setEnclosedCaptureGroupsHi(term.asAtomicGroup().getEnclosedCaptureGroupsHigh());
        }
        Sequence wrapperSequence = wrapperGroup.addSequence(this.ast);
        term.getParent().asSequence().replace(term.getSeqIndex(), wrapperGroup);
        wrapperSequence.add(term);
        return wrapperGroup;
    }

    public void removeCurTerm() {
        this.ast.getNodeCount().dec(this.countVisitor.count(this.curSequence.getLastTerm()));
        MarkAsDeadVisitor.markAsDead(this.curSequence.getLastTerm());
        this.curSequence.removeLastTerm();
        this.curTerm = this.curSequence.isEmpty() ? null : this.curSequence.getLastTerm();
    }

    public void addDeadNode() {
        this.addTerm(this.createCharClass(CodePointSet.getEmpty(), null));
    }

    public void replaceCurTermWithDeadNode() {
        this.removeCurTerm();
        this.addDeadNode();
    }

    public void wrapCurTermInGroup() {
        this.curTerm = this.wrapTermInGroup(this.curTerm);
    }

    public void wrapCurTermInAtomicGroup() {
        Group atomicGroupContents = this.wrapTermInGroup(this.curTerm);
        AtomicGroup atomicGroup = this.ast.createAtomicGroup();
        this.curSequence.replace(atomicGroupContents.getSeqIndex(), atomicGroup);
        atomicGroup.setGroup(atomicGroupContents);
        this.curTerm = atomicGroup;
    }

    public void addWordBoundaryAssertion(Token token, CodePointSet wordChars, CodePointSet nonWordChars) {
        if (token != null) {
            this.setOverrideSourceSection(token.getSourceSection());
        }
        this.pushGroup();
        this.addCaretOrLookBehind(nonWordChars);
        this.addLookAhead(wordChars);
        this.nextSequence();
        this.addLookBehind(wordChars);
        this.addDollarOrLookAhead(nonWordChars);
        this.popGroup();
        this.clearOverrideSourceSection();
    }

    public void addWordNonBoundaryAssertion(Token token, CodePointSet wordChars, CodePointSet nonWordChars) {
        if (token != null) {
            this.setOverrideSourceSection(token.getSourceSection());
        }
        this.pushGroup();
        this.addCaretOrLookBehind(nonWordChars);
        this.addDollarOrLookAhead(nonWordChars);
        this.nextSequence();
        this.addLookBehind(wordChars);
        this.addLookAhead(wordChars);
        this.popGroup();
        this.clearOverrideSourceSection();
    }

    public void addWordNonBoundaryAssertionPython(CodePointSet wordChars, CodePointSet nonWordChars) {
        this.pushGroup();
        this.addCaret();
        this.pushLookAheadAssertion(false);
        this.addCharClass(nonWordChars);
        this.popGroup();
        this.nextSequence();
        this.pushLookBehindAssertion(false);
        this.addCharClass(nonWordChars);
        this.popGroup();
        this.addDollar();
        this.nextSequence();
        this.pushLookBehindAssertion(false);
        this.addCharClass(nonWordChars);
        this.popGroup();
        this.pushLookAheadAssertion(false);
        this.addCharClass(nonWordChars);
        this.popGroup();
        this.nextSequence();
        this.pushLookBehindAssertion(false);
        this.addCharClass(wordChars);
        this.popGroup();
        this.pushLookAheadAssertion(false);
        this.addCharClass(wordChars);
        this.popGroup();
        this.popGroup();
    }

    public void addCaretOrLookBehind(CodePointSet lookbehind) {
        this.pushGroup();
        this.addCaret();
        this.nextSequence();
        this.addLookBehind(lookbehind);
        this.popGroup();
    }

    public void addDollarOrLookAhead(CodePointSet lookahead) {
        this.pushGroup();
        this.addDollar();
        this.nextSequence();
        this.addLookAhead(lookahead);
        this.popGroup();
    }

    private void addLookAhead(CodePointSet lookahead) {
        this.pushLookAheadAssertion(false);
        this.addCharClass(lookahead);
        this.popGroup();
    }

    private void addLookBehind(CodePointSet lookbehind) {
        this.pushLookBehindAssertion(false);
        this.addCharClass(lookbehind);
        this.popGroup();
    }

    private void optimizeGroup(Group group) {
        if (group.isConditionalBackReferenceGroup() || group.isInLookBehindAssertion()) {
            return;
        }
        RegexASTBuilder.sortAlternatives(group);
        this.mergeCommonPrefixes(group);
    }

    private boolean tryMergeSingleCharClassAlternations() {
        if (this.curGroup.size() > 1 && this.curSequence.isSingleCharClass() && !this.curGroup.isConditionalBackReferenceGroup()) {
            assert (this.curSequence == this.curGroup.getAlternatives().get(this.curGroup.size() - 1));
            Sequence prevSequence = this.curGroup.getAlternatives().get(this.curGroup.size() - 2);
            if (prevSequence.isSingleCharClass()) {
                this.mergeCharClasses((CharacterClass)prevSequence.getFirstTerm(), (CharacterClass)this.curSequence.getFirstTerm());
                this.curSequence.removeLastTerm();
                this.ast.getNodeCount().dec();
                return true;
            }
        }
        return false;
    }

    private void mergeCharClasses(CharacterClass dst, CharacterClass src) {
        dst.setCharSet(dst.getCharSet().union(src.getCharSet()));
        dst.setWasSingleChar(false);
        this.ast.addSourceSections(dst, this.ast.getSourceSections(src));
    }

    private static void sortAlternatives(Group group) {
        if (group.size() < 2) {
            return;
        }
        int begin = 0;
        while (begin + 1 < group.size()) {
            int end = RegexASTBuilder.findSingleCharAlternatives(group, begin);
            if (end > begin + 1) {
                group.getAlternatives().subList(begin, end).sort(Comparator.comparingInt(a -> a.getFirstTerm().asCharacterClass().getCharSet().getMin()));
                begin = end;
                continue;
            }
            ++begin;
        }
    }

    private void mergeCommonPrefixes(Group group) {
        if (group.size() < 2) {
            return;
        }
        ArrayList<Sequence> newAlternatives = null;
        IsDeterministicVisitor isDeterministicVisitor = new IsDeterministicVisitor();
        int lastEnd = 0;
        int begin = 0;
        while (begin + 1 < group.size()) {
            int end = RegexASTBuilder.findMatchingAlternatives(group, begin);
            if (end < 0 || !isDeterministicVisitor.isDeterministic(group.getAlternatives().get(begin).getFirstTerm())) {
                ++begin;
                continue;
            }
            if (newAlternatives == null) {
                newAlternatives = new ArrayList<Sequence>();
            }
            for (int i = lastEnd; i < begin; ++i) {
                newAlternatives.add(group.getAlternatives().get(i));
            }
            lastEnd = end;
            int prefixSize = 1;
            while (RegexASTBuilder.alternativesAreEqualAt(group, begin, end, prefixSize) && isDeterministicVisitor.isDeterministic(group.getAlternatives().get(begin).get(prefixSize))) {
                ++prefixSize;
            }
            Sequence prefixSeq = this.ast.createSequence();
            Group innerGroup = this.ast.createGroup();
            int enclosedCGLo = Integer.MAX_VALUE;
            int enclosedCGHi = Integer.MIN_VALUE;
            boolean emptyAlt = false;
            for (int i = begin; i < end; ++i) {
                Sequence s = group.getAlternatives().get(i);
                assert (s.size() >= prefixSize);
                for (int j = 0; j < prefixSize; ++j) {
                    Term t = s.getTerms().get(j);
                    if (i == begin) {
                        prefixSeq.add(t);
                        continue;
                    }
                    this.ast.addSourceSections(prefixSeq.getTerms().get(j), this.ast.getSourceSections(t));
                    this.ast.getNodeCount().dec(this.countVisitor.count(t));
                }
                if (i > begin && s.size() - prefixSize == 1 && s.getLastTerm().isCharacterClass() && !s.getLastTerm().asCharacterClass().hasQuantifier() && innerGroup.getLastAlternative().isSingleCharClass()) {
                    this.mergeCharClasses(innerGroup.getLastAlternative().getFirstTerm().asCharacterClass(), s.getLastTerm().asCharacterClass());
                    continue;
                }
                if (prefixSize == s.size()) {
                    if (!emptyAlt) {
                        innerGroup.addSequence(this.ast);
                    }
                    emptyAlt = true;
                    continue;
                }
                Sequence copy = innerGroup.addSequence(this.ast);
                for (int j = prefixSize; j < s.size(); ++j) {
                    Term t = s.getTerms().get(j);
                    copy.add(t);
                    if (!t.isGroup()) continue;
                    Group g = t.asGroup();
                    if (g.getEnclosedCaptureGroupsLo() != g.getEnclosedCaptureGroupsHi()) {
                        enclosedCGLo = Math.min(enclosedCGLo, g.getEnclosedCaptureGroupsLo());
                        enclosedCGHi = Math.max(enclosedCGHi, g.getEnclosedCaptureGroupsHi());
                    }
                    if (!g.isCapturing()) continue;
                    enclosedCGLo = Math.min(enclosedCGLo, g.getGroupNumber());
                    enclosedCGHi = Math.max(enclosedCGHi, g.getGroupNumber() + 1);
                }
            }
            if (enclosedCGLo != Integer.MAX_VALUE) {
                innerGroup.setEnclosedCaptureGroupsLo(enclosedCGLo);
                innerGroup.setEnclosedCaptureGroupsHi(enclosedCGHi);
            }
            if (!(innerGroup.isEmpty() || innerGroup.size() == 1 && innerGroup.getFirstAlternative().isEmpty())) {
                this.optimizeGroup(innerGroup);
                prefixSeq.add(innerGroup);
            }
            newAlternatives.add(prefixSeq);
            begin = end;
        }
        if (newAlternatives != null) {
            for (int i = lastEnd; i < group.size(); ++i) {
                newAlternatives.add(group.getAlternatives().get(i));
            }
            group.setAlternatives(newAlternatives);
        }
    }

    private static boolean alternativesAreEqualAt(Group group, int altBegin, int altEnd, int iTerm) {
        if (group.getAlternatives().get(altBegin).size() <= iTerm) {
            return false;
        }
        Term cmp = group.getAlternatives().get(altBegin).getTerms().get(iTerm);
        for (int i = altBegin + 1; i < altEnd; ++i) {
            Sequence s = group.getAlternatives().get(i);
            if (s.size() <= iTerm) {
                return false;
            }
            if (s.getTerms().get(iTerm).equalsSemantic(cmp)) continue;
            return false;
        }
        return true;
    }

    private static int findMatchingAlternatives(Group group, int begin) {
        if (group.getAlternatives().get(begin).isEmpty()) {
            return -1;
        }
        Term cmp = group.getAlternatives().get(begin).getFirstTerm();
        int ret = -1;
        for (int i = begin + 1; i < group.size(); ++i) {
            Sequence s = group.getAlternatives().get(i);
            if (s.isEmpty() || !cmp.equalsSemantic(s.getFirstTerm())) {
                return ret;
            }
            ret = i + 1;
        }
        return ret;
    }

    private static int findSingleCharAlternatives(Group group, int begin) {
        int ret = -1;
        for (int i = begin; i < group.size(); ++i) {
            Sequence s = group.getAlternatives().get(i);
            if (s.isEmpty() || !s.getFirstTerm().isCharacterClass()) {
                return ret;
            }
            CharacterClass firstCC = s.getFirstTerm().asCharacterClass();
            if (!firstCC.wasSingleChar() || firstCC.hasQuantifier() && firstCC.getQuantifier().getMin() == 0) {
                return ret;
            }
            ret = i + 1;
        }
        return ret;
    }

    private StashedState withTempState(Group tempGroup, Sequence tempSequence, Term tempTerm) {
        StashedState stashedState = new StashedState(this);
        this.curGroup = tempGroup;
        this.curSequence = tempSequence;
        this.curTerm = tempTerm;
        return stashedState;
    }

    private record StashedState(RegexASTBuilder builder, Group curGroup, Sequence curSequence, Term curTerm) implements AutoCloseable
    {
        StashedState(RegexASTBuilder builder) {
            this(builder, builder.curGroup, builder.curSequence, builder.curTerm);
        }

        @Override
        public void close() {
            this.builder.curGroup = this.curGroup;
            this.builder.curSequence = this.curSequence;
            this.builder.curTerm = this.curTerm;
        }
    }

    private static final class IsDeterministicVisitor
    extends DepthFirstTraversalRegexASTVisitor {
        private boolean result;

        private IsDeterministicVisitor() {
        }

        public boolean isDeterministic(RegexASTNode node) {
            this.result = true;
            this.run(node);
            return this.result;
        }

        private static boolean hasNonDeterministicQuantifier(QuantifiableTerm term) {
            Token.Quantifier quantifier;
            return term.hasQuantifier() && (quantifier = term.getQuantifier()).getMin() != quantifier.getMax();
        }

        @Override
        protected void visit(BackReference backReference) {
            if (IsDeterministicVisitor.hasNonDeterministicQuantifier(backReference)) {
                this.result = false;
            }
        }

        @Override
        protected void visit(Group group) {
            if (IsDeterministicVisitor.hasNonDeterministicQuantifier(group)) {
                this.result = false;
                return;
            }
            if (group.getAlternatives().size() > 1) {
                this.result = false;
            }
        }

        @Override
        protected void visit(CharacterClass characterClass) {
            if (IsDeterministicVisitor.hasNonDeterministicQuantifier(characterClass)) {
                this.result = false;
            }
        }
    }
}

