/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleFile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.dfa.DFAGenerator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.dfa.DFAStateTransitionBuilder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.Encodings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.Json;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonValue;

public final class TRegexDFAExecutorDebugRecorder
implements JsonConvertible {
    private final DFAGenerator dfa;
    private final List<Recording> recordings = new ArrayList<Recording>();

    @CompilerDirectives.TruffleBoundary
    public static TRegexDFAExecutorDebugRecorder create(RegexOptions options, DFAGenerator dfaGenerator) {
        return options.isStepExecution() ? new TRegexDFAExecutorDebugRecorder(dfaGenerator) : null;
    }

    private TRegexDFAExecutorDebugRecorder(DFAGenerator dfa) {
        this.dfa = dfa;
    }

    @CompilerDirectives.TruffleBoundary
    public void startRecording(TRegexDFAExecutorLocals locals) {
        this.recordings.add(new Recording(locals.getInput(), this.dfa.getOptions().getEncoding(), locals.getFromIndex(), locals.getIndex(), locals.getMaxIndex(), this.dfa.isForward()));
    }

    @CompilerDirectives.TruffleBoundary
    private Recording curRecording() {
        return this.recordings.get(this.recordings.size() - 1);
    }

    @CompilerDirectives.TruffleBoundary
    public void setInitialIndex(int initialIndex) {
        this.curRecording().setInitialIndex(initialIndex);
    }

    @CompilerDirectives.TruffleBoundary
    public void recordTransition(int currentIndex, short stateNodeID, int transitionIndex) {
        int transitionID = ((DFAStateTransitionBuilder[])this.dfa.getState(stateNodeID).getSuccessors())[transitionIndex].getId();
        this.curRecording().recordTransition(currentIndex, transitionID);
    }

    @CompilerDirectives.TruffleBoundary
    public void recordCGPartialTransition(int currentIndex, int cgPartialTransitionIndex) {
        this.curRecording().recordCGPartialTransition(currentIndex, cgPartialTransitionIndex);
    }

    @CompilerDirectives.TruffleBoundary
    public void finishRecording() {
        TruffleFile file = RegexLanguage.RegexContext.get(null).getEnv().getPublicTruffleFile("tregex_" + this.dfa.getDebugDumpName() + "_" + this.dfa.getNfa().getAst().getSource().toFileName() + "_recording" + this.recordings.size() + ".json");
        Json.obj(Json.prop("dfa", this.dfa), Json.prop("recording", this.curRecording())).dump(file);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("recordings", this.recordings));
    }

    private static final class Recording
    implements JsonConvertible {
        private final TruffleString input;
        private final Encodings.Encoding encoding;
        private final int fromIndex;
        private int initialIndex;
        private final int maxIndex;
        private final boolean forward;
        private final int[] transitions;
        private final int[] cgPartialTransitions;

        private Recording(TruffleString input, Encodings.Encoding encoding, int fromIndex, int initialIndex, int maxIndex, boolean forward) {
            this.input = input;
            this.encoding = encoding;
            this.fromIndex = fromIndex;
            this.initialIndex = initialIndex;
            this.maxIndex = maxIndex;
            this.forward = forward;
            int codepoints = input.codePointLengthUncached(encoding.getTStringEncoding());
            this.transitions = new int[codepoints];
            this.cgPartialTransitions = new int[codepoints];
            Arrays.fill(this.transitions, -1);
            Arrays.fill(this.cgPartialTransitions, -1);
        }

        @CompilerDirectives.TruffleBoundary
        public void setInitialIndex(int initialIndex) {
            this.initialIndex = initialIndex;
        }

        @CompilerDirectives.TruffleBoundary
        public void recordTransition(int currentIndex, int transitionID) {
            this.transitions[this.toCodePointIndex((int)currentIndex)] = transitionID;
        }

        @CompilerDirectives.TruffleBoundary
        public void recordCGPartialTransition(int currentIndex, int cgPartialTransitionIndex) {
            this.cgPartialTransitions[this.toCodePointIndex((int)currentIndex)] = cgPartialTransitionIndex;
        }

        private int toCodePointIndex(int currentIndex) {
            return this.input.byteIndexToCodePointIndexUncached(0, currentIndex << this.encoding.getStride(), this.encoding.getTStringEncoding()) - (this.forward ? 0 : 1);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public JsonValue toJson() {
            JsonArray jsonTransitions = Json.array(new JsonConvertible[0]);
            if (this.forward) {
                for (int i = 0; i < this.transitions.length; ++i) {
                    this.appendJsonTransition(i, jsonTransitions);
                }
            } else {
                for (int i = this.transitions.length - 1; i >= 0; --i) {
                    this.appendJsonTransition(i, jsonTransitions);
                }
            }
            return Json.obj(Json.prop("input", this.input.toJavaStringUncached()), Json.prop("fromIndex", this.fromIndex), Json.prop("initialIndex", this.initialIndex), Json.prop("maxIndex", this.maxIndex), Json.prop("transitions", jsonTransitions));
        }

        private void appendJsonTransition(int i, JsonArray jsonTransitions) {
            if (this.transitions[i] >= 0) {
                jsonTransitions.append(Json.obj(Json.prop("currentIndex", i), Json.prop("transitionID", this.transitions[i]), Json.prop("cgPartialTransitionID", this.cgPartialTransitions[i])));
            }
        }
    }
}

