/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton;

import java.util.Arrays;
import java.util.PrimitiveIterator;
import java.util.stream.Stream;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.TransitionOp;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.LongArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.ObjectArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.Json;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonValue;

public class TransitionConstraint {
    public static final long[] NO_CONSTRAINTS = new long[0];
    public static final int anyLtMax = 0;
    public static final int allGeMax = 1;
    public static final int anyGeMin = 2;
    public static final int allLtMin = 3;
    public static final int anyLtMin = 4;
    public static final int allGeMin = 5;
    private static final byte POSSIBLE_VALUES_ALL = 7;
    private static final byte[] POSSIBLE_VALUES = new byte[]{7, 4, 7, 1, 7, 6};
    private static final byte[] SATISFYING_VALUES = new byte[]{3, 4, 6, 1, 1, 6};
    private static final int MASK_STATE_ID = 0x1FFFFFFF;
    private static final int MASK_KIND = 7;
    private static final int OFFSET_QUANTIFER_ID = 32;
    private static final int OFFSET_STATE_ID = 3;
    private static final int OFFSET_KIND = 0;

    public static long create(int quantID, int stateID, int kind) {
        assert ((stateID & 0x1FFFFFFF) == stateID);
        assert (kind < 6);
        return (long)quantID << 32 | (long)stateID << 3 | (long)kind << 0;
    }

    public static long setStateID(long constraint, int stateID) {
        return TransitionConstraint.create(TransitionConstraint.getQuantifierID(constraint), stateID, TransitionConstraint.getKind(constraint));
    }

    public static int getKind(long constraint) {
        return (int)(constraint >> 0 & 7L);
    }

    public static int getStateID(long constraint) {
        return (int)(constraint >> 3 & 0x1FFFFFFFL);
    }

    public static int getQuantifierID(long constraint) {
        return (int)(constraint >>> 32);
    }

    public static long getID(long constraint) {
        return constraint >> 3;
    }

    public static long not(long constraint) {
        return constraint ^ 1L;
    }

    public static boolean isNormalized(long[] constraints) {
        long prev = -1L;
        for (long constraint : constraints) {
            if (constraint <= prev) {
                return false;
            }
            prev = constraint;
        }
        return true;
    }

    public static long[] normalize(LongArrayBuffer constraints) {
        constraints.sort();
        LongArrayBuffer normalized = new LongArrayBuffer(constraints.length());
        long prev = -1L;
        PrimitiveIterator.OfLong ofLong = constraints.iterator();
        while (ofLong.hasNext()) {
            long constr = (Long)ofLong.next();
            if (constr == prev) continue;
            normalized.add(constr);
            prev = constr;
        }
        return normalized.toArray();
    }

    public static boolean areOpposite(long constraint1, long constraint2) {
        return (constraint1 ^ constraint2) == 1L;
    }

    public static MergeResult intersectAndSubtract(long[] lhs, long[] rhs) {
        int i;
        if (lhs.length == 0 && rhs.length == 0) {
            return MergeResult.Empty;
        }
        MergeResultBuilder resultBuilder = new MergeResultBuilder(lhs, rhs);
        int leftIndex = 0;
        int rightIndex = 0;
        while (leftIndex < lhs.length && rightIndex < rhs.length) {
            long leftConstraint = lhs[leftIndex];
            long rightConstraint = rhs[rightIndex];
            if (TransitionConstraint.areOpposite(leftConstraint, rightConstraint)) {
                return null;
            }
            if (leftConstraint == rightConstraint) {
                resultBuilder.addConstraintToLeft(leftConstraint);
                if (!resultBuilder.addToMiddleAndValidate(leftConstraint)) {
                    return null;
                }
                resultBuilder.addConstraintToRight(leftConstraint);
                ++leftIndex;
                ++rightIndex;
                continue;
            }
            if (leftConstraint > rightConstraint) {
                if (!resultBuilder.addToMiddleAndValidate(rightConstraint)) {
                    return null;
                }
                resultBuilder.addConstraintToRight(rightConstraint);
                resultBuilder.duplicateFormulaLeft(TransitionConstraint.not(rightConstraint), leftIndex);
                ++rightIndex;
                continue;
            }
            if (!resultBuilder.addToMiddleAndValidate(leftConstraint)) {
                return null;
            }
            resultBuilder.addConstraintToLeft(leftConstraint);
            resultBuilder.duplicateFormulaRight(TransitionConstraint.not(leftConstraint), rightIndex);
            ++leftIndex;
        }
        for (i = leftIndex; i < lhs.length; ++i) {
            long leftConstraint = lhs[i];
            if (!resultBuilder.addToMiddleAndValidate(leftConstraint)) {
                return null;
            }
            resultBuilder.addConstraintToLeft(leftConstraint);
            resultBuilder.duplicateFormulaRight(TransitionConstraint.not(leftConstraint), rightIndex);
        }
        for (i = rightIndex; i < rhs.length; ++i) {
            long rightConstraint = rhs[i];
            if (!resultBuilder.addToMiddleAndValidate(rightConstraint)) {
                return null;
            }
            resultBuilder.addConstraintToRight(rightConstraint);
            resultBuilder.duplicateFormulaLeft(TransitionConstraint.not(rightConstraint), leftIndex);
        }
        return resultBuilder.build();
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(long constraint) {
        int qID = TransitionConstraint.getQuantifierID(constraint);
        int stateID = TransitionConstraint.getStateID(constraint);
        int kind = TransitionConstraint.getKind(constraint);
        StringBuilder b = new StringBuilder("qID: %d, if".formatted(qID));
        switch (kind) {
            case 0: {
                b.append(" \u2203c \u2208 %d, c < max".formatted(stateID));
                break;
            }
            case 1: {
                b.append(" \u2200c \u2208 %d, c \u2265 max".formatted(stateID));
                break;
            }
            case 2: {
                b.append(" \u2203c \u2208 %d, c \u2265 min".formatted(stateID));
                break;
            }
            case 3: {
                b.append(" \u2200c \u2208 %d, c < min".formatted(stateID));
                break;
            }
            case 4: {
                b.append(" \u2203c \u2208 %d, c < min".formatted(stateID));
                break;
            }
            case 5: {
                b.append(" \u2200c \u2208 %d, c \u2265 min".formatted(stateID));
            }
        }
        return b.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(long[] constraints, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (long constraint : constraints) {
            if (!sb.isEmpty()) {
                sb.append(delimiter);
            }
            sb.append(TransitionConstraint.toString(constraint));
        }
        return sb.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static JsonValue toJson(long constraint) {
        return Json.val(TransitionConstraint.toString(constraint));
    }

    @CompilerDirectives.TruffleBoundary
    public static Stream<JsonValue> combineToJson(long[] constraints, long[] operations) {
        Stream<JsonValue> s1 = constraints.length == 0 ? Stream.of(Json.val("No Constraints")) : Arrays.stream(constraints).mapToObj(TransitionConstraint::toJson);
        Stream<JsonValue> s2 = Arrays.stream(operations).mapToObj(TransitionOp::toJson);
        return Stream.concat(s1, s2);
    }

    public record MergeResult(long[][] lhs, long[] middle, long[][] rhs) {
        public static final MergeResult Empty = new MergeResult(new long[0][], new long[0], new long[0][]);

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("MergeResult[\n  lhs: [\n");
            for (long[] c : this.lhs) {
                sb.append("    [\n      ").append(TransitionConstraint.toString(c, ",\n      ")).append("\n    ],\n");
            }
            sb.append("\n  ],\n  middle: [\n    ").append(TransitionConstraint.toString(this.middle, ",\n    ")).append("\n  ],\n  rhs: [\n");
            for (long[] c : this.rhs) {
                sb.append("    [\n      ").append(TransitionConstraint.toString(c, ",\n      ")).append("\n    ],\n");
            }
            return sb.append("\n  ],\n ]").toString();
        }
    }

    private static final class MergeResultBuilder {
        private final ObjectArrayBuffer<LongArrayBuffer> lhs = new ObjectArrayBuffer();
        private final LongArrayBuffer middle = new LongArrayBuffer();
        private final ObjectArrayBuffer<LongArrayBuffer> rhs = new ObjectArrayBuffer();
        private final long[] originalLhs;
        private final long[] originalRhs;

        private MergeResultBuilder(long[] originalLhs, long[] originalRhs) {
            this.originalLhs = originalLhs;
            this.originalRhs = originalRhs;
        }

        public void addConstraintToLeft(long constraint) {
            MergeResultBuilder.addToAll(this.lhs, constraint);
        }

        public void addConstraintToRight(long constraint) {
            MergeResultBuilder.addToAll(this.rhs, constraint);
        }

        private static void addToAll(ObjectArrayBuffer<LongArrayBuffer> to, long constraint) {
            int length = to.length();
            for (int i = 0; i < length; ++i) {
                LongArrayBuffer constraints = to.get(i);
                if (constraints == null) continue;
                constraints.add(constraint);
                if (MergeResultBuilder.validateAndSimplify(constraints)) continue;
                to.set(i, null);
            }
        }

        private static boolean validateAndSimplify(LongArrayBuffer constraints) {
            int iPreserved;
            long constraint;
            int length = constraints.length();
            long lastConstraint = constraints.get(length - 1);
            int sequenceLength = 1;
            long id = TransitionConstraint.getID(lastConstraint);
            for (int i = length - 2; i >= 0 && TransitionConstraint.getID(constraint = constraints.get(i)) == id; --i) {
                ++sequenceLength;
            }
            if (sequenceLength == 1) {
                return true;
            }
            int possibleValuesSoFar = 7;
            for (int i = iPreserved = length - sequenceLength; i < length; ++i) {
                int possibleValues = possibleValuesSoFar;
                for (int j = i + 1; j < length; ++j) {
                    possibleValues &= POSSIBLE_VALUES[TransitionConstraint.getKind(constraints.get(j))];
                }
                long curConstraint = constraints.get(i);
                int curKind = TransitionConstraint.getKind(curConstraint);
                byte curPossibleValues = POSSIBLE_VALUES[curKind];
                byte curSatisfyingValues = SATISFYING_VALUES[curKind];
                if ((possibleValues & curSatisfyingValues) == 0) {
                    return false;
                }
                possibleValuesSoFar &= curPossibleValues;
                if ((possibleValues & curPossibleValues) == possibleValues && (possibleValues & ~curSatisfyingValues) == 0) continue;
                constraints.set(iPreserved++, curConstraint);
            }
            constraints.setLength(iPreserved);
            return true;
        }

        private boolean addToMiddleAndValidate(long constraint) {
            this.middle.add(constraint);
            return MergeResultBuilder.validateAndSimplify(this.middle);
        }

        private static LongArrayBuffer copyUntil(long[] buffer, int to) {
            LongArrayBuffer result = new LongArrayBuffer(buffer.length);
            result.addAll(buffer, to);
            return result;
        }

        private void duplicateFormulaLeft(long appendConstraint, int leftIndex) {
            LongArrayBuffer newConstraints = MergeResultBuilder.copyUntil(this.originalLhs, leftIndex);
            newConstraints.add(appendConstraint);
            if (MergeResultBuilder.validateAndSimplify(newConstraints)) {
                this.lhs.add(newConstraints);
            }
        }

        private void duplicateFormulaRight(long appendConstraint, int rightIndex) {
            LongArrayBuffer newConstraints = MergeResultBuilder.copyUntil(this.originalRhs, rightIndex);
            newConstraints.add(appendConstraint);
            if (MergeResultBuilder.validateAndSimplify(newConstraints)) {
                this.rhs.add(newConstraints);
            }
        }

        private static int countNumberOfValid(ObjectArrayBuffer<LongArrayBuffer> constraintsList) {
            int result = 0;
            for (LongArrayBuffer constraints : constraintsList) {
                if (constraints == null) continue;
                ++result;
            }
            return result;
        }

        private static long[][] constraintsListToArray(ObjectArrayBuffer<LongArrayBuffer> constraintsList) {
            long[][] result = new long[MergeResultBuilder.countNumberOfValid(constraintsList)][];
            int i = 0;
            for (LongArrayBuffer constraints : constraintsList) {
                if (constraints == null) continue;
                result[i] = constraints.toArray();
                ++i;
            }
            return result;
        }

        private MergeResult build() {
            return new MergeResult(MergeResultBuilder.constraintsListToArray(this.lhs), this.middle.toArray(), MergeResultBuilder.constraintsListToArray(this.rhs));
        }
    }
}

